/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.WobbleDistribution;

class SimpleWobbleDistribution
implements WobbleDistribution {
    Symbol residue;
    Set nonWobbleBases;
    Distribution nonWobbleDist;
    Map wobbleDist;

    SimpleWobbleDistribution(Symbol residue, Set nonWobbleBases, Distribution nonWobbleDist, Map wobbleDist) throws NullPointerException, IllegalAlphabetException {
        if (residue == null || nonWobbleBases == null || nonWobbleDist == null || wobbleDist == null) {
            throw new NullPointerException();
        }
        if (!ProteinTools.getTAlphabet().contains(residue)) {
            throw new IllegalAlphabetException();
        }
        this.residue = residue;
        this.nonWobbleBases = nonWobbleBases;
        this.nonWobbleDist = nonWobbleDist;
        this.wobbleDist = wobbleDist;
    }

    @Override
    public Symbol getResidue() {
        return this.residue;
    }

    @Override
    public Set getNonWobbleBases() {
        return Collections.unmodifiableSet(this.nonWobbleBases);
    }

    @Override
    public Distribution getFrequencyOfNonWobbleBases() {
        return this.nonWobbleDist;
    }

    @Override
    public Distribution getWobbleFrequency(Symbol nonWobbleBases) {
        return (Distribution)this.wobbleDist.get(nonWobbleBases);
    }
}

