/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.io.SeqIOAdapter;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;

public class SimpleSymbolList
extends AbstractSymbolList
implements ChangeListener,
Serializable {
    private static final long serialVersionUID = -9015317520644706924L;
    private static int instanceCount;
    private static final int INCREMENT = 100;
    private Alphabet alphabet;
    private Symbol[] symbols;
    private int length;
    private boolean isView;
    private int viewOffset;
    private SymbolList referenceSymbolList;

    private void addListener() {
        SimpleSymbolList.incCount();
        this.alphabet.addChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
    }

    private static synchronized int incCount() {
        return ++instanceCount;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.alphabet.removeChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
        if (this.isView) {
            this.referenceSymbolList.removeChangeListener(this);
        }
    }

    public SimpleSymbolList(Alphabet alpha) {
        this.alphabet = alpha;
        this.length = 0;
        this.symbols = new Symbol[100];
        this.isView = false;
        this.viewOffset = 0;
        this.addListener();
    }

    public SimpleSymbolList(Alphabet alpha, List rList) throws IllegalSymbolException {
        this.alphabet = alpha;
        this.length = rList.size();
        this.symbols = new Symbol[this.length];
        int pos = 0;
        Iterator i = rList.iterator();
        while (i.hasNext()) {
            this.symbols[pos] = (Symbol)i.next();
            this.alphabet.validate(this.symbols[pos]);
            ++pos;
        }
        this.isView = false;
        this.viewOffset = 0;
        this.addListener();
    }

    public SimpleSymbolList(SymbolTokenization parser, String seqString) throws IllegalSymbolException {
        int chunkLength;
        this.symbols = parser.getTokenType() == SymbolTokenization.CHARACTER ? new Symbol[seqString.length()] : new Symbol[100];
        char[] charArray = new char[1024];
        int segLength = seqString.length();
        StreamParser stParser = parser.parseStream(new SSLIOListener());
        for (int charCount = 0; charCount < segLength; charCount += chunkLength) {
            chunkLength = Math.min(charArray.length, segLength - charCount);
            seqString.getChars(charCount, charCount + chunkLength, charArray, 0);
            stParser.characters(charArray, 0, chunkLength);
        }
        stParser.close();
        this.alphabet = parser.getAlphabet();
        this.isView = false;
        this.viewOffset = 0;
        this.addListener();
    }

    public SimpleSymbolList(SymbolList sl) {
        this.alphabet = sl.getAlphabet();
        this.length = sl.length();
        this.symbols = new Symbol[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.symbols[i] = sl.symbolAt(i + 1);
        }
        this.isView = false;
        this.viewOffset = 0;
        this.addListener();
    }

    public SimpleSymbolList(Symbol[] symbols, int length, Alphabet alphabet) {
        this.symbols = symbols;
        this.length = length;
        this.alphabet = alphabet;
        this.isView = false;
        this.viewOffset = 0;
        this.addListener();
    }

    private SimpleSymbolList(SimpleSymbolList orig, int start, int end) {
        this.alphabet = orig.alphabet;
        this.symbols = orig.symbols;
        this.length = end - start + 1;
        this.isView = true;
        this.viewOffset = start - 1;
        this.referenceSymbolList = orig;
        this.addListener();
    }

    @Override
    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public Symbol symbolAt(int pos) {
        try {
            return this.symbols[this.viewOffset + pos - 1];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("Index must be within [1.." + this.length() + "] : " + pos);
        }
    }

    @Override
    public SymbolList subList(int start, int end) {
        if (start < 1 || end > this.length()) {
            throw new IndexOutOfBoundsException("Sublist index out of bounds " + this.length() + ":" + start + "," + end);
        }
        if (end < start) {
            throw new IllegalArgumentException("end must not be lower than start: start=" + start + ", end=" + end);
        }
        SimpleSymbolList sl = new SimpleSymbolList(this, this.viewOffset + start, this.viewOffset + end);
        if (this.isView) {
            this.referenceSymbolList.addChangeListener(sl);
        } else {
            this.addChangeListener(sl);
        }
        return sl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void edit(Edit edit) throws IndexOutOfBoundsException, IllegalAlphabetException, ChangeVetoException {
        ChangeSupport cs;
        if (edit.pos + edit.length > this.length + 1 || edit.pos <= 0 || edit.length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (edit.replacement.getAlphabet() != this.alphabet && edit.replacement != SymbolList.EMPTY_LIST) {
            throw new IllegalAlphabetException();
        }
        ChangeEvent cevt = new ChangeEvent(this, SymbolList.EDIT, edit);
        ChangeSupport changeSupport = cs = this.getChangeSupport(SymbolList.EDIT);
        synchronized (changeSupport) {
            int newLength;
            cs.firePreChangeEvent(cevt);
            if (this.isView) {
                this.makeReal();
            }
            int posRightFragInSourceArray = edit.pos + edit.length - 1;
            int rightFragLength = this.length - posRightFragInSourceArray;
            int posRightFragInDestArray = posRightFragInSourceArray + edit.replacement.length() - edit.length;
            int posReplaceFragInDestArray = edit.pos - 1;
            int replaceFragLength = edit.replacement.length();
            int totalLength = this.length + replaceFragLength - edit.length + 100;
            Symbol[] dest = new Symbol[totalLength];
            System.arraycopy(this.symbols, 0, dest, 0, edit.pos - 1);
            if (rightFragLength > 0) {
                System.arraycopy(this.symbols, posRightFragInSourceArray, dest, posRightFragInDestArray, rightFragLength);
            }
            for (int i = 1; i <= replaceFragLength; ++i) {
                dest[posReplaceFragInDestArray + i - 1] = edit.replacement.symbolAt(i);
            }
            for (int j = newLength = this.length + replaceFragLength - edit.length; j < totalLength; ++j) {
                dest[j] = null;
            }
            this.length = newLength;
            this.symbols = dest;
            cs.firePostChangeEvent(cevt);
        }
    }

    @Override
    public void preChange(ChangeEvent cev) throws ChangeVetoException {
        Object change = cev.getChange();
        if (change != null && change instanceof Edit) {
            Edit e = (Edit)change;
            if (e.pos > this.viewOffset + this.length) {
                return;
            }
            if (e.pos < this.viewOffset && e.length - e.replacement.length() == 0) {
                return;
            }
            this.makeReal();
        }
    }

    @Override
    public void postChange(ChangeEvent cev) {
    }

    private void makeReal() {
        if (this.isView) {
            Symbol[] newSymbols = new Symbol[this.length];
            System.arraycopy(this.symbols, this.viewOffset, newSymbols, 0, this.length);
            this.symbols = newSymbols;
            this.isView = false;
            this.viewOffset = 0;
            this.referenceSymbolList.removeChangeListener(this);
            this.referenceSymbolList = null;
        }
    }

    public void addSymbol(Symbol sym) throws IllegalSymbolException, ChangeVetoException {
        try {
            SimpleSymbolList extraSymbol = new SimpleSymbolList(this.getAlphabet(), Collections.nCopies(1, sym));
            this.edit(new Edit(this.length() + 1, 0, extraSymbol));
        }
        catch (IllegalAlphabetException ex) {
            throw new IllegalSymbolException(ex, sym, "Couldn't add symbol");
        }
        catch (IndexOutOfBoundsException ex) {
            throw new BioError("Assertion failure: couldn't add symbol at end of list");
        }
    }

    public Symbol[] getSymbolArray() {
        return this.symbols;
    }

    static /* synthetic */ Symbol[] access$102(SimpleSymbolList x0, Symbol[] x1) {
        x0.symbols = x1;
        return x1;
    }

    private class SSLIOListener
    extends SeqIOAdapter {
        private SSLIOListener() {
        }

        @Override
        public void addSymbols(Alphabet alpha, Symbol[] syms, int start, int length) {
            if (SimpleSymbolList.this.symbols.length < SimpleSymbolList.this.length + length) {
                Symbol[] dest = new Symbol[(int)(1.5 * (double)SimpleSymbolList.this.length) + length];
                System.arraycopy(SimpleSymbolList.this.symbols, 0, dest, 0, SimpleSymbolList.this.length);
                System.arraycopy(syms, start, dest, SimpleSymbolList.this.length, length);
                SimpleSymbolList.access$102(SimpleSymbolList.this, dest);
            } else {
                System.arraycopy(syms, start, SimpleSymbolList.this.symbols, SimpleSymbolList.this.length, length);
            }
            SimpleSymbolList.this.length += length;
        }
    }
}

