/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.symbol.AbstractManyToOneTranslationTable;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class SimpleManyToOneTranslationTable
extends AbstractManyToOneTranslationTable
implements Serializable {
    private final Map transMap;
    private final Map revMap;
    private final FiniteAlphabet source;
    private final Alphabet target;

    @Override
    public Alphabet getSourceAlphabet() {
        return this.source;
    }

    @Override
    public Alphabet getTargetAlphabet() {
        return this.target;
    }

    @Override
    protected Symbol doTranslate(Symbol sym) {
        return (Symbol)this.transMap.get(sym);
    }

    @Override
    protected Set doUntranslate(Symbol sym) {
        return (Set)this.revMap.get(sym);
    }

    public void setTranslation(AtomicSymbol from, AtomicSymbol to) throws IllegalSymbolException {
        HashSet<AtomicSymbol> sourceSet;
        this.source.validate(from);
        this.target.validate(to);
        Symbol prevTransSymbol = this.doTranslate(from);
        if (prevTransSymbol != null) {
            Set prevUntransSet = (Set)this.revMap.get(prevTransSymbol);
            prevUntransSet.remove(from);
        }
        if ((sourceSet = (HashSet<AtomicSymbol>)this.revMap.get(to)) == null) {
            sourceSet = new HashSet<AtomicSymbol>();
            this.revMap.put(to, sourceSet);
        }
        sourceSet.add(from);
        this.transMap.put(from, to);
    }

    public SimpleManyToOneTranslationTable(FiniteAlphabet source, FiniteAlphabet target) {
        this.source = source;
        this.target = target;
        this.transMap = new HashMap();
        this.revMap = new HashMap();
    }
}

