/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Packing;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.AssertionFailure;

public class PackedSymbolList
extends AbstractSymbolList
implements Serializable {
    private static final byte BITS_PER_ELEMENT = 64;
    private final Packing packing;
    private final long[] syms;
    private final int length;
    private final byte symsPerElement;
    private final byte mask;
    private int currentMin = Integer.MAX_VALUE;
    private int currentMax = Integer.MIN_VALUE;
    private long currentWord;
    private int wordsize;

    @Override
    public Alphabet getAlphabet() {
        return this.packing.getAlphabet();
    }

    @Override
    public int length() {
        return this.length;
    }

    public PackedSymbolList(Packing packing, long[] syms, int length) {
        this.symsPerElement = (byte)(64 / packing.wordSize());
        this.packing = packing;
        this.syms = syms;
        this.length = length;
        this.mask = PackedSymbolList.calcMask(packing);
        this.wordsize = packing.wordSize();
    }

    public PackedSymbolList(Packing packing, SymbolList symList) throws IllegalAlphabetException {
        if (packing.getAlphabet() != symList.getAlphabet()) {
            throw new IllegalAlphabetException("Can't pack with alphabet " + packing.getAlphabet() + " and symbol list " + symList.getAlphabet());
        }
        try {
            long p;
            this.symsPerElement = (byte)(64 / packing.wordSize());
            this.packing = packing;
            this.length = symList.length();
            this.syms = new long[this.length / this.symsPerElement + (this.length % this.symsPerElement == 0 ? 0 : 1)];
            this.mask = PackedSymbolList.calcMask(packing);
            this.wordsize = packing.wordSize();
            int ii = 0;
            for (int i = 0; i < this.syms.length - 1; ++i) {
                long l = 0L;
                int jj = 0;
                for (int j = 0; j < this.symsPerElement; ++j) {
                    p = packing.pack(symList.symbolAt(ii + j + 1));
                    l |= p << (int)((long)jj);
                    jj += this.wordsize;
                }
                this.syms[i] = l;
                ii += this.symsPerElement;
            }
            if (this.syms.length > 0) {
                long l = 0L;
                ii = (this.syms.length - 1) * this.symsPerElement;
                int jMax = symList.length() % this.symsPerElement;
                if (jMax == 0) {
                    jMax = this.symsPerElement;
                }
                for (int j = 0; j < jMax; ++j) {
                    int jj = j * packing.wordSize();
                    p = packing.pack(symList.symbolAt(ii + j + 1));
                    l |= p << (int)((long)jj);
                }
                this.syms[this.syms.length - 1] = l;
            }
        }
        catch (IllegalSymbolException ise) {
            throw new AssertionFailure("Assertion Failure: Symbol got lost somewhere", ise);
        }
    }

    public PackedSymbolList(Packing packing, Symbol[] symbols, int length, Alphabet alfa) throws IllegalAlphabetException, IllegalArgumentException {
        if (packing.getAlphabet() != alfa) {
            throw new IllegalAlphabetException("Can't pack with alphabet " + packing.getAlphabet() + " and symbol list " + alfa);
        }
        if (symbols.length < length) {
            throw new IllegalArgumentException("Symbol array size is too small to get " + length + "symbols from.");
        }
        try {
            long p;
            this.symsPerElement = (byte)(64 / packing.wordSize());
            this.packing = packing;
            this.length = length;
            this.syms = new long[length / this.symsPerElement + (length % this.symsPerElement == 0 ? 0 : 1)];
            this.mask = PackedSymbolList.calcMask(packing);
            this.wordsize = packing.wordSize();
            int ii = 0;
            for (int i = 0; i < this.syms.length - 1; ++i) {
                long l = 0L;
                int jj = 0;
                for (int j = 0; j < this.symsPerElement; ++j) {
                    p = packing.pack(symbols[ii + j]);
                    l |= p << (int)((long)jj);
                    jj += this.wordsize;
                }
                this.syms[i] = l;
                ii += this.symsPerElement;
            }
            if (this.syms.length > 0) {
                long l = 0L;
                ii = (this.syms.length - 1) * this.symsPerElement;
                int jMax = length % this.symsPerElement;
                if (jMax == 0) {
                    jMax = this.symsPerElement;
                }
                for (int j = 0; j < jMax; ++j) {
                    int jj = j * packing.wordSize();
                    p = packing.pack(symbols[ii + j]);
                    l |= p << (int)((long)jj);
                }
                this.syms[this.syms.length - 1] = l;
            }
        }
        catch (IllegalSymbolException ise) {
            throw new AssertionFailure("Assertion Failure: Symbol got lost somewhere", ise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Symbol symbolAt(int indx) {
        long l;
        int offset;
        --indx;
        PackedSymbolList packedSymbolList = this;
        synchronized (packedSymbolList) {
            if (indx < this.currentMin || indx > this.currentMax) {
                int word = indx / this.symsPerElement;
                offset = indx % this.symsPerElement;
                this.currentMin = indx - offset;
                this.currentMax = this.currentMin + this.symsPerElement - 1;
                this.currentWord = this.syms[word];
            } else {
                offset = indx - this.currentMin;
            }
            l = this.currentWord;
        }
        int jj = offset * this.wordsize;
        try {
            return this.packing.unpack((byte)(l >> (int)((long)jj) & (long)this.mask));
        }
        catch (IllegalSymbolException ise) {
            throw new AssertionFailure("Could not unpack " + indx + " at word," + offset, ise);
        }
    }

    private static byte calcMask(Packing packing) {
        byte mask = 0;
        for (int i = 0; i < packing.wordSize(); ++i) {
            mask = (byte)(mask | 1 << i);
        }
        return mask;
    }

    public long[] getSyms() {
        return this.syms;
    }
}

