/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.projection;

import java.util.ArrayList;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.TemplateUtils;
import org.biojava.bio.seq.projection.Projection;
import org.biojava.bio.seq.projection.ProjectionContext;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.AssertionFailure;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public abstract class ProjectedFeature
implements Feature,
Projection {
    private final Feature feature;
    private final ProjectionContext context;

    public ProjectedFeature(Feature f, ProjectionContext ctx) {
        this.feature = f;
        this.context = ctx;
    }

    @Override
    public Feature getViewedFeature() {
        return this.feature;
    }

    @Override
    public ProjectionContext getProjectionContext() {
        return this.context;
    }

    @Override
    public Sequence getSequence() {
        return this.context.getSequence(this.getViewedFeature());
    }

    @Override
    public FeatureHolder getParent() {
        return this.context.getParent(this.feature);
    }

    @Override
    public SymbolList getSymbols() {
        Location loc = this.getLocation();
        Sequence seq = this.getSequence();
        if (loc.isContiguous()) {
            return seq.subList(loc.getMin(), loc.getMax());
        }
        ArrayList<SymbolList> res = new ArrayList<SymbolList>();
        Iterator<Location> i = loc.blockIterator();
        while (i.hasNext()) {
            Location l = i.next();
            res.add(seq.subList(l.getMin(), l.getMax()));
        }
        try {
            return new SimpleSymbolList(seq.getAlphabet(), res);
        }
        catch (IllegalSymbolException ex) {
            throw new BioError(ex);
        }
    }

    @Override
    public int countFeatures() {
        return this.getProjectedFeatures().countFeatures();
    }

    @Override
    public boolean containsFeature(Feature f) {
        return this.getProjectedFeatures().containsFeature(f);
    }

    protected FeatureHolder getProjectedFeatures() {
        return this.context.projectChildFeatures(this.feature, this);
    }

    @Override
    public Iterator features() {
        return this.getProjectedFeatures().features();
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff) {
        FeatureFilter.And membershipFilter = new FeatureFilter.And(new FeatureFilter.Not(FeatureFilter.top_level), new FeatureFilter.ContainedByLocation(this.getLocation()));
        if (FilterUtils.areDisjoint(ff, membershipFilter)) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        return this.getProjectedFeatures().filter(ff);
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        FeatureFilter.ContainedByLocation membershipFilter = new FeatureFilter.ContainedByLocation(this.getLocation());
        if (FilterUtils.areDisjoint(ff, membershipFilter)) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        return this.getProjectedFeatures().filter(ff, recurse);
    }

    @Override
    public Feature createFeature(Feature.Template temp) throws ChangeVetoException, BioException {
        return this.context.createFeature(this.feature, temp);
    }

    @Override
    public void removeFeature(Feature f) throws ChangeVetoException, BioException {
        this.context.removeFeature(this.feature, f);
    }

    @Override
    public Feature.Template makeTemplate() {
        try {
            return TemplateUtils.makeTemplate(this);
        }
        catch (BioException be) {
            throw new AssertionFailure("Could not build/populate template for: " + this.toString() + " ", be);
        }
    }

    public int hashCode() {
        return this.makeTemplate().hashCode();
    }

    public boolean equals(Object o) {
        Feature fo;
        if (o instanceof Feature && (fo = (Feature)o).getSequence().equals(this.getSequence())) {
            return this.makeTemplate().equals(fo.makeTemplate());
        }
        return false;
    }

    @Override
    public void addChangeListener(ChangeListener cl) {
        this.addChangeListener(cl, ChangeType.UNKNOWN);
    }

    @Override
    public void removeChangeListener(ChangeListener cl) {
        this.removeChangeListener(cl, ChangeType.UNKNOWN);
    }

    @Override
    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        this.context.addChangeListener(this.feature, cl, ct);
    }

    @Override
    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        this.context.removeChangeListener(this.feature, cl, ct);
    }

    @Override
    public boolean isUnchanging(ChangeType ct) {
        return this.feature.isUnchanging(ct);
    }
}

