/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.game12;

import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.game.ElementRecognizer;
import org.biojava.bio.seq.io.game12.GAMEAnnotationHandler;
import org.biojava.bio.seq.io.game12.GAMESeqHandler;
import org.biojava.bio.seq.io.game12.StAXFeatureHandler;
import org.biojava.utils.stax.StAXContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GAMEHandler
extends StAXFeatureHandler {
    public GAMEHandler(SeqIOListener listener) {
        this.staxenv = this;
        this.listener = listener;
        super.addHandler(new ElementRecognizer.ByLocalName("seq"), GAMESeqHandler.GAME_SEQ_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("annotation"), GAMEAnnotationHandler.GAME_ANNOTATION_HANDLER_FACTORY);
    }

    @Override
    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
        if (!localName.equals("game")) {
            throw new SAXException("first element of file is not a game element");
        }
        String version = attrs.getValue("version");
        if (!version.equals("1.2")) {
            throw new SAXException("GAME version is not 1.2");
        }
        try {
            this.listener.startSequence();
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw new SAXException("error in GAMEAnnotationHandler.");
        }
    }

    @Override
    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler contentHandler) throws SAXException {
        try {
            this.listener.endSequence();
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw new SAXException("error in GAMEAnnotationHandler.");
        }
    }
}

