/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.game12;

import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.game.ElementRecognizer;
import org.biojava.bio.seq.io.game12.GAMEDbxrefHandler;
import org.biojava.bio.seq.io.game12.StAXFeatureHandler;
import org.biojava.bio.seq.io.game12.StAXHandlerFactory;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StringElementHandlerBase;
import org.xml.sax.SAXException;

public class GAMEAspectHandler
extends StAXFeatureHandler {
    private String aspectDbxrefDb = null;
    private String aspectDbxrefId = null;
    private String function = null;
    public static final StAXHandlerFactory GAME_ASPECT_HANDLER_FACTORY = new StAXHandlerFactory(){

        @Override
        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new GAMEAspectHandler(staxenv);
        }
    };

    GAMEAspectHandler(StAXFeatureHandler staxenv) {
        super(staxenv);
        super.addHandler(new ElementRecognizer.ByLocalName("function"), new StAXHandlerFactory(){

            @Override
            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new FunctionHandler();
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("dbxref"), new StAXHandlerFactory(){

            @Override
            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new DbxrefHandler(staxenv);
            }
        });
    }

    @Override
    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler contentHandler) throws SAXException {
        if (this.aspectDbxrefDb == null || this.aspectDbxrefId == null || this.function == null) {
            return;
        }
        try {
            this.listener.addFeatureProperty("aspect:" + this.function, "dbxref:" + this.aspectDbxrefDb + "//" + this.aspectDbxrefId);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw new SAXException("unexpected exception while adding <aspect> as a feature property.");
        }
    }

    private class FunctionHandler
    extends StringElementHandlerBase {
        private FunctionHandler() {
        }

        @Override
        protected void setStringValue(String s) {
            GAMEAspectHandler.this.function = s.trim();
        }
    }

    private class DbxrefHandler
    extends GAMEDbxrefHandler {
        private DbxrefHandler(StAXFeatureHandler staxenv) {
            super(staxenv);
        }

        @Override
        public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler contentHandler) throws SAXException {
            super.endElementHandler(nsURI, localName, qName, contentHandler);
            GAMEAspectHandler.this.aspectDbxrefDb = this.db_xref_db;
            GAMEAspectHandler.this.aspectDbxrefId = this.db_xref_id;
        }
    }
}

