/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.game;

import java.util.ListIterator;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.game.ElementRecognizer;
import org.biojava.bio.seq.io.game.GAMEFeatureCallbackItf;
import org.biojava.bio.seq.io.game.GAMEFeatureSpanHandler;
import org.biojava.bio.seq.io.game.GAMENameCallbackItf;
import org.biojava.bio.seq.io.game.GAMENamePropHandler;
import org.biojava.bio.seq.io.game.GAMETranscriptCallbackItf;
import org.biojava.bio.seq.io.game.StAXFeatureHandler;
import org.biojava.bio.seq.io.game.StAXHandlerFactory;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.stax.StAXContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GAMEFeatureSetHandler
extends StAXFeatureHandler
implements GAMENameCallbackItf,
GAMETranscriptCallbackItf {
    private Location transcriptRange;
    private StAXFeatureHandler staxenv;
    public static final StAXHandlerFactory GAME_FEATURESET_HANDLER_FACTORY = new StAXHandlerFactory(){

        @Override
        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new GAMEFeatureSetHandler(staxenv);
        }
    };

    GAMEFeatureSetHandler(StAXFeatureHandler staxenv) {
        this.staxenv = staxenv;
        this.featureListener = staxenv.featureListener;
        this.setHandlerCharacteristics("feature_set", true);
        super.addHandler(new ElementRecognizer.ByLocalName("name"), GAMENamePropHandler.GAME_NAME_PROP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("feature_span"), GAMEFeatureSpanHandler.GAME_FEATURESPAN_HANDLER_FACTORY);
    }

    @Override
    public void NameSetStringValue(String s) {
        if (!this.featureTemplate.annotation.containsProperty("id")) {
            try {
                this.featureTemplate.annotation.setProperty("id", s);
            }
            catch (ChangeVetoException cve) {
                System.out.println("GAMEFeatureSetHandler: change vetoed");
            }
        }
    }

    @Override
    public void reportExon(RangeLocation range, StrandedFeature.Strand strand) {
        ((StrandedFeature.Template)this.featureTemplate).strand = strand;
        this.transcriptRange = this.transcriptRange == null ? range : this.transcriptRange.union(range);
    }

    @Override
    protected Feature.Template createTemplate() {
        StrandedFeature.Template st = new StrandedFeature.Template();
        st.type = "transcript";
        st.strand = StrandedFeature.UNKNOWN;
        st.annotation = new SmallAnnotation();
        return st;
    }

    @Override
    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
        String s = attrs.getValue("id");
        if (s != null) {
            try {
                this.featureTemplate.annotation.setProperty("id", s);
            }
            catch (ChangeVetoException cve) {
                System.err.println("GAMEFeatureSetHandler: change vetoed");
            }
        }
    }

    @Override
    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler handler) {
        this.featureTemplate.location = this.transcriptRange != null ? this.transcriptRange : Location.empty;
        int currLevel = this.staxenv.getLevel();
        if (currLevel >= 1) {
            ListIterator li = this.staxenv.getHandlerStackIterator(currLevel);
            while (li.hasPrevious()) {
                Object ob = li.previous();
                if (!(ob instanceof GAMEFeatureCallbackItf)) continue;
                ((GAMEFeatureCallbackItf)ob).reportFeature(this.featureTemplate.location);
                ((GAMEFeatureCallbackItf)ob).reportStrand(((StrandedFeature.Template)this.featureTemplate).strand);
                return;
            }
        }
    }
}

