/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.agave;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.agave.AGAVECallbackItf;
import org.biojava.bio.seq.io.agave.AGAVEChromosomeCallbackItf;
import org.biojava.bio.seq.io.agave.AGAVEContigHandler;
import org.biojava.bio.seq.io.agave.AGAVEViewPropHandler;
import org.biojava.bio.seq.io.agave.ElementRecognizer;
import org.biojava.bio.seq.io.agave.SequenceHandler;
import org.biojava.bio.seq.io.agave.StAXContentHandler;
import org.biojava.bio.seq.io.agave.StAXFeatureHandler;
import org.biojava.bio.seq.io.agave.StAXHandlerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AGAVEChromosomeHandler
extends StAXFeatureHandler
implements AGAVEChromosomeCallbackItf,
SequenceHandler {
    public static final StAXHandlerFactory AGAVE_CHROMOSOME_HANDLER_FACTORY = new StAXHandlerFactory(){

        @Override
        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new AGAVEChromosomeHandler();
        }
    };
    private List sequenceSet;
    private String chromNum;
    private String chromLen;

    AGAVEChromosomeHandler() {
        this.setHandlerCharacteristics("chromosome", true);
        this.sequenceSet = new ArrayList(1);
        super.addHandler(new ElementRecognizer.ByLocalName("view"), AGAVEViewPropHandler.AGAVE_VIEW_PROP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("contig"), AGAVEContigHandler.AGAVE_CONTIG_HANDLER_FACTORY);
    }

    @Override
    public void reportSequence(Sequence sequence) {
        this.sequenceSet.add(sequence);
    }

    public Iterator getSequences() {
        return this.sequenceSet.iterator();
    }

    @Override
    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
        this.chromNum = attrs.getValue("number");
        this.chromLen = attrs.getValue("length");
    }

    @Override
    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
        try {
            ListIterator i = this.sequenceSet.listIterator();
            while (i.hasNext()) {
                Sequence seq = (Sequence)i.next();
                if (this.chromNum != null) {
                    seq.getAnnotation().setProperty("chromosome_number", this.chromNum);
                }
                if (this.chromLen != null) {
                    seq.getAnnotation().setProperty("chromosome_length", this.chromLen);
                }
                this.appendToTop(seq, this.staxenv);
            }
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
    }

    private void appendToTop(Sequence sequence, StAXFeatureHandler staxenv) {
        if (staxenv instanceof AGAVECallbackItf) {
            ((AGAVECallbackItf)((Object)staxenv)).reportSequence(sequence);
            return;
        }
        this.appendToTop(sequence, staxenv.staxenv);
    }
}

