/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.io.GenbankFileFormer;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class ProteinRefSeqFileFormer
extends GenbankFileFormer {
    protected ProteinRefSeqFileFormer() {
        super(System.out);
    }

    protected ProteinRefSeqFileFormer(PrintStream theStream) {
        super(theStream);
    }

    @Override
    public void addSymbols(Alphabet theAlphabet, Symbol[] theSymbols, int theStart, int theLength) throws IllegalAlphabetException {
        String newLine = System.getProperty("line.separator");
        this.getPrintStream().print("ORIGIN" + newLine);
        List brokenLines = this.breakSymbolArray(theAlphabet, theSymbols, theStart, theLength);
        Iterator iterator = brokenLines.iterator();
        String leader = "     ";
        while (iterator.hasNext()) {
            this.getPrintStream().print(leader + iterator.next() + newLine);
        }
        this.getPrintStream().println("//" + newLine);
    }

    @Override
    public void startFeature(Feature.Template templ) throws ParseException {
        String leader = "                     ";
        int strand = 0;
        StringBuffer theBuffer = new StringBuffer();
        this.formatLocationBlock(theBuffer, templ.location, strand, leader, 80);
        theBuffer.replace(5, 5 + templ.type.length(), templ.type);
        this.getPrintStream().println(theBuffer);
    }

    protected List breakSymbolArray(Alphabet theAlphabet, Symbol[] theSymbols, int theStart, int theLength) throws IllegalAlphabetException {
        SymbolTokenization tokenization;
        ArrayList<String> returnList = new ArrayList<String>(theLength / 60 + 1);
        int blockCount = 0;
        int blockIndex = 0;
        StringBuffer tempString = new StringBuffer();
        try {
            tokenization = theAlphabet.getTokenization("token");
        }
        catch (BioException ex) {
            throw new BioError("Expected tokenization", ex);
        }
        for (int i = theStart; i < theStart + theLength; ++i) {
            try {
                theAlphabet.validate(theSymbols[i]);
            }
            catch (IllegalSymbolException e) {
                throw new IllegalAlphabetException(e);
            }
            if (blockIndex == 10) {
                tempString.append(' ');
                blockIndex = 0;
                ++blockCount;
            }
            if (blockCount == 6) {
                returnList.add(tempString.substring(0));
                tempString.setLength(0);
                blockCount = 0;
                blockIndex = 0;
            }
            try {
                tempString.append(tokenization.tokenizeSymbol(theSymbols[i]));
            }
            catch (IllegalSymbolException e) {
                throw new IllegalAlphabetException(e);
            }
            ++blockIndex;
        }
        if (tempString.length() != 0) {
            returnList.add(tempString.substring(0));
        }
        return returnList;
    }
}

