/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import org.biojava.bio.seq.io.WordTokenization;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.IntegerAlphabet;
import org.biojava.bio.symbol.Symbol;

public class IntegerTokenization
extends WordTokenization {
    public IntegerTokenization() {
        super(IntegerAlphabet.getInstance());
    }

    @Override
    public Symbol parseToken(String seq) throws IllegalSymbolException {
        try {
            int i = Integer.parseInt(seq);
            return ((IntegerAlphabet)this.getAlphabet()).getSymbol(i);
        }
        catch (NumberFormatException ex) {
            throw new IllegalSymbolException(ex, "Couldn't parse " + seq);
        }
    }

    @Override
    public String tokenizeSymbol(Symbol sym) throws IllegalSymbolException {
        this.getAlphabet().validate(sym);
        return sym.getName();
    }
}

