/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.SymbolReader;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.ChunkedSymbolList;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SimpleSymbolListFactory;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListFactory;
import org.biojava.bio.symbol.SymbolListViews;

public class ChunkedSymbolListFactory {
    private static final int AUTO_SELECT = 1;
    private static final int SUPPLIED_FACTORY = 2;
    private static final int CHUNK_SIZE = 16384;
    private final SymbolListFactory userSymListFactory;
    private SymbolListFactory currSymListFactory = null;
    private Alphabet alfa;
    private Symbol[] headChunk;
    private int headChunkPos = 0;
    private List chunkL = new ArrayList();
    private int symCount = 0;
    private int opMode = 2;
    private int threshold = 0x100000;
    private boolean canDoMake = true;

    public ChunkedSymbolListFactory(SymbolListFactory symListFactory) {
        this.opMode = 2;
        this.userSymListFactory = symListFactory;
        this.currSymListFactory = symListFactory;
    }

    public ChunkedSymbolListFactory(SymbolListFactory userSymListFactory, int threshold) {
        this.opMode = 1;
        if (threshold > 0) {
            this.threshold = threshold;
        }
        this.userSymListFactory = userSymListFactory;
        this.currSymListFactory = new SimpleSymbolListFactory();
    }

    public void addSymbols(Alphabet alfa, Symbol[] syms, int pos, int len) throws IllegalArgumentException, IllegalAlphabetException {
        this.canDoMake = false;
        if (this.alfa == null) {
            this.alfa = alfa;
        } else if (this.alfa != alfa) {
            throw new IllegalAlphabetException("Alphabet changed!");
        }
        this.symCount += len;
        if (this.opMode == 1 && this.currSymListFactory != this.userSymListFactory && this.symCount > this.threshold) {
            this.useSuppliedSymListFactory();
        }
        if (this.headChunk == null) {
            this.headChunk = new Symbol[16384];
            this.headChunkPos = 0;
        }
        int ipos = 0;
        while (ipos < len) {
            if (this.headChunkPos == 16384) {
                for (int i = 0; i < 16384; ++i) {
                    if (this.headChunk[i] != null) continue;
                    throw new IllegalArgumentException("symbols supplied are not tiling contiguously.");
                }
                this.chunkL.add(this.currSymListFactory.makeSymbolList(this.headChunk, 16384, alfa));
                this.headChunkPos = 0;
                this.headChunk = new Symbol[16384];
            }
            int read = Math.min(len - ipos, 16384 - this.headChunkPos);
            System.arraycopy(syms, pos + ipos, this.headChunk, this.headChunkPos, read);
            ipos += read;
            this.headChunkPos += read;
        }
    }

    private void clearState() {
        this.canDoMake = true;
        this.headChunk = null;
        this.headChunkPos = 0;
        this.symCount = 0;
        this.chunkL = new ArrayList();
        this.alfa = null;
        if (this.opMode == 1) {
            this.currSymListFactory = new SimpleSymbolListFactory();
        }
    }

    public void useSuppliedSymListFactory() {
        this.currSymListFactory = this.userSymListFactory;
        int size = this.chunkL.size();
        ArrayList<SymbolList> temp = new ArrayList<SymbolList>(size);
        for (int i = 0; i < size; ++i) {
            Symbol[] symArray;
            SymbolList symList = (SymbolList)this.chunkL.get(i);
            int symListLen = symList.length();
            if (symList instanceof SimpleSymbolList) {
                symArray = ((SimpleSymbolList)symList).getSymbolArray();
            } else {
                symArray = new Symbol[symListLen];
                for (int j = 1; j <= symList.length(); ++j) {
                    symArray[j - 1] = symList.symbolAt(j);
                }
            }
            try {
                temp.add(this.currSymListFactory.makeSymbolList(symArray, symListLen, this.alfa));
                continue;
            }
            catch (IllegalAlphabetException illegalAlphabetException) {
                // empty catch block
            }
        }
        this.chunkL = temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SymbolList makeSymbolList() throws IllegalAlphabetException {
        try {
            if (this.chunkL.size() == 0) {
                Object oldChunk;
                if (this.headChunkPos == 0) {
                    SymbolList symbolList = SymbolListViews.emptyList(this.alfa);
                    return symbolList;
                }
                if (this.headChunkPos < 16384) {
                    oldChunk = this.headChunk;
                    this.headChunk = new Symbol[this.headChunkPos];
                    System.arraycopy(oldChunk, 0, this.headChunk, 0, this.headChunkPos);
                }
                oldChunk = new SimpleSymbolList(this.headChunk, this.headChunkPos, this.alfa);
                return oldChunk;
            }
            if (this.headChunkPos != 0) {
                this.chunkL.add(this.currSymListFactory.makeSymbolList(this.headChunk, this.headChunkPos, this.alfa));
            }
            SymbolList[] symListArray = new SymbolList[this.chunkL.size()];
            for (int cnum = 0; cnum < this.chunkL.size(); ++cnum) {
                symListArray[cnum] = (SymbolList)this.chunkL.get(cnum);
            }
            int length = (this.chunkL.size() - 1) * 16384 + this.headChunkPos;
            ChunkedSymbolList chunkedSymbolList = new ChunkedSymbolList(symListArray, 16384, length, this.alfa);
            return chunkedSymbolList;
        }
        finally {
            this.clearState();
        }
    }

    public SymbolList make(SymbolReader sr) throws IOException, IllegalSymbolException, IllegalAlphabetException, BioException {
        if (!this.canDoMake) {
            throw new BioException("you can't use make() and addSymbol() simultaneously.");
        }
        this.chunkL = new ArrayList();
        this.headChunk = new Symbol[16384];
        this.headChunkPos = 0;
        this.alfa = sr.getAlphabet();
        while (sr.hasMoreSymbols()) {
            if (this.headChunkPos == 16384) {
                this.chunkL.add(this.currSymListFactory.makeSymbolList(this.headChunk, 16384, sr.getAlphabet()));
                this.headChunkPos = 0;
            }
            int read = sr.readSymbols(this.headChunk, this.headChunkPos, 16384 - this.headChunkPos);
            this.headChunkPos += read;
        }
        this.clearState();
        return this.makeSymbolList();
    }
}

