/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.Unchangeable;

public class AlternateTokenization
extends Unchangeable
implements SymbolTokenization,
Serializable {
    private Alphabet alphabet;
    private Map symbolsToStrings = new HashMap();
    private boolean caseSensitive;
    private boolean initiated = false;
    private int width = 0;

    public AlternateTokenization(Alphabet alpha, boolean caseSensitive) {
        this.alphabet = alpha;
        this.caseSensitive = caseSensitive;
    }

    @Override
    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    @Override
    public SymbolTokenization.TokenType getTokenType() {
        return FIXEDWIDTH;
    }

    @Override
    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    private synchronized void init(String str) {
        if (this.initiated) {
            return;
        }
        this.width = str.length();
        this.initiated = true;
    }

    public int getWidth() {
        if (!this.initiated) {
            throw new IllegalStateException("Tokenization not initialize yet");
        }
        return this.width;
    }

    public void bindSymbol(Symbol s, String str) {
        if (!this.initiated) {
            this.init(str);
        }
        if (str.length() != this.width) {
            throw new IllegalArgumentException("This tokenization must have all its tokens with the same size");
        }
        if (!this.symbolsToStrings.containsKey(s)) {
            this.symbolsToStrings.put(s, str);
        }
    }

    @Override
    public Symbol parseToken(String token) throws IllegalSymbolException {
        throw new UnsupportedOperationException("AlternateTokenization are for writing only");
    }

    @Override
    public String tokenizeSymbol(Symbol s) throws IllegalSymbolException {
        String str = (String)this.symbolsToStrings.get(s);
        if (str == null) {
            Alphabet alpha = this.getAlphabet();
            this.alphabet.validate(s);
            if (alpha instanceof FiniteAlphabet) {
                str = (String)this.symbolsToStrings.get(AlphabetManager.getAllAmbiguitySymbol((FiniteAlphabet)alpha));
            }
            if (str == null) {
                throw new IllegalSymbolException("No mapping for symbol " + s.getName());
            }
        }
        return str;
    }

    @Override
    public String tokenizeSymbolList(SymbolList sl) throws IllegalAlphabetException {
        if (sl.getAlphabet() != this.getAlphabet()) {
            throw new IllegalAlphabetException("Alphabet " + sl.getAlphabet().getName() + " does not match " + this.getAlphabet().getName());
        }
        StringBuffer sb = new StringBuffer();
        Iterator<Symbol> i = sl.iterator();
        while (i.hasNext()) {
            Symbol sym = i.next();
            try {
                String str = this.tokenizeSymbol(sym);
                sb.append(str);
            }
            catch (IllegalSymbolException ex) {
                throw new IllegalAlphabetException(ex, "Couldn't tokenize");
            }
        }
        return sb.substring(0);
    }

    @Override
    public StreamParser parseStream(SeqIOListener listener) {
        throw new UnsupportedOperationException("AlternateTokenization are for writing only");
    }
}

