/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceTools;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.projection.ProjectedFeatureHolder;
import org.biojava.bio.seq.projection.Projection;
import org.biojava.bio.seq.projection.TranslateFlipContext;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.utils.ChangeVetoException;

public class RevCompSequence
extends SimpleSequence {
    private ProjectedFeatureHolder pfh;
    protected Sequence origSeq;

    public RevCompSequence(Sequence seq) throws IllegalAlphabetException {
        this(seq, seq.getURN(), seq.getName(), seq.getAnnotation());
    }

    public RevCompSequence(Sequence seq, String urn, String name, Annotation annotation) throws IllegalAlphabetException {
        super(DNATools.reverseComplement(seq), urn, name, annotation);
        this.pfh = new ProjectedFeatureHolder(new TranslateFlipContext((FeatureHolder)this, (FeatureHolder)seq, seq.length() + 1, true));
        this.origSeq = seq;
    }

    @Override
    public void edit(Edit e) throws ChangeVetoException, IndexOutOfBoundsException {
        int pos = this.length() - (e.pos + e.length) + 2;
        Edit newE = null;
        try {
            newE = new Edit(pos, e.length, DNATools.reverseComplement(e.replacement));
            this.origSeq.edit(newE);
        }
        catch (IllegalAlphabetException iae) {
            throw new BioError("Error while editing RevCompSequence " + iae.getMessage());
        }
    }

    public Iterator features() {
        return this.pfh.features();
    }

    @Override
    public int countFeatures() {
        return this.pfh.countFeatures();
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff) {
        return this.pfh.filter(ff);
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        return this.pfh.filter(ff, recurse);
    }

    @Override
    public boolean containsFeature(Feature f) {
        return this.pfh.containsFeature(f) || this.origSeq.containsFeature(f);
    }

    @Override
    public void removeFeature(Feature f) throws ChangeVetoException, BioException {
        this.pfh.removeFeature(f);
    }

    @Override
    public Feature createFeature(Feature.Template ft) throws ChangeVetoException, BioException {
        return this.pfh.getContext().createFeature(ft);
    }

    public Feature getFeatureFromOriginal(Feature f) {
        return ((Projection)((Object)f)).getViewedFeature();
    }

    public Object clone() {
        SimpleSymbolList sl = new SimpleSymbolList(this);
        SimpleSequence newSeq = new SimpleSequence(sl, this.getURN(), this.getName(), this.getAnnotation());
        try {
            SequenceTools.addAllFeatures(newSeq, this);
        }
        catch (BioException e) {
            throw new BioError("Error while cloning RevCompSequenece: " + e.getMessage());
        }
        catch (ChangeVetoException cve) {
            throw new BioError("Couldn't modify newly created SimpleSequence", cve);
        }
        return newSeq;
    }
}

