/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.distributed;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.program.gff.GFFEntrySet;
import org.biojava.bio.program.gff.GFFRecord;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.MergeFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.distributed.DistDataSource;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.symbol.DummySymbolList;
import org.biojava.utils.ChangeVetoException;

public class GFFDataSource
implements DistDataSource {
    private GFFEntrySet gffe;
    private Set ids;
    private Map id2seq;
    private MergeFeatureHolder delegateFH;

    public GFFDataSource(GFFEntrySet gffe) {
        this.gffe = gffe;
        this.id2seq = new HashMap();
        this.delegateFH = new MergeFeatureHolder();
    }

    @Override
    public boolean hasSequence(String id) throws BioException {
        return false;
    }

    @Override
    public boolean hasFeatures(String id) throws BioException {
        return this.ids(false).contains(id);
    }

    @Override
    public FeatureHolder getFeatures(FeatureFilter ff) throws BioException {
        return this.getDelegateFH(true).filter(ff);
    }

    @Override
    public FeatureHolder getFeatures(String id, FeatureFilter ff, boolean recurse) throws BioException {
        if (!this.hasFeatures(id)) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        Sequence seq = this.populateDelegateFH(id);
        return seq.filter(ff, recurse);
    }

    private Sequence populateDelegateFH(String id) {
        Sequence seq = (Sequence)this.id2seq.get(id);
        if (seq == null) {
            DummySymbolList dummy = new DummySymbolList(DNATools.getDNA(), 1000000000);
            seq = new SimpleSequence(dummy, id, id, Annotation.EMPTY_ANNOTATION);
            try {
                seq = this.gffe.getAnnotator().annotate(seq);
                this.delegateFH.addFeatureHolder(seq);
                this.id2seq.put(id, seq);
            }
            catch (ChangeVetoException cve) {
                throw new BioError(cve);
            }
            catch (BioException be) {
                throw new BioError(be);
            }
        }
        return seq;
    }

    private FeatureHolder getDelegateFH(boolean populate) throws BioException {
        if (populate) {
            Iterator i = this.ids(true).iterator();
            while (i.hasNext()) {
                this.populateDelegateFH((String)i.next());
            }
        }
        return this.delegateFH;
    }

    @Override
    public Sequence getSequence(String id) throws BioException {
        throw new BioException();
    }

    @Override
    public Set ids(boolean topLevel) throws BioException {
        if (this.ids == null) {
            HashSet<String> _ids = new HashSet<String>();
            Iterator i = this.gffe.lineIterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof GFFRecord)) continue;
                GFFRecord rec = (GFFRecord)o;
                _ids.add(rec.getSeqName());
            }
            this.ids = Collections.unmodifiableSet(_ids);
        }
        return this.ids;
    }
}

