/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

public class FetchURL {
    String baseURL;
    String db;
    String rettype;
    String retmode;

    public FetchURL(String databaseName, String format) {
        if (databaseName.trim().equalsIgnoreCase("genbank") || databaseName.trim().equalsIgnoreCase("nucleotide")) {
            this.db = "nucleotide";
            this.rettype = "gb";
            this.retmode = format;
        } else if (databaseName.trim().equalsIgnoreCase("genpept") || databaseName.trim().equalsIgnoreCase("protein")) {
            this.db = "protein";
            this.rettype = "gp";
            this.retmode = format;
        } else if (databaseName.trim().equalsIgnoreCase("swiss-prot")) {
            this.db = "swiss-prot";
        } else if (databaseName.trim().equalsIgnoreCase("pubmed")) {
            this.db = "pubmed";
            this.rettype = "abstract";
            this.retmode = format;
        } else if (databaseName.trim().equalsIgnoreCase("locuslink")) {
            throw new IllegalArgumentException("NCBI LocusLink was replaced by Entrez Gene in 2005. NCBI no longer provides LocusLink, and has also discontinued its URL redirect service.");
        }
    }

    public String getbaseURL() {
        if (this.db.equalsIgnoreCase("Genbank") || this.db.equalsIgnoreCase("nucleotide") || this.db.equalsIgnoreCase("Genpept") || this.db.equalsIgnoreCase("protein") || this.db.equalsIgnoreCase("pubmed")) {
            this.baseURL = "https://www.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?";
        } else if (this.db.equalsIgnoreCase("Swiss-prot")) {
            this.baseURL = "http://us.expasy.org/cgi-bin/get-sprot-raw.pl?";
        }
        return this.baseURL;
    }

    public String getDB() {
        return "db=" + this.db;
    }

    public String getReturnFormat() {
        return "rettype=" + this.rettype + "&retmode=" + this.retmode;
    }

    public String getRetrievalType() {
        return this.rettype;
    }

    public String getRetrievalMode() {
        return this.retmode;
    }
}

