/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Collections;
import java.util.Iterator;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;
import org.biojava.utils.Unchangeable;

public interface FeatureHolder
extends Changeable {
    public static final ChangeType FEATURES = new ChangeType("Features have been added or removed", "org.biojava.bio.seq.FeatureHolder", "FEATURES");
    public static final ChangeType SCHEMA = new ChangeType("The schema has changed", "org.biojava.bio.seq.FeatureHolder", "SCHEMA");
    public static final FeatureHolder EMPTY_FEATURE_HOLDER = new EmptyFeatureHolder();

    public int countFeatures();

    public Iterator<Feature> features();

    public FeatureHolder filter(FeatureFilter var1, boolean var2);

    public FeatureHolder filter(FeatureFilter var1);

    public Feature createFeature(Feature.Template var1) throws BioException, ChangeVetoException;

    public void removeFeature(Feature var1) throws ChangeVetoException, BioException;

    public boolean containsFeature(Feature var1);

    public FeatureFilter getSchema();

    public static final class EmptyFeatureHolder
    extends Unchangeable
    implements FeatureHolder {
        @Override
        public int countFeatures() {
            return 0;
        }

        @Override
        public Iterator<Feature> features() {
            return Collections.EMPTY_SET.iterator();
        }

        @Override
        public FeatureHolder filter(FeatureFilter fc, boolean recurse) {
            return this;
        }

        @Override
        public FeatureHolder filter(FeatureFilter fc) {
            return this;
        }

        @Override
        public Feature createFeature(Feature.Template f) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeFeature(Feature f) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsFeature(Feature f) {
            return false;
        }

        @Override
        public FeatureFilter getSchema() {
            return FeatureFilter.none;
        }
    }
}

