/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.tagvalue;

import java.util.Map;
import java.util.Set;
import org.biojava.bio.program.tagvalue.SimpleTagValueWrapper;
import org.biojava.bio.program.tagvalue.TagValueContext;
import org.biojava.bio.program.tagvalue.TagValueListener;
import org.biojava.bio.program.tagvalue.TagValueParser;
import org.biojava.utils.ParserException;
import org.biojava.utils.SmallMap;

public class TagDelegator
extends SimpleTagValueWrapper {
    private Map parsers = new SmallMap();
    private Map listeners = new SmallMap();
    private TagValueParser delegateParser;
    private TagValueParser parser;
    private TagValueListener listener;

    public TagDelegator() {
    }

    public TagDelegator(TagValueListener delegate) {
        super(delegate);
        this.parsers = new SmallMap();
        this.listeners = new SmallMap();
    }

    public void setDelegateParser(TagValueParser delegateParser) {
        this.delegateParser = delegateParser;
    }

    public TagValueParser getDelegateParser() {
        return this.delegateParser;
    }

    @Override
    public void startTag(Object tag) throws ParserException {
        this.parser = (TagValueParser)this.parsers.get(tag);
        this.listener = (TagValueListener)this.listeners.get(tag);
        if (this.parser == null && this.listener != null) {
            this.listener.startTag(tag);
        } else {
            super.startTag(tag);
        }
    }

    @Override
    public void endTag() throws ParserException {
        if (this.parser == null && this.listener != null) {
            this.listener.endTag();
        } else {
            super.endTag();
        }
    }

    @Override
    public void value(TagValueContext tvc, Object value) throws ParserException {
        if (this.parser != null) {
            tvc.pushParser(this.parser, this.listener);
        } else if (this.listener != null) {
            this.listener.value(tvc, value);
        } else if (this.delegateParser != null) {
            tvc.pushParser(this.delegateParser, this.getDelegate());
        } else {
            super.value(tvc, value);
        }
    }

    public void setParserListener(Object tag, TagValueParser parser, TagValueListener listener) {
        this.parsers.put(tag, parser);
        this.listeners.put(tag, listener);
    }

    public void setListener(Object tag, TagValueListener listener) {
        this.listeners.put(tag, listener);
    }

    public TagValueParser getParser(Object tag) {
        return (TagValueParser)this.parsers.get(tag);
    }

    public TagValueListener getListener(Object tag) {
        return (TagValueListener)this.listeners.get(tag);
    }

    public Set getTags() {
        return this.listeners.keySet();
    }
}

