/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.tagvalue;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.bio.program.tagvalue.TagValue;
import org.biojava.bio.program.tagvalue.TagValueParser;
import org.biojava.utils.ParserException;

public class RegexParser
implements TagValueParser {
    private Pattern pattern = null;
    private int tagGroup = -1;
    private int valueGroup = -1;
    private String endOfRecord = null;
    private boolean trimTag = false;
    private boolean trimValue = false;
    private boolean continueOnEmptyTag = false;
    private boolean mergeSameTag = false;
    private String tag;

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setTagGroup(int group) {
        this.tagGroup = group;
    }

    public int getTagGroup() {
        return this.tagGroup;
    }

    public void setValueGroup(int group) {
        this.valueGroup = group;
    }

    public int getValueGroup() {
        return this.valueGroup;
    }

    public void setEndOfRecord(String endOfRecord) {
        this.endOfRecord = endOfRecord;
    }

    public String getEndOfRecord() {
        return this.endOfRecord;
    }

    public void setTrimTag(boolean trimTag) {
        this.trimTag = trimTag;
    }

    public boolean getTrimTag() {
        return this.trimTag;
    }

    public void setTrimValue(boolean trimValue) {
        this.trimValue = trimValue;
    }

    public boolean getTrimValue() {
        return this.trimValue;
    }

    public void setContinueOnEmptyTag(boolean continueOnEmptyTag) {
        this.continueOnEmptyTag = continueOnEmptyTag;
    }

    public boolean getContinueOnEmptyTag() {
        return this.continueOnEmptyTag;
    }

    public void setMergeSameTag(boolean mergeSameTag) {
        this.mergeSameTag = mergeSameTag;
    }

    public boolean getMergeSameTag() {
        return this.mergeSameTag;
    }

    @Override
    public TagValue parse(Object o) throws ParserException {
        String line = o.toString();
        if (this.endOfRecord != null && (this.endOfRecord == "" ? line.equals("") : line.startsWith(this.endOfRecord))) {
            return null;
        }
        Matcher matcher = this.pattern.matcher(line);
        if (!matcher.find()) {
            throw new ParserException("Could not match " + this.pattern.pattern() + " to " + line);
        }
        String tag = matcher.group(this.tagGroup);
        if (this.trimTag) {
            tag = tag.trim();
        }
        String value = matcher.group(this.valueGroup);
        if (this.trimValue) {
            value = value.trim();
        }
        if (this.continueOnEmptyTag && tag.length() == 0) {
            return new TagValue(this.tag, value, false);
        }
        if (this.mergeSameTag && tag.equals(this.tag)) {
            return new TagValue(tag, value, false);
        }
        this.tag = tag;
        return new TagValue(this.tag, value, true);
    }
}

