/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssaha;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.biojava.bio.BioException;
import org.biojava.bio.program.ssaha.DataStore;
import org.biojava.bio.program.ssaha.DataStoreFactory;
import org.biojava.bio.program.ssaha.MappedDataStore;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Packing;
import org.biojava.bio.symbol.PackingFactory;
import org.biojava.utils.Constants;

public class MappedDataStoreFactory
implements DataStoreFactory {
    @Override
    public DataStore getDataStore(File storeFile) throws IOException {
        return new MappedDataStore(storeFile);
    }

    @Override
    public DataStore buildDataStore(File storeFile, SequenceDB seqDB, Packing packing, int wordLength, int threshold) throws IllegalAlphabetException, IOException, BioException {
        ByteArrayOutputStream packingStream = new ByteArrayOutputStream();
        ObjectOutputStream packingSerializer = new ObjectOutputStream(packingStream);
        packingSerializer.writeObject(packing);
        packingSerializer.flush();
        int structDataSize = 6 * Constants.BYTES_IN_INT + packingStream.toByteArray().length;
        storeFile.createNewFile();
        RandomAccessFile store = new RandomAccessFile(storeFile, "rw");
        FileChannel channel = store.getChannel();
        int words = 1 << packing.wordSize() * wordLength;
        int hashTablePos = structDataSize;
        int hashTableSize = Constants.BYTES_IN_INT + words * Constants.BYTES_IN_INT;
        MappedByteBuffer hashTable_MB = channel.map(FileChannel.MapMode.READ_WRITE, hashTablePos, hashTableSize);
        IntBuffer hashTable = hashTable_MB.asIntBuffer();
        hashTable.put(0, hashTableSize);
        for (int i = 0; i < words; ++i) {
            hashTable.put(i + 1, 0);
        }
        hashTable.position(0);
        int seqCount = 0;
        int nameChars = 0;
        SequenceIterator i = seqDB.sequenceIterator();
        while (i.hasNext()) {
            Sequence seq = i.nextSequence();
            if (seq.length() <= wordLength) continue;
            ++seqCount;
            nameChars += seq.getName().length();
            int word = PackingFactory.primeWord(seq, wordLength, packing);
            this.addCount(hashTable, word);
            for (int j = wordLength + 1; j <= seq.length(); ++j) {
                word = PackingFactory.nextWord(seq, word, j, wordLength, packing);
                this.addCount(hashTable, word);
            }
        }
        int nameArrayPos = hashTablePos + hashTableSize;
        int nameArraySize = (seqCount + 1) * Constants.BYTES_IN_INT;
        MappedByteBuffer nameArray_MB = channel.map(FileChannel.MapMode.READ_WRITE, nameArrayPos, nameArraySize);
        IntBuffer nameArray = nameArray_MB.asIntBuffer();
        nameArray.put(0, nameArraySize);
        int nameTablePos = nameArrayPos + nameArraySize;
        int nameTableSize = Constants.BYTES_IN_INT + seqCount * Constants.BYTES_IN_INT + nameChars * Constants.BYTES_IN_CHAR;
        MappedByteBuffer nameTable = channel.map(FileChannel.MapMode.READ_WRITE, nameTablePos, nameTableSize);
        nameTable.putInt(0, nameTableSize);
        nameTable.position(Constants.BYTES_IN_INT);
        int kmersUsed = 0;
        int hitCount = 0;
        for (int i2 = 0; i2 < words; ++i2) {
            int counts = hashTable.get(i2 + 1);
            if (counts <= 0 || counts >= threshold) continue;
            ++hitCount;
            kmersUsed += counts;
        }
        int hitTablePos = nameTablePos + nameTableSize;
        long hitTableSize = (long)Constants.BYTES_IN_INT + (long)kmersUsed * (long)(Constants.BYTES_IN_INT + Constants.BYTES_IN_INT) + (long)hitCount * (long)Constants.BYTES_IN_INT;
        MappedByteBuffer hitTable = channel.map(FileChannel.MapMode.READ_WRITE, hitTablePos, (int)hitTableSize);
        hitTable.putInt(0, (int)hitTableSize);
        hitTable.position(Constants.BYTES_IN_INT);
        int hitOffset = 0;
        for (int i3 = 0; i3 < words; ++i3) {
            int counts = hashTable.get(i3 + 1);
            if (counts > 0 && counts < threshold) {
                try {
                    if (hitOffset < 0) {
                        throw new IndexOutOfBoundsException("Hit offset negative");
                    }
                    hashTable.put(i3 + 1, hitOffset);
                    hitTable.putInt(hitOffset + Constants.BYTES_IN_INT, 0);
                    hitOffset += Constants.BYTES_IN_INT + counts * (Constants.BYTES_IN_INT + Constants.BYTES_IN_INT);
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    System.out.println("counts:\t" + counts);
                    System.out.println("word:\t" + i3);
                    System.out.println("hitOffset:\t" + hitOffset);
                    throw e;
                }
            }
            hashTable.put(i3 + 1, -1);
        }
        int seqNumber = 0;
        nameTable.position(Constants.BYTES_IN_INT);
        SequenceIterator i4 = seqDB.sequenceIterator();
        while (i4.hasNext()) {
            Sequence seq = i4.nextSequence();
            if (seq.length() <= wordLength) continue;
            try {
                nameArray.put(seqNumber + 1, nameTable.position() - Constants.BYTES_IN_INT);
                String name = seq.getName();
                nameTable.putInt(name.length());
                for (int j = 0; j < name.length(); ++j) {
                    nameTable.putChar(name.charAt(j));
                }
                int word = PackingFactory.primeWord(seq, wordLength, packing);
                this.writeRecord(hashTable, hitTable, 1, seqNumber, word);
                for (int j = wordLength + 1; j <= seq.length(); ++j) {
                    word = PackingFactory.nextWord(seq, word, j, wordLength, packing);
                    this.writeRecord(hashTable, hitTable, j - wordLength + 1, seqNumber, word);
                }
            }
            catch (BufferOverflowException e) {
                System.out.println("name:\t" + seq.getName());
                System.out.println("seqNumber:\t" + seqNumber);
                System.out.println("na pos:\t" + nameArray.position());
                System.out.println("nt pos:\t" + nameTable.position());
                throw e;
            }
            ++seqNumber;
        }
        MappedByteBuffer rootBuffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, structDataSize);
        rootBuffer.position(0);
        rootBuffer.putInt(hashTablePos);
        rootBuffer.putInt(hitTablePos);
        rootBuffer.putInt(nameArrayPos);
        rootBuffer.putInt(nameTablePos);
        rootBuffer.putInt(wordLength);
        rootBuffer.putInt(packingStream.toByteArray().length);
        rootBuffer.put(packingStream.toByteArray());
        rootBuffer.force();
        hashTable_MB.force();
        hitTable.force();
        nameArray_MB.force();
        nameTable.force();
        return this.getDataStore(storeFile);
    }

    private void addCount(IntBuffer buffer, int word) {
        int count = buffer.get(word + 1);
        buffer.put(word + 1, ++count);
    }

    private void writeRecord(IntBuffer hashTable, MappedByteBuffer hitTable, int offset, int seqNumber, int word) {
        int kmerPointer = hashTable.get(word + 1);
        if (kmerPointer != -1) {
            int hitCount = hitTable.getInt(kmerPointer += Constants.BYTES_IN_INT);
            int pos = kmerPointer + hitCount * (Constants.BYTES_IN_INT + Constants.BYTES_IN_INT) + Constants.BYTES_IN_INT;
            hitTable.position(pos);
            hitTable.putInt(seqNumber);
            hitTable.putInt(offset);
            hitTable.putInt(kmerPointer, hitCount + 1);
        }
    }
}

