/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.homologene;

import java.util.HashSet;
import java.util.Set;
import org.biojava.bio.program.homologene.AbstractOrthoPairSet;
import org.biojava.bio.program.homologene.OrthoPair;
import org.biojava.bio.program.homologene.OrthoPairSet;
import org.biojava.bio.program.homologene.Taxon;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;

public class SimpleOrthoPairSet
extends AbstractOrthoPairSet {
    String name;
    Set orthologies = new HashSet();

    public SimpleOrthoPairSet() {
        this.generateChangeSupport();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOrthoPair(OrthoPair orthology) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.orthologies.add(orthology);
        } else {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(OrthoPairSet.MODIFY);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, OrthoPairSet.MODIFY);
                cs.firePreChangeEvent(ce);
                this.orthologies.add(orthology);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOrthoPair(OrthoPair orthology) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.orthologies.remove(orthology);
        } else {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(OrthoPairSet.MODIFY);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, OrthoPairSet.MODIFY);
                cs.firePreChangeEvent(ce);
                this.orthologies.remove(orthology);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    @Override
    public OrthoPairSet.Iterator iterator() {
        return new Iterator(this.orthologies.iterator());
    }

    @Override
    public double getMinIdentity() {
        double min = 100.0;
        for (OrthoPair currOrthoPair : this.orthologies) {
            min = Math.min(min, currOrthoPair.getPercentIdentity());
        }
        return min;
    }

    @Override
    public int size() {
        return this.orthologies.size();
    }

    @Override
    public Set getTaxa() {
        HashSet<Taxon> taxa = new HashSet<Taxon>();
        for (OrthoPair currOrtho : this.orthologies) {
            taxa.add(currOrtho.getFirstOrthologue().getTaxon());
            taxa.add(currOrtho.getSecondOrthologue().getTaxon());
        }
        return taxa;
    }

    public class Iterator
    implements OrthoPairSet.Iterator {
        private java.util.Iterator setIterator;

        private Iterator(java.util.Iterator setIterator) {
            this.setIterator = setIterator;
        }

        @Override
        public boolean hasNext() {
            return this.setIterator.hasNext();
        }

        @Override
        public OrthoPair nextOrthoPair() {
            return (OrthoPair)this.setIterator.next();
        }
    }
}

