/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.molbio;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.molbio.RestrictionEnzyme;
import org.biojava.bio.program.tagvalue.ChangeTable;
import org.biojava.bio.program.tagvalue.LineSplitParser;
import org.biojava.bio.program.tagvalue.Parser;
import org.biojava.bio.program.tagvalue.RegexSplitter;
import org.biojava.bio.program.tagvalue.TagDropper;
import org.biojava.bio.program.tagvalue.TagValueContext;
import org.biojava.bio.program.tagvalue.TagValueListener;
import org.biojava.bio.program.tagvalue.ValueChanger;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.ParserException;
import org.biojava.utils.SmallSet;

public final class RestrictionEnzymeManager {
    public static final String REBASE_DATA_KEY = "rebase.data.file";
    public static final String REBASE_TAG_NAME = "<1>";
    public static final String REBASE_TAG_ISZR = "<2>";
    public static final String REBASE_TAG_SITE = "<3>";
    public static final String REBASE_TAG_METH = "<4>";
    public static final String REBASE_TAG_ORGN = "<5>";
    public static final String REBASE_TAG_SRCE = "<6>";
    public static final String REBASE_TAG_COMM = "<7>";
    public static final String REBASE_TAG_REFS = "<8>";
    private static boolean loadCommercialOnly = false;
    private static ResourceBundle bundle = ResourceBundle.getBundle(RestrictionEnzymeManager.class.getName());
    private static Map nameToSite;
    private static Map nameToEnzyme;
    private static Map nameToIsoschizomers;
    private static Map sizeToCutters;
    private static Map enzymeToPattern;
    private static Map enzymeToAnnotation;
    private static Map enzymeToSuppliers;

    private RestrictionEnzymeManager() {
    }

    public static synchronized void loadEnzymeFile(InputStream is, boolean commercialOnly) {
        loadCommercialOnly = commercialOnly;
        RestrictionEnzymeManager.loadData(is);
    }

    public static Set getAllEnzymes() {
        return Collections.unmodifiableSet(enzymeToPattern.keySet());
    }

    public static RestrictionEnzyme getEnzyme(String name) {
        if (!nameToEnzyme.containsKey(name)) {
            throw new IllegalArgumentException("Unknown RestrictionEnzyme name '" + name + "'");
        }
        return (RestrictionEnzyme)nameToEnzyme.get(name);
    }

    public static Set getIsoschizomers(String name) {
        if (!nameToIsoschizomers.containsKey(name)) {
            throw new IllegalArgumentException("Unknown RestrictionEnzyme name '" + name + "'");
        }
        Set result = (Set)nameToIsoschizomers.get(name);
        if (result.contains(null)) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(result);
    }

    public static String getRecognitionSequence(String name) {
        if (!nameToSite.containsKey(name)) {
            throw new IllegalArgumentException("Unknown RestrictionEnzyme name '" + name + "'");
        }
        return (String)nameToSite.get(name);
    }

    public static Set getNCutters(int n) {
        Integer size = new Integer(n);
        if (!sizeToCutters.containsKey(size)) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet((Set)sizeToCutters.get(size));
    }

    public static Pattern[] getPatterns(RestrictionEnzyme enzyme) {
        if (!enzymeToPattern.containsKey(enzyme)) {
            throw new IllegalArgumentException("RestrictionEnzyme '" + enzyme.getName() + "' is not registered. No precompiled Pattern is available");
        }
        return (Pattern[])enzymeToPattern.get(enzyme);
    }

    public static Annotation getAnnotation(RestrictionEnzyme enzyme) {
        if (!enzymeToAnnotation.containsKey(enzyme)) {
            throw new IllegalArgumentException("RestrictionEnzyme '" + enzyme.getName() + "' is not registered. No Annotation is available");
        }
        return (Annotation)enzymeToAnnotation.get(enzyme);
    }

    public static String getSuppliers(RestrictionEnzyme enzyme) {
        if (!enzymeToSuppliers.containsKey(enzyme)) {
            return "";
        }
        return (String)enzymeToSuppliers.get(enzyme);
    }

    public static synchronized void register(RestrictionEnzyme enzyme, Set isoschizomers) {
        for (Object o : isoschizomers) {
            if (o instanceof RestrictionEnzyme) continue;
            throw new IllegalArgumentException("Isoschizomers set may contain only RestrictionEnzymes. Found '" + o + "'");
        }
        RestrictionEnzymeManager.registerEnzyme(enzyme);
        String name = enzyme.getName();
        nameToIsoschizomers.put(name, isoschizomers);
    }

    private static void registerEnzyme(RestrictionEnzyme enzyme) {
        Set<RestrictionEnzyme> s;
        String name = enzyme.getName();
        nameToEnzyme.put(name, enzyme);
        Integer sizeKey = new Integer(enzyme.getRecognitionSite().length());
        if (sizeToCutters.containsKey(sizeKey)) {
            s = (Set)sizeToCutters.get(sizeKey);
            s.add(enzyme);
        } else {
            s = new HashSet();
            s.add(enzyme);
            sizeToCutters.put(sizeKey, s);
        }
        Pattern forward = Pattern.compile(enzyme.getForwardRegex());
        Pattern reverse = Pattern.compile(enzyme.getReverseRegex());
        enzymeToPattern.put(enzyme, new Pattern[]{forward, reverse});
        SmallAnnotation annotation = new SmallAnnotation();
        try {
            annotation.setProperty("dbxref", "REBASE:" + name);
        }
        catch (ChangeVetoException cve) {
            throw new BioError("Assertion Failure: failed to modify Annotation", cve);
        }
        annotation.addChangeListener(ChangeListener.ALWAYS_VETO, ChangeType.UNKNOWN);
        enzymeToAnnotation.put(enzyme, annotation);
    }

    private static void loadData(InputStream is) {
        nameToSite = new HashMap();
        nameToEnzyme = new HashMap();
        nameToIsoschizomers = new HashMap();
        sizeToCutters = new HashMap();
        enzymeToPattern = new HashMap();
        enzymeToAnnotation = new HashMap();
        enzymeToSuppliers = new HashMap();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            LineSplitParser lsParser = new LineSplitParser();
            lsParser.setEndOfRecord("");
            lsParser.setSplitOffset(3);
            lsParser.setContinueOnEmptyTag(true);
            lsParser.setMergeSameTag(true);
            RebaseEnzymeBuilder builder = new RebaseEnzymeBuilder();
            RegexSplitter iso = new RegexSplitter(Pattern.compile("([^,]+)"), 1);
            RegexSplitter site = new RegexSplitter(Pattern.compile("(\\(-?\\d+/-?\\d+\\)|[A-Za-z^]+)"), 1);
            ChangeTable table = new ChangeTable();
            table.setSplitter(REBASE_TAG_ISZR, iso);
            table.setSplitter(REBASE_TAG_SITE, site);
            ValueChanger changer = new ValueChanger(builder, table);
            TagDropper rebaseTags = new TagDropper(changer);
            rebaseTags.addTag(REBASE_TAG_NAME);
            rebaseTags.addTag(REBASE_TAG_ISZR);
            rebaseTags.addTag(REBASE_TAG_SITE);
            rebaseTags.addTag(REBASE_TAG_COMM);
            Parser parser = new Parser();
            while (parser.read(br, lsParser, rebaseTags)) {
            }
            HashMap tempMap = new HashMap();
            Set tempSet = null;
            for (Object name : nameToIsoschizomers.keySet()) {
                Set isoschizomers = (Set)nameToIsoschizomers.get(name);
                tempSet = isoschizomers.size() == 0 ? Collections.EMPTY_SET : (Set)isoschizomers.getClass().newInstance();
                tempMap.put(name, tempSet);
                for (String isoName : isoschizomers) {
                    Object re = nameToEnzyme.get(isoName);
                    if (re == null) continue;
                    tempSet.add(re);
                }
            }
            nameToIsoschizomers = tempMap;
        }
        catch (Exception e) {
            throw new BioError("Failed to read REBASE data file", e);
        }
    }

    static {
        String rebaseDataFileName = bundle.getString(REBASE_DATA_KEY);
        InputStream is = RestrictionEnzymeManager.class.getResourceAsStream(rebaseDataFileName);
        RestrictionEnzymeManager.loadData(is);
    }

    private static class RebaseEnzymeBuilder
    implements TagValueListener {
        private String recseq;
        private String name;
        private Set isoschizomers;
        private List isoBuffer;
        private SymbolList site;
        private int[] usCutPositions;
        private int[] dsCutPositions;
        private boolean isCommerciallyAvailable;
        private String tagState;
        private String suppliers;
        private boolean unknownSite;

        RebaseEnzymeBuilder() {
        }

        @Override
        public void startRecord() throws ParserException {
            this.isoBuffer = new ArrayList(30);
            this.recseq = "";
            this.site = null;
            this.dsCutPositions = null;
            this.usCutPositions = null;
            this.unknownSite = false;
            this.isCommerciallyAvailable = false;
        }

        @Override
        public void endRecord() throws ParserException {
            if (!this.getRecordState()) {
                return;
            }
            if (this.unknownSite || this.site == null) {
                return;
            }
            int isoCount = this.isoBuffer.size();
            if (isoCount < 30) {
                this.isoschizomers = new SmallSet(isoCount);
                for (int i = 0; i < isoCount; ++i) {
                    this.isoschizomers.add(this.isoBuffer.get(i));
                }
            } else {
                this.isoschizomers = new HashSet(this.isoBuffer);
            }
            if (!loadCommercialOnly || this.isCommerciallyAvailable) {
                RestrictionEnzyme re = this.createEnzyme();
                RestrictionEnzymeManager.registerEnzyme(re);
                nameToIsoschizomers.put(this.name, this.isoschizomers);
                enzymeToSuppliers.put(re, this.suppliers);
                nameToSite.put(this.name, this.recseq);
            }
        }

        @Override
        public void startTag(Object tag) throws ParserException {
            this.tagState = (String)tag;
        }

        @Override
        public void endTag() throws ParserException {
        }

        @Override
        public void value(TagValueContext context, Object value) throws ParserException {
            if (this.tagState.equals(RestrictionEnzymeManager.REBASE_TAG_NAME)) {
                this.name = (String)value;
            } else if (this.tagState.equals(RestrictionEnzymeManager.REBASE_TAG_ISZR)) {
                this.isoBuffer.add(value);
            } else if (this.tagState.equals(RestrictionEnzymeManager.REBASE_TAG_SITE)) {
                this.recseq = this.recseq + (String)value;
                this.processSite(value);
            } else if (this.tagState.equals(RestrictionEnzymeManager.REBASE_TAG_COMM)) {
                this.processSuppliers(value);
            } else {
                throw new ParserException("Unable to handle value for tag '" + this.tagState + "'");
            }
        }

        boolean getRecordState() {
            return this.tagState != null;
        }

        RestrictionEnzyme createEnzyme() {
            RestrictionEnzyme enzyme = null;
            try {
                enzyme = this.usCutPositions != null ? new RestrictionEnzyme(this.name, this.site, this.usCutPositions[0], this.usCutPositions[1], this.dsCutPositions[0], this.dsCutPositions[1]) : new RestrictionEnzyme(this.name, this.site, this.dsCutPositions[0], this.dsCutPositions[1]);
            }
            catch (IllegalAlphabetException iae) {
                throw new BioError("New DNA SymbolList no longer consists on DNA Alphabet", iae);
            }
            return enzyme;
        }

        private void processSuppliers(Object value) throws ParserException {
            this.suppliers = (String)value;
            if (this.suppliers.length() != 0) {
                this.isCommerciallyAvailable = true;
            }
        }

        private void processSite(Object value) throws ParserException {
            StringBuffer sb = new StringBuffer((String)value);
            if (sb.charAt(0) == '?') {
                this.unknownSite = true;
                return;
            }
            if (sb.charAt(0) == '(') {
                int revIdx;
                int forIdx;
                int div = sb.indexOf("/");
                try {
                    forIdx = Integer.parseInt(sb.substring(1, div));
                    revIdx = Integer.parseInt(sb.substring(div + 1, sb.length() - 1));
                }
                catch (NumberFormatException nfe) {
                    throw new ParserException("Failed to parse cut site index", nfe);
                }
                if (this.site == null) {
                    this.usCutPositions = new int[2];
                    this.usCutPositions[0] = -forIdx;
                    this.usCutPositions[1] = -revIdx;
                } else {
                    this.dsCutPositions = new int[2];
                    this.dsCutPositions[0] = forIdx + this.site.length();
                    this.dsCutPositions[1] = revIdx + this.site.length();
                }
            } else {
                int cut = sb.indexOf("^");
                this.dsCutPositions = new int[2];
                try {
                    if (cut == -1) {
                        this.site = DNATools.createDNA(sb.substring(0));
                        this.dsCutPositions[0] = 1;
                        this.dsCutPositions[1] = 1;
                    } else {
                        sb.deleteCharAt(cut);
                        this.site = DNATools.createDNA(sb.substring(0));
                        this.dsCutPositions[0] = cut;
                        this.dsCutPositions[1] = this.site.length() - cut;
                    }
                }
                catch (IllegalSymbolException iae) {
                    throw new ParserException("Illegal DNA symbol in recognition site", iae);
                }
            }
        }
    }
}

