/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp.twohead;

import org.biojava.bio.dp.BackPointer;
import org.biojava.bio.dp.twohead.AbstractMatrixPairDPCursor;
import org.biojava.bio.dp.twohead.Cell;
import org.biojava.bio.dp.twohead.EmissionCache;
import org.biojava.bio.dp.twohead.PairDPMatrix;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SymbolList;

public class BackMatrixPairDPCursor
extends AbstractMatrixPairDPCursor {
    public BackMatrixPairDPCursor(SymbolList seq1, SymbolList seq2, int depth1, int depth2, PairDPMatrix matrix, EmissionCache eCache) throws IllegalSymbolException {
        super(seq1, seq2, seq1.length() + 1, seq2.length() + 1, depth1, depth2, matrix, eCache);
    }

    @Override
    public boolean hasNext() {
        return this.pos[1] >= 0;
    }

    @Override
    public void next(Cell[][] cells) {
        for (int i = 0; i < this.depth[0]; ++i) {
            boolean outI;
            Cell[] cellI = cells[i];
            int ii = this.pos[0] + i;
            boolean bl = outI = ii < 0 || ii > this.seqs[0].length() + 1;
            if (outI) {
                for (int j = 0; j < this.depth[1]; ++j) {
                    Cell c = cellI[j];
                    c.scores = this.zeroCol;
                    c.emissions = this.zeroCol;
                    c.backPointers = this.emptyBP;
                }
                continue;
            }
            double[][] sMatI = this.sMatrix[ii];
            double[][] emisI = this.emissions[ii];
            BackPointer[][] bPI = this.bPointers[ii];
            for (int j = 0; j < this.depth[1]; ++j) {
                int jj = this.pos[1] + j;
                boolean outJ = jj < 0 || jj > this.seqs[1].length() + 1;
                Cell c = cellI[j];
                if (outJ) {
                    c.scores = this.zeroCol;
                    c.emissions = this.zeroCol;
                    c.backPointers = this.emptyBP;
                    continue;
                }
                c.scores = sMatI[jj];
                c.emissions = emisI[jj];
                c.backPointers = bPI[jj];
            }
        }
        if (this.pos[0] > 0) {
            this.pos[0] = this.pos[0] - 1;
        } else {
            this.pos[0] = this.seqs[0].length() + 1;
            this.pos[1] = this.pos[1] - 1;
        }
    }
}

