/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.util.Iterator;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTrainerContext;
import org.biojava.bio.dist.SimpleDistributionTrainerContext;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.HMMTrainer;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.State;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;

public class SimpleHMMTrainer
implements HMMTrainer {
    DistributionTrainerContext dtc = new SimpleDistributionTrainerContext();
    FiniteAlphabet states;
    MarkovModel model;

    public SimpleHMMTrainer(MarkovModel model) throws IllegalSymbolException {
        this.model = model;
        this.states = model.stateAlphabet();
        Iterator<Symbol> stateI = this.states.iterator();
        while (stateI.hasNext()) {
            State thisState = (State)stateI.next();
            if (thisState instanceof EmissionState) {
                EmissionState thisEmitter = (EmissionState)thisState;
                Distribution emissionDist = thisEmitter.getDistribution();
                this.dtc.registerDistribution(emissionDist);
                emissionDist.registerWithTrainer(this.dtc);
            }
            Distribution transDist = model.getWeights(thisState);
            this.dtc.registerDistribution(transDist);
            transDist.registerWithTrainer(this.dtc);
        }
    }

    @Override
    public void startCycle() {
        this.dtc.clearCounts();
    }

    @Override
    public void recordEmittedSymbol(State state, Symbol symbol, double weight) throws IllegalSymbolException {
        if (!(state instanceof EmissionState)) {
            throw new IllegalSymbolException("specified State is not an EmissionState.");
        }
        Distribution emissionDist = ((EmissionState)state).getDistribution();
        this.dtc.addCount(emissionDist, symbol, weight);
    }

    @Override
    public void recordTransition(State source, State dest, double weight) throws IllegalArgumentException {
        try {
            if (!this.model.containsTransition(source, dest)) {
                throw new IllegalArgumentException("the specified transition is illegal for this model.");
            }
            Distribution transDist = this.model.getWeights(source);
            this.dtc.addCount(transDist, dest, weight);
        }
        catch (IllegalSymbolException ise) {
            throw new IllegalArgumentException("either source or destination are not valid");
        }
    }

    @Override
    public void completeCycle() throws BioException {
        try {
            this.dtc.train();
        }
        catch (ChangeVetoException cve) {
            throw new BioException(cve);
        }
    }
}

