/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import org.biojava.bio.BioException;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.onehead.SingleDP;
import org.biojava.bio.dp.twohead.CellCalculatorFactoryMaker;
import org.biojava.bio.dp.twohead.DPInterpreter;
import org.biojava.bio.dp.twohead.PairwiseDP;

public interface DPFactory {
    public static final DPFactory DEFAULT = new DefaultFactory(new DPInterpreter.Maker());

    public DP createDP(MarkovModel var1) throws IllegalArgumentException, BioException;

    public static class DefaultFactory
    implements DPFactory {
        private final CellCalculatorFactoryMaker cfFacM;

        public DefaultFactory(CellCalculatorFactoryMaker cfFacM) {
            this.cfFacM = cfFacM;
        }

        @Override
        public DP createDP(MarkovModel model) throws IllegalArgumentException, BioException {
            int heads = model.advance().length;
            MarkovModel flat = DP.flatView(model);
            if (heads == 1) {
                return new SingleDP(flat);
            }
            if (heads == 2) {
                return new PairwiseDP(flat, this.cfFacM);
            }
            throw new IllegalArgumentException("Can't create DPFactory for models with " + heads + " heads");
        }
    }
}

