/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.AbstractDistribution;
import org.biojava.bio.dist.Count;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTrainer;
import org.biojava.bio.dist.DistributionTrainerContext;
import org.biojava.bio.dist.IndexedCount;
import org.biojava.bio.dist.UniformDistribution;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeAdapter;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;

public class SimpleDistribution
extends AbstractDistribution
implements Serializable {
    static final long serialVersionUID = 7252850540926095728L;
    private transient AlphabetIndex indexer;
    private transient double[] weights = null;
    private Distribution nullModel;
    private FiniteAlphabet alpha;

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        if (this.weights != null) {
            SymbolWeightMemento[] swm = new SymbolWeightMemento[this.weights.length];
            for (int w = 0; w < swm.length; ++w) {
                swm[w] = new SymbolWeightMemento(this.indexer.symbolForIndex(w), this.weights[w]);
            }
            oos.writeObject(swm);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.indexer = AlphabetManager.getAlphabetIndex(this.alpha);
        this.indexer.addChangeListener(new ChangeAdapter(){

            @Override
            public void preChange(ChangeEvent ce) throws ChangeVetoException {
                if (SimpleDistribution.this.hasWeights()) {
                    throw new ChangeVetoException(ce, "Can't allow the index to change as we have probabilities.");
                }
            }
        }, AlphabetIndex.INDEX);
        this.weights = new double[this.alpha.size()];
        SymbolWeightMemento[] swm = (SymbolWeightMemento[])stream.readObject();
        for (int m = 0; m < swm.length; ++m) {
            try {
                this.weights[this.indexer.indexForSymbol((Symbol)swm[m].symbol)] = swm[m].weight;
                continue;
            }
            catch (IllegalSymbolException ex) {
                throw new IOException("Symbol in serialized stream: " + swm[m].symbol.getName() + " can't be found in the alphabet");
            }
        }
    }

    @Override
    public Alphabet getAlphabet() {
        return this.indexer.getAlphabet();
    }

    @Override
    public Distribution getNullModel() {
        return this.nullModel;
    }

    @Override
    protected void setNullModelImpl(Distribution nullModel) throws IllegalAlphabetException, ChangeVetoException {
        this.nullModel = nullModel;
    }

    protected boolean hasWeights() {
        return this.weights != null;
    }

    protected double[] getWeights() {
        if (this.weights == null) {
            this.weights = new double[((FiniteAlphabet)this.getAlphabet()).size()];
            for (int i = 0; i < this.weights.length; ++i) {
                this.weights[i] = Double.NaN;
            }
        }
        return this.weights;
    }

    @Override
    public double getWeightImpl(AtomicSymbol s) throws IllegalSymbolException {
        if (!this.hasWeights()) {
            return Double.NaN;
        }
        int index = this.indexer.indexForSymbol(s);
        return this.weights[index];
    }

    @Override
    protected void setWeightImpl(AtomicSymbol s, double w) throws IllegalSymbolException, ChangeVetoException {
        double[] weights = this.getWeights();
        if (w < 0.0) {
            throw new IllegalArgumentException("Can't set weight to negative score: " + s.getName() + " -> " + w);
        }
        weights[this.indexer.indexForSymbol((Symbol)s)] = w;
    }

    private void initialise(FiniteAlphabet alphabet) {
        this.alpha = alphabet;
        this.indexer = AlphabetManager.getAlphabetIndex(alphabet);
        this.indexer.addChangeListener(new ChangeAdapter(){

            @Override
            public void preChange(ChangeEvent ce) throws ChangeVetoException {
                if (SimpleDistribution.this.hasWeights()) {
                    throw new ChangeVetoException(ce, "Can't allow the index to change as we have probabilities.");
                }
            }
        }, AlphabetIndex.INDEX);
        try {
            this.setNullModel(new UniformDistribution(alphabet));
        }
        catch (Exception e) {
            throw new BioError("This should never fail. Something is screwed!", e);
        }
    }

    public SimpleDistribution(FiniteAlphabet alphabet) {
        this.initialise(alphabet);
    }

    public SimpleDistribution(Distribution dist) {
        try {
            this.initialise((FiniteAlphabet)dist.getAlphabet());
            int alfaSize = ((FiniteAlphabet)this.getAlphabet()).size();
            for (int i = 0; i < alfaSize; ++i) {
                this.weights = new double[alfaSize];
                this.weights[i] = dist.getWeight(this.indexer.symbolForIndex(i));
            }
        }
        catch (IllegalSymbolException ise) {
            System.err.println("an impossible error surely! ");
            ise.printStackTrace();
        }
    }

    @Override
    public void registerWithTrainer(DistributionTrainerContext dtc) {
        dtc.registerTrainer(this, new Trainer());
    }

    protected class Trainer
    implements DistributionTrainer {
        private final Count counts;

        public Trainer() {
            this.counts = new IndexedCount(SimpleDistribution.this.indexer);
        }

        @Override
        public void addCount(DistributionTrainerContext dtc, AtomicSymbol sym, double times) throws IllegalSymbolException {
            try {
                this.counts.increaseCount(sym, times);
            }
            catch (ChangeVetoException cve) {
                throw new BioError("Assertion Failure: Change to Count object vetoed", cve);
            }
        }

        @Override
        public double getCount(DistributionTrainerContext dtc, AtomicSymbol sym) throws IllegalSymbolException {
            return this.counts.getCount(sym);
        }

        @Override
        public void clearCounts(DistributionTrainerContext dtc) {
            try {
                int size = ((FiniteAlphabet)this.counts.getAlphabet()).size();
                for (int i = 0; i < size; ++i) {
                    this.counts.zeroCounts();
                }
            }
            catch (ChangeVetoException cve) {
                throw new BioError("Assertion Failure: Change to Count object vetoed", cve);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void train(DistributionTrainerContext dtc, double weight) throws ChangeVetoException {
            if (!SimpleDistribution.this.hasListeners()) {
                this.trainImpl(dtc, weight);
            } else {
                ChangeSupport changeSupport;
                ChangeSupport changeSupport2 = changeSupport = SimpleDistribution.this.getChangeSupport(Distribution.WEIGHTS);
                synchronized (changeSupport2) {
                    ChangeEvent ce = new ChangeEvent(SimpleDistribution.this, Distribution.WEIGHTS);
                    changeSupport.firePreChangeEvent(ce);
                    this.trainImpl(dtc, weight);
                    changeSupport.firePostChangeEvent(ce);
                }
            }
        }

        protected void trainImpl(DistributionTrainerContext dtc, double weight) {
            try {
                Distribution nullModel = SimpleDistribution.this.getNullModel();
                double[] weights = SimpleDistribution.this.getWeights();
                double[] total = new double[weights.length];
                double sum = 0.0;
                for (int i = 0; i < total.length; ++i) {
                    AtomicSymbol s = (AtomicSymbol)SimpleDistribution.this.indexer.symbolForIndex(i);
                    total[i] = this.getCount(dtc, s) + nullModel.getWeight(s) * weight;
                    sum += total[i];
                }
                double sum_inv = 1.0 / sum;
                for (int i = 0; i < total.length; ++i) {
                    weights[i] = total[i] * sum_inv;
                }
            }
            catch (IllegalSymbolException ise) {
                throw new BioError("Assertion Failure: Should be impossible to mess up the symbols.", ise);
            }
        }
    }

    private static class SymbolWeightMemento
    implements Serializable {
        static final long serialVersionUID = 5223128163879670657L;
        public final Symbol symbol;
        public final double weight;

        public SymbolWeightMemento(Symbol s, double weight) {
            this.symbol = s;
            this.weight = weight;
        }
    }
}

