/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface EcNumber {
    public static final Pattern EC_PATTERN = Pattern.compile("((\\d*)|(-))\\.((\\d*)|(-))\\.((\\d*)|(-))\\.((\\d*)|(-))");
    public static final int UNDEFINED = -1;
    public static final int UNCLASSIFIED = 99;

    public int getClassNumber(int var1);

    public static class Impl
    implements EcNumber {
        private int[] classes;

        public Impl(int mainClass, int subClass, int subSubClass, int group) {
            this.classes = new int[]{mainClass, subClass, subSubClass, group};
        }

        private Impl(String ecString) {
            Matcher matcher = EC_PATTERN.matcher(ecString);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Can't parse ec string: " + ecString);
            }
            this.classes = new int[]{this.process(matcher.group(1)), this.process(matcher.group(4)), this.process(matcher.group(7)), this.process(matcher.group(10))};
        }

        private int process(String s) {
            if (s.length() > 0) {
                if (s.equals("-")) {
                    return -1;
                }
                return Integer.parseInt(s);
            }
            return -1;
        }

        @Override
        public int getClassNumber(int level) {
            return this.classes[level];
        }

        public String toString() {
            StringBuffer sBuf = new StringBuffer();
            sBuf.append(this.process(this.getClassNumber(0)));
            for (int i = 1; i < 4; ++i) {
                sBuf.append(".");
                sBuf.append(this.process(this.getClassNumber(i)));
            }
            return sBuf.toString();
        }

        private String process(int val) {
            if (val == -1) {
                return "";
            }
            return Integer.toString(val);
        }

        public boolean equals(Object obj) {
            if (obj instanceof EcNumber) {
                EcNumber that = (EcNumber)obj;
                for (int i = 0; i < 4; ++i) {
                    if (this.getClassNumber(i) == that.getClassNumber(i)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.getClassNumber(0) * 1000000 + this.getClassNumber(1) * 10000 + this.getClassNumber(2) * 100 + this.getClassNumber(3);
        }

        public static Impl valueOf(String ecString) {
            return new Impl(ecString);
        }
    }
}

