/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.history;

import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.bioinformatics.vocab.Undefined;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.History;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class HistoryOutPipe
extends AbstractPipe<History, String> {
    private static final String FIELD_DELIMITER = "\t";
    private boolean mHasPrepended = false;
    private List<String> mQueue = new ArrayList<String>();

    protected String processNextStart() throws NoSuchElementException {
        History history;
        if (!this.mHasPrepended) {
            history = (History)this.starts.next();
            List<String> originalHeader = history.getMetaData().getOriginalHeader();
            int p = 1;
            if (originalHeader.size() > 0 && originalHeader.get(originalHeader.size() - 1).startsWith("##")) {
                p = 0;
            }
            int origHeaderSize = history.getMetaData().getOriginalHeader().size();
            for (int i = 0; i < origHeaderSize - p; ++i) {
                String headerLine = history.getMetaData().getOriginalHeader().get(i);
                this.mQueue.add(headerLine);
            }
            List<ColumnMetaData> headerCols = history.getMetaData().getColumns();
            while (history.size() > headerCols.size()) {
                ColumnMetaData cmd = new ColumnMetaData("#" + (Object)((Object)Undefined.UNKNOWN) + "_" + new Integer(headerCols.size() + 1).toString());
                headerCols.add(cmd);
            }
            this.mQueue.add(history.getMetaData().getColumnHeaderRow(history, FIELD_DELIMITER));
            String firstDataRow = history.getMergedData(FIELD_DELIMITER);
            this.mQueue.add(firstDataRow);
            this.mHasPrepended = true;
        }
        if (this.mQueue.size() > 0) {
            return this.mQueue.remove(0);
        }
        history = (History)this.starts.next();
        String dataRow = history.getMergedData(FIELD_DELIMITER);
        return dataRow;
    }

    public boolean hasNext() {
        if (this.mQueue.size() > 0) {
            return true;
        }
        return super.hasNext();
    }
}

