/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.bioinformatics;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import edu.mayo.Optimized;
import edu.mayo.mq.sender.Sender;
import edu.mayo.mq.sender.SystemOutSender;
import edu.mayo.pipes.bioinformatics.HeaderFieldDefinition;
import edu.mayo.pipes.bioinformatics.HeaderFieldDefinitionHelpers;
import edu.mayo.pipes.bioinformatics.InfoHeader;
import edu.mayo.pipes.bioinformatics.MetaHeader;
import edu.mayo.pipes.bioinformatics.SampleHeader;
import edu.mayo.pipes.bioinformatics.VCFHeaderParser;
import edu.mayo.pipes.bioinformatics.vocab.CoreAttributes;
import edu.mayo.pipes.bioinformatics.vocab.Type;
import edu.mayo.pipes.exceptions.InvalidPipeInputException;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.util.DoubleUtil;
import edu.mayo.pipes.util.GenomicObjectUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCF2VariantPipe
extends AbstractPipe<History, History> {
    private static final Logger sLogger = LoggerFactory.getLogger(VCF2VariantPipe.class);
    private Sender sender = new SystemOutSender("stderr");
    private String overrideInfoFieldsConfigPath = null;
    private static final int COL_CHROM = 0;
    private static final int COL_POS = 1;
    private static final int COL_ID = 2;
    private static final int COL_REF = 3;
    private static final int COL_ALT = 4;
    private static final int COL_QUAL = 5;
    private static final int COL_FILTER = 6;
    private static final int COL_INFO = 7;
    private static final int COL_FORMAT = 8;
    private static final String[] COL_HEADERS = new String[]{"CHROM", "POS", "ID", "REF", "ALT", "QUAL", "FILTER", "INFO"};
    private static final String NUMBER_SUPPORTING_SAMPLES = "NUMBER_SAMPLES";
    private boolean isHeaderProcessed = false;
    private boolean isAddFlagFalseValuesToJson = false;
    private int mHeaderLineCount = 0;
    private int mDataLineNumber = 0;
    private HashMap<String, Integer> sampleKeys = new HashMap();
    private HashMap<String, Boolean> formatKeys = new HashMap();
    private static HashMap<String, String> encodedToDecodedMap = new HashMap();
    private VCFHeaderParser.WarningCallback senderCallback = new VCFHeaderParser.WarningCallback(){

        @Override
        public void warning(String message) {
            VCF2VariantPipe.this.sender.write(message);
        }
    };
    private VCFHeaderParser headerParser;
    private static DoubleUtil doubleUtil;
    private Set<String> undefinedFormatFields = new HashSet<String>();
    private boolean allSamples = false;
    private boolean processSamples = false;
    boolean forceACANAF = false;
    boolean hasSamplesChecked = false;

    public VCF2VariantPipe() {
    }

    public VCF2VariantPipe(Sender s) {
        this.sender = s;
    }

    public VCF2VariantPipe(boolean includeSamples) {
        this.processSamples = includeSamples;
    }

    public VCF2VariantPipe(Sender sender, boolean includeSamples) {
        this.sender = sender;
        this.processSamples = includeSamples;
    }

    public VCF2VariantPipe(boolean includeSamples, boolean AllSamples) {
        this.processSamples = includeSamples;
        this.allSamples = AllSamples;
    }

    public VCF2VariantPipe(Sender sender, boolean includeSamples, boolean allSamples) {
        this.sender = sender;
        this.processSamples = includeSamples;
        this.allSamples = allSamples;
    }

    public void setAddFlagFalseValuesToJson(boolean isAddFlagFalseValues) {
        this.isAddFlagFalseValuesToJson = isAddFlagFalseValues;
    }

    protected History processNextStart() throws NoSuchElementException, InvalidPipeInputException {
        History history = (History)this.starts.next();
        ++this.mDataLineNumber;
        if (!this.isHeaderProcessed) {
            List<String> headerLines = history.getMetaData().getOriginalHeader();
            this.mHeaderLineCount = headerLines.size();
            this.headerParser = new VCFHeaderParser(this.senderCallback);
            this.headerParser.parse(headerLines);
            this.isHeaderProcessed = true;
        }
        this.throwExceptionIfLineDoesNotHaveTheMinRequiredColumns(history);
        if (this.mDataLineNumber == 1 && this.processSamples) {
            List<ColumnMetaData> cols = history.getMetaData().getColumns();
            if (cols.size() <= 8) {
                sLogger.warn("Cannot process samples.  No sample columns found.");
                this.processSamples = false;
            } else if (!cols.get(8).getColumnName().equals("FORMAT")) {
                sLogger.warn("Cannot process samples.  No FORMAT column found.");
                this.processSamples = false;
            }
        }
        this.hasSamples(history);
        String json = this.buildJSON(history);
        history.add(json);
        return history;
    }

    private void throwExceptionIfLineDoesNotHaveTheMinRequiredColumns(History history) throws InvalidPipeInputException {
        if (history.size() < COL_HEADERS.length) {
            int requiredColCount = COL_HEADERS.length;
            int actualColCount = history.size();
            StringBuilder sb = new StringBuilder();
            sb.append("Invalid VCF data line at data line # %s.\n");
            sb.append("The VCF format requires %s fixed fields per data line, but found only %s field(s).\n");
            sb.append("Make sure the VCF file has the necessary %s VCF fields delimited by TAB characters.\n");
            sb.append("Invalid VCF line content: \"%s\"");
            String errorMesg = String.format(sb.toString(), String.valueOf(this.mDataLineNumber), requiredColCount, actualColCount, requiredColCount, history.getMergedData("\t"));
            throw new InvalidPipeInputException(errorMesg, (Pipe)this);
        }
    }

    private String buildJSON(History history) {
        JsonObject root = new JsonObject();
        String chrom = ((String)history.get(0)).trim();
        String pos = ((String)history.get(1)).trim();
        String id = ((String)history.get(2)).trim();
        String ref = ((String)history.get(3)).trim();
        String alts = ((String)history.get(4)).trim();
        String qual = ((String)history.get(5)).trim();
        String filter = ((String)history.get(6)).trim();
        String info = ((String)history.get(7)).trim();
        root.addProperty(COL_HEADERS[0], chrom);
        if (this.isGiven(pos)) {
            root.addProperty(COL_HEADERS[1], (Number)Integer.parseInt(pos));
        }
        if (this.isGiven(id)) {
            root.addProperty(COL_HEADERS[2], id);
        }
        if (this.isGiven(ref)) {
            root.addProperty(COL_HEADERS[3], ref);
        }
        if (this.isGiven(alts)) {
            root.addProperty(COL_HEADERS[4], alts);
        }
        if (this.isGiven(qual)) {
            if (this.isFloat(qual)) {
                root.addProperty(COL_HEADERS[5], (Number)Float.valueOf(Float.parseFloat(qual)));
            } else {
                sLogger.warn("QUAL field should be a float value on line: " + history.getMergedData("\t"));
            }
        }
        if (this.isGiven(filter)) {
            root.addProperty(COL_HEADERS[6], filter);
        }
        boolean error = false;
        for (int i = 0; i < 8; ++i) {
            String test = ((String)history.get(i)).trim();
            if (test.length() >= 1) continue;
            error = true;
        }
        if (error) {
            this.sender.write("ERROR: The following line does not have the required vcf fields (CHROM, POS, ID, REF, ALT, QUAL, FILTER, INFO, FORMAT): " + this.reformat(history));
        }
        JsonObject infoObj = this.buildInfoJSON(info, history);
        root.add(COL_HEADERS[7], (JsonElement)infoObj);
        this.addCoreAttributes(root, history);
        if (this.processSamples) {
            try {
                this.processSamples(root, history);
            }
            catch (ParseException ex) {
                this.sender.write("WARNING: Problem parsing samples: " + ex.getMessage());
            }
        }
        return root.toString();
    }

    private boolean isFloat(String val) {
        try {
            Float.parseFloat(val);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isInteger(String val) {
        try {
            Integer.parseInt(val);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isGiven(String id) {
        return id.trim().length() > 0 && !id.trim().equals(".");
    }

    public String reformat(List<String> line) {
        StringBuilder sb = new StringBuilder();
        for (int col = 0; col < line.size(); ++col) {
            if (col > 0) {
                sb.append("\t");
            }
            sb.append(line.get(col));
        }
        return sb.toString();
    }

    private JsonObject buildInfoJSON(String infoCol, List<String> dataLine) {
        HeaderFieldDefinition defaultMeta = new HeaderFieldDefinition();
        defaultMeta.id = "not_defined";
        defaultMeta.number = 1;
        defaultMeta.type = HeaderFieldDefinitionHelpers.ValueType.String;
        defaultMeta.fieldType = "INFO";
        JsonObject info = new JsonObject();
        ArrayList<String> flagsToAddToJson = new ArrayList<String>(this.headerParser.getInfoFlags());
        for (String field : Optimized.split(infoCol, ';')) {
            if (field.equals(".")) continue;
            if (field.indexOf(61) != -1) {
                this.addKeyValuePairToJson(dataLine, defaultMeta, info, field);
                continue;
            }
            if (field.length() <= 0) continue;
            info.addProperty(field, Boolean.valueOf(true));
            flagsToAddToJson.remove(field);
        }
        while (this.isAddFlagFalseValuesToJson && flagsToAddToJson.size() > 0) {
            info.addProperty((String)flagsToAddToJson.get(0), Boolean.valueOf(false));
            flagsToAddToJson.remove(0);
        }
        if (this.forceACANAF) {
            if (!info.has("AC")) {
                info.addProperty("AC", (Number)-1);
            }
            if (!info.has("AN")) {
                info.addProperty("AN", (Number)-1);
            }
            if (!info.has("AF")) {
                info.addProperty("AF", (Number)-1);
            }
        }
        return info;
    }

    private void addKeyValuePairToJson(List<String> dataLine, HeaderFieldDefinition defaultMeta, JsonObject info, String field) {
        int firstEq = field.indexOf(61);
        String id = field.substring(0, firstEq);
        String value = field.substring(firstEq + 1);
        HeaderFieldDefinition def = defaultMeta;
        if (this.headerParser.getInfoDefinition(id) != null) {
            def = this.headerParser.getInfoDefinition(id);
        }
        if (def.number == null || def.number > 1) {
            this.addArrayToJson(dataLine, info, id, value, def);
        } else if (def.number == 1) {
            this.addSingleValueToJson(dataLine, info, id, value, def);
        }
    }

    private String decodeSpecialCharacters(String value) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '%' && i <= value.length() - 3) {
                String triplet = value.substring(i, i + 3);
                String decoded = encodedToDecodedMap.get(triplet);
                if (decoded == null) {
                    s.append(c);
                    continue;
                }
                s.append(decoded);
                i += triplet.length() - 1;
                continue;
            }
            s.append(c);
        }
        return s.toString();
    }

    private void addSingleValueToJson(List<String> dataLine, JsonObject info, String id, String value, HeaderFieldDefinition def) {
        switch (def.type) {
            case Integer: {
                if (this.isMissingValue(value)) break;
                try {
                    info.addProperty(id, (Number)this.parseInt(value.trim()));
                }
                catch (Exception e) {
                    this.sender.write("WARNING: Invalid VCF Line, id=" + id + ", " + value.trim() + " does not appear to be an Integer : " + this.reformat(dataLine));
                }
                break;
            }
            case Float: {
                if (this.isMissingValue(value)) break;
                try {
                    info.addProperty(id, this.parseDouble(value.trim()));
                }
                catch (Exception e) {
                    this.sender.write("WARNING: Invalid VCF Line, id=" + id + ", " + value.trim() + " does not appear to be a Float : " + this.reformat(dataLine));
                }
                break;
            }
            case Character: 
            case String: {
                value = this.decodeSpecialCharacters(value);
                info.addProperty(id, value);
            }
        }
    }

    private void addArrayToJson(List<String> dataLine, JsonObject info, String id, String value, HeaderFieldDefinition def) {
        JsonArray arr = new JsonArray();
        block9: for (String s : Optimized.split(value, ',')) {
            s = this.decodeSpecialCharacters(s);
            switch (def.type) {
                case Integer: {
                    if (this.isMissingValue(s)) continue block9;
                    try {
                        arr.add((JsonElement)new JsonPrimitive((Number)this.parseInt(s.trim())));
                    }
                    catch (Exception e) {
                        this.sender.write("WARNING: Invalid VCF Line, id=" + id + ", " + value.trim() + " does not appear to be an Integer : " + this.reformat(dataLine));
                    }
                    continue block9;
                }
                case Float: {
                    if (this.isMissingValue(s)) continue block9;
                    try {
                        arr.add((JsonElement)new JsonPrimitive(this.parseDouble(s.trim())));
                    }
                    catch (Exception e) {
                        this.sender.write("WARNING: Invalid VCF Line, id=" + id + ", " + value.trim() + " does not appear to be a Float : " + this.reformat(dataLine));
                    }
                    continue block9;
                }
                case Character: 
                case String: {
                    arr.add((JsonElement)new JsonPrimitive(s));
                }
            }
        }
        if (arr.size() > 0) {
            info.add(id, (JsonElement)arr);
        }
    }

    private void processSamples(JsonObject root, History history) throws ParseException {
        String[] formatFields = Optimized.split((String)history.get(8), ':');
        int GTPosition = this.findGT(formatFields);
        int ADPosition = this.findAD(formatFields);
        HashMap<String, HeaderFieldDefinition> formatMetaData = new HashMap<String, HeaderFieldDefinition>();
        for (String formatField : formatFields) {
            HeaderFieldDefinition metadata = this.headerParser.getFormatDefinition(formatField);
            if (metadata == null) {
                metadata = this.getDefaultFormatMetadata(formatField);
            }
            formatMetaData.put(formatField, metadata);
            this.formatKeys.put(formatField, true);
        }
        VariantCalculations calculations = new VariantCalculations(formatFields.length);
        for (int i = 9; i < history.size(); ++i) {
            String sampleName = history.getMetaData().getColumns().get(i).getColumnName();
            String sampleValue = (String)history.get(i);
            this.processSample(sampleName, sampleValue, formatFields, formatMetaData, GTPosition, ADPosition, calculations);
            this.sampleKeys.put(sampleName, i + 1);
        }
        root.add("FORMAT", (JsonElement)this.buildFormatJSON(formatFields, formatMetaData, calculations));
        root.add("CUSTOM", (JsonElement)this.buildCustomJSON(calculations));
    }

    private void processSample(String sampleName, String sampleValue, String[] formatFields, Map<String, HeaderFieldDefinition> formatMetaData, int GTPosition, int ADPosition, VariantCalculations calculations) throws ParseException {
        String[] fieldValues = Optimized.split(sampleValue, ':');
        if (fieldValues.length > formatFields.length) {
            String message = "WARNING: VCF2VariantPipe.parseSample: the number of tokens in the format field (" + formatFields.length + ") and the number of tokens in the sample (" + fieldValues.length + ") do not agree. \nFORMAT:" + Arrays.toString(formatFields) + "\nSAMPLE: " + sampleName + "\n";
            this.sender.write(message);
            throw new ParseException(message, 0);
        }
        if (GTPosition > -1) {
            String gtValue = fieldValues[GTPosition];
            gtValue = gtValue.replace('|', '/');
            String[] tokens = Optimized.split(gtValue, '/');
            Zygocity zygocity = this.calculateZygosity(tokens);
            if (this.sampleHasVariant(tokens)) {
                ++calculations.GenotypePostitiveCount;
                calculations.GenotypePositiveSamples.add((JsonElement)new JsonPrimitive(sampleName));
                if (zygocity == Zygocity.Heterozygous) {
                    calculations.hetrozygus.add((JsonElement)new JsonPrimitive(sampleName));
                } else if (zygocity == Zygocity.Homozygous) {
                    calculations.homozygus.add((JsonElement)new JsonPrimitive(sampleName));
                }
            } else if (zygocity == Zygocity.WildType) {
                JsonPrimitive zy = new JsonPrimitive(sampleName);
                calculations.wildtype.add((JsonElement)zy);
            }
        }
        for (int i = 0; i < fieldValues.length; ++i) {
            String fieldName = formatFields[i];
            String fieldValue = fieldValues[i];
            HeaderFieldDefinition metadata = formatMetaData.get(fieldName);
            if (metadata.type.equals((Object)HeaderFieldDefinitionHelpers.ValueType.Integer)) {
                if (metadata.isArray()) {
                    for (String arrayValue : Optimized.split(fieldValue, ',')) {
                        if (this.isMissingValue(arrayValue)) continue;
                        try {
                            int intValue = this.parseInt(arrayValue);
                            calculations.updateIntegerMinMax(i, intValue);
                        }
                        catch (NumberFormatException intValue) {
                            // empty catch block
                        }
                    }
                } else if (!this.isMissingValue(fieldValue)) {
                    try {
                        int intValue = this.parseInt(fieldValue);
                        calculations.updateIntegerMinMax(i, intValue);
                    }
                    catch (NumberFormatException intValue) {}
                }
            } else if (metadata.type.equals((Object)HeaderFieldDefinitionHelpers.ValueType.Float)) {
                if (metadata.isArray()) {
                    for (String arrayValue : Optimized.split(fieldValue, ',')) {
                        if (this.isMissingValue(arrayValue)) continue;
                        try {
                            double doubleValue = this.parseDouble(arrayValue).doubleValue();
                            calculations.updateDoubleMinMax(i, doubleValue);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                } else if (!this.isMissingValue(fieldValue)) {
                    try {
                        double doubleValue = this.parseDouble(fieldValue).doubleValue();
                        calculations.updateDoubleMinMax(i, doubleValue);
                    }
                    catch (NumberFormatException doubleValue) {
                        // empty catch block
                    }
                }
            }
            if (ADPosition <= -1 || ADPosition != i) continue;
            String[] arrayValues = Optimized.split(fieldValue, ',');
            ArrayList<Double> doubles = new ArrayList<Double>();
            try {
                for (int arrIdx = 0; arrIdx < arrayValues.length; ++arrIdx) {
                    String value = arrayValues[arrIdx];
                    if (this.isMissingValue(value)) continue;
                    doubles.add(this.parseDouble(value).doubleValue());
                }
                this.addMinMaxAD(calculations.totalAD, doubles);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public Number parseDouble(String s) {
        if (s.equalsIgnoreCase("Infinity") || s.equalsIgnoreCase("nan") || s.equalsIgnoreCase("-nan")) {
            return doubleUtil.getMAX_VALUE();
        }
        try {
            if (this.isBigDecimalRequired(s)) {
                return new BigDecimal(s);
            }
            return Optimized.parseDouble(s);
        }
        catch (Exception nfe) {
            return Double.parseDouble(s);
        }
    }

    private boolean isBigDecimalRequired(String s) {
        int idxDot = s.indexOf(".");
        int len = s.length();
        return idxDot == -1 && len > 7 || idxDot > 7 || len - 1 - idxDot > 16 || len - 1 > 17 && s.startsWith("0.") || len - 1 > 16 && !s.startsWith("0.");
    }

    private int parseInt(String s) {
        if (s.equalsIgnoreCase("Infinity") || s.equalsIgnoreCase("nan") || s.equalsIgnoreCase("-nan")) {
            return Integer.MAX_VALUE;
        }
        return Optimized.parseInt(s);
    }

    private HeaderFieldDefinition getDefaultFormatMetadata(String formatField) {
        HeaderFieldDefinition metadata = new HeaderFieldDefinition();
        metadata.id = formatField;
        metadata.fieldType = "FORMAT";
        if (formatField.equals("GT")) {
            metadata.desc = "Genotype";
            metadata.number = 1;
            metadata.type = HeaderFieldDefinitionHelpers.ValueType.String;
        } else if (formatField.equals("DP")) {
            metadata.desc = "Read Depth";
            metadata.number = 1;
            metadata.type = HeaderFieldDefinitionHelpers.ValueType.Integer;
        } else if (formatField.equals("FT")) {
            metadata.desc = "sample genotype filter indicating if this genotype was called";
            metadata.number = 1;
            metadata.type = HeaderFieldDefinitionHelpers.ValueType.String;
        } else if (formatField.equals("GL")) {
            metadata.desc = "genotype likelihoods";
            metadata.number = null;
            metadata.type = HeaderFieldDefinitionHelpers.ValueType.Float;
        } else if (formatField.equals("GLE")) {
            metadata.desc = "genotype likelihoods of heterogeneous ploidy, used in presence of uncertain copy number";
            metadata.number = null;
            metadata.type = HeaderFieldDefinitionHelpers.ValueType.String;
        } else if (formatField.equals("PL")) {
            metadata.desc = "the phred-scaled genotype likelihoods rounded to the closest integer";
            metadata.number = null;
            metadata.type = HeaderFieldDefinitionHelpers.ValueType.Integer;
        } else if (formatField.equals("GP")) {
            metadata.desc = "the phred-scaled genotype posterior probabilities;intended to store imputed genotype probabilities";
            metadata.number = null;
            metadata.type = HeaderFieldDefinitionHelpers.ValueType.Float;
        } else if (formatField.equals("GQ")) {
            metadata.desc = "conditional genotype quality, encoded as a phred quality";
            metadata.number = 1;
            metadata.type = HeaderFieldDefinitionHelpers.ValueType.Integer;
        } else if (formatField.equals("HQ")) {
            metadata.desc = "haplotype qualities, two comma separated phred qualities";
            metadata.number = null;
            metadata.type = HeaderFieldDefinitionHelpers.ValueType.Integer;
        } else if (formatField.equals("PS")) {
            metadata.desc = "phase set. A phase set is defined as a set of phased genotypes to which this genotype belongs.";
            metadata.number = 1;
            metadata.type = HeaderFieldDefinitionHelpers.ValueType.Integer;
        } else if (formatField.equals("PQ")) {
            metadata.desc = "phasing quality, the phred-scaled probability that alleles are ordered incorrectly in a heterozygote (against all other members in the phase set).";
            metadata.number = 1;
            metadata.type = HeaderFieldDefinitionHelpers.ValueType.Integer;
        } else if (formatField.equals("EC")) {
            metadata.desc = "comma separated list of expected alternate allele counts for each alternate allele in the same order as listed in the ALT field (typically used in association analyses)";
            metadata.number = null;
            metadata.type = HeaderFieldDefinitionHelpers.ValueType.Integer;
        } else if (formatField.equals("MQ")) {
            metadata.desc = "RMS mapping quality, similar to the version in the INFO field.";
            metadata.number = 1;
            metadata.type = HeaderFieldDefinitionHelpers.ValueType.Integer;
        } else {
            metadata.desc = "not defined";
            metadata.number = null;
            metadata.type = HeaderFieldDefinitionHelpers.ValueType.String;
            if (!this.undefinedFormatFields.contains(formatField)) {
                this.sender.write(String.format("WARNING: A ##FORMAT header line was not found for %s.  By default, this field will use ##FORMAT=<ID=%s,Number=.,Type=String,Description=\"unknown\">", formatField, formatField));
                this.undefinedFormatFields.add(formatField);
            }
        }
        return metadata;
    }

    private void addCoreAttributes(JsonObject root, List<String> history) {
        String chrom = GenomicObjectUtils.computechr(history.get(0).trim());
        String pos = history.get(1).trim();
        String id = history.get(2).trim();
        String ref = history.get(3).trim();
        String alts = history.get(4).trim();
        if (this.isGiven(id)) {
            root.addProperty(CoreAttributes._id.toString(), id);
        }
        if (this.isGiven(chrom) && this.isGiven(pos) && this.isGiven(ref)) {
            root.addProperty(CoreAttributes._type.toString(), Type.VARIANT.toString());
        }
        root.addProperty(CoreAttributes._landmark.toString(), chrom);
        if (this.isGiven(ref)) {
            root.addProperty(CoreAttributes._refAllele.toString(), ref);
        }
        if (this.isGiven(alts)) {
            JsonArray altAlleles = new JsonArray();
            for (String allele : this.al(alts)) {
                altAlleles.add((JsonElement)new JsonPrimitive(allele));
            }
            root.add(CoreAttributes._altAlleles.toString(), (JsonElement)altAlleles);
        }
        if (this.isGiven(pos)) {
            int minBP = Integer.parseInt(pos);
            int maxBP = this.calculateMaxBP(minBP, ref, history);
            root.addProperty(CoreAttributes._minBP.toString(), (Number)minBP);
            root.addProperty(CoreAttributes._maxBP.toString(), (Number)maxBP);
        }
    }

    private int calculateMaxBP(int minBP, String ref, List<String> history) {
        String alt = history.get(4);
        String info = history.get(7);
        int maxBP = new Integer(minBP + ref.length() - 1);
        String endStr = this.getInfoVal(info, "END");
        if (alt.startsWith("<") && endStr != null && this.isInteger(endStr)) {
            maxBP = Integer.parseInt(endStr);
        }
        return maxBP;
    }

    private String getInfoVal(String info, String key) {
        String[] keyVals;
        for (String keyVal : keyVals = info.split(";")) {
            String[] keyAndVal = keyVal.split("=");
            String k = keyAndVal[0];
            if (k.equals(".") || !k.equals(key)) continue;
            if (keyAndVal.length == 1) {
                return "true";
            }
            return keyAndVal[1];
        }
        return null;
    }

    private String[] al(String raw) {
        ArrayList<String> finalList = new ArrayList<String>();
        if (raw.contains(",")) {
            String[] split = Optimized.split(raw, ',');
            for (int i = 0; i < split.length; ++i) {
                finalList.add(split[i]);
            }
        } else {
            finalList.add(raw);
        }
        return finalList.toArray(new String[0]);
    }

    private boolean isMissingValue(String value) {
        String trimVal = value.trim();
        return trimVal.equals(".");
    }

    private int findGT(String[] t) {
        return this.findT(t, "GT");
    }

    private int findAD(String[] t) {
        return this.findT(t, "AD");
    }

    private int findT(String[] t, String tok) {
        for (int i = 0; i < t.length; ++i) {
            if (!t[i].equalsIgnoreCase(tok)) continue;
            return i;
        }
        return -1;
    }

    public boolean sampleHasVariant(String[] tokens) {
        for (String token : tokens) {
            if (!token.equals("1") && !token.equals("2")) continue;
            return true;
        }
        return false;
    }

    public void addMinMaxAD(Totals totals, List<Double> values) {
        for (int i = 1; i < values.size(); ++i) {
            double d = values.get(i);
            if (d > totals.max) {
                totals.max = d;
            }
            if (!(d < totals.min)) continue;
            totals.min = d;
        }
    }

    public JsonObject getSubClause(JsonObject root, String subObjectName) {
        JsonObject subObject = root.getAsJsonObject(subObjectName);
        if (subObject == null) {
            subObject = new JsonObject();
            root.add(subObjectName, (JsonElement)subObject);
            return subObject;
        }
        return subObject;
    }

    public Zygocity calculateZygosity(String[] tokens) {
        int zerocount = 0;
        int count = 0;
        for (String token : tokens) {
            String trimToken = token.trim();
            if (trimToken.length() == 0) continue;
            char c = trimToken.charAt(0);
            if (c == '0') {
                ++zerocount;
                continue;
            }
            if (c == '.' || !Character.isDigit(c)) continue;
            ++count;
        }
        if (count == 1) {
            return Zygocity.Heterozygous;
        }
        if (count > 1) {
            return Zygocity.Homozygous;
        }
        if (zerocount > 1) {
            return Zygocity.WildType;
        }
        return Zygocity.NoCall;
    }

    public JsonObject buildFormatJSON(String[] formatFields, Map<String, HeaderFieldDefinition> formatMetaData, VariantCalculations calculations) {
        JsonObject max = new JsonObject();
        JsonObject min = new JsonObject();
        for (int i = 0; i < formatFields.length; ++i) {
            String fieldName = formatFields[i];
            HeaderFieldDefinition metadata = formatMetaData.get(fieldName);
            if (metadata.type.equals((Object)HeaderFieldDefinitionHelpers.ValueType.Integer)) {
                try {
                    min.addProperty(fieldName, (Number)calculations.getIntegerMin(i));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    max.addProperty(fieldName, (Number)calculations.getIntegerMax(i));
                }
                catch (Exception exception) {}
                continue;
            }
            if (!metadata.type.equals((Object)HeaderFieldDefinitionHelpers.ValueType.Float)) continue;
            try {
                min.addProperty(fieldName, (Number)calculations.getDoubleMin(i));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                max.addProperty(fieldName, (Number)calculations.getDoubleMax(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JsonObject format = new JsonObject();
        format.add("max", (JsonElement)max);
        format.add("min", (JsonElement)min);
        format.addProperty("GenotypePostitiveCount", (Number)calculations.GenotypePostitiveCount);
        format.add("GenotypePositiveList", (JsonElement)calculations.GenotypePositiveSamples);
        format.add("HeterozygousList", (JsonElement)calculations.hetrozygus);
        format.add("HomozygousList", (JsonElement)calculations.homozygus);
        format.add("WildtypeList", (JsonElement)calculations.wildtype);
        return format;
    }

    public JsonObject buildCustomJSON(VariantCalculations calculations) {
        JsonObject custom = new JsonObject();
        JsonObject maxAD = this.getSubClause(custom, "max");
        JsonObject minAD = this.getSubClause(custom, "min");
        maxAD.addProperty("AD", (Number)calculations.totalAD.max);
        minAD.addProperty("AD", (Number)calculations.totalAD.min);
        return custom;
    }

    public JsonObject getJSONMetadata() {
        JsonObject json = new JsonObject();
        JsonObject header = new JsonObject();
        JsonObject format = new JsonObject();
        JsonObject samples = new JsonObject();
        JsonObject infoJSON = new JsonObject();
        for (InfoHeader infoHeader : this.headerParser.getInfoDefinitions()) {
            JsonObject jsonDef = new JsonObject();
            this.addCommonProperties(infoHeader, jsonDef);
            if (infoHeader.source != null && infoHeader.source.length() > 0) {
                jsonDef.addProperty("Source", infoHeader.source);
            }
            if (infoHeader.version != null && infoHeader.version.length() > 0) {
                jsonDef.addProperty("Version", infoHeader.version);
            }
            infoJSON.add(infoHeader.id, (JsonElement)jsonDef);
        }
        header.add("INFO", (JsonElement)infoJSON);
        JsonObject formatJSON = new JsonObject();
        for (HeaderFieldDefinition def : this.headerParser.getFormatDefinitions()) {
            JsonObject jsonDef = new JsonObject();
            this.addCommonProperties(def, jsonDef);
            formatJSON.add(def.id, (JsonElement)jsonDef);
        }
        header.add("FORMAT", (JsonElement)formatJSON);
        JsonObject jsonObject = new JsonObject();
        for (MetaHeader def : this.headerParser.getMetaDefinitions()) {
            JsonObject jsonDef = new JsonObject();
            this.addCommonProperties(def, jsonDef);
            JsonArray valueArr = new JsonArray();
            for (String value : def.values) {
                JsonPrimitive p;
                switch (def.type) {
                    case Integer: {
                        p = new JsonPrimitive((Number)Integer.parseInt(value));
                        break;
                    }
                    case Float: {
                        p = new JsonPrimitive((Number)Float.valueOf(Float.parseFloat(value)));
                        break;
                    }
                    default: {
                        p = new JsonPrimitive(value);
                    }
                }
                valueArr.add((JsonElement)p);
            }
            jsonDef.add("Values", (JsonElement)valueArr);
            jsonObject.add(def.id, (JsonElement)jsonDef);
        }
        header.add("META", (JsonElement)jsonObject);
        for (String key : this.formatKeys.keySet()) {
            format.addProperty(key, (Number)1);
        }
        for (String key : this.sampleKeys.keySet()) {
            samples.addProperty(key, (Number)this.sampleKeys.get(key));
        }
        json.add("HEADER", (JsonElement)header);
        json.add("FORMAT", (JsonElement)format);
        json.add("SAMPLES", (JsonElement)samples);
        return json;
    }

    private void addCommonProperties(HeaderFieldDefinition def, JsonObject jsonDef) {
        if (def.number == null) {
            jsonDef.addProperty("number", ".");
        } else {
            jsonDef.addProperty("number", (Number)def.number);
        }
        jsonDef.addProperty("type", def.type.toString());
        jsonDef.addProperty("Description", def.desc);
        jsonDef.addProperty("EntryType", def.fieldType);
    }

    public static double min(List<Double> m) {
        double min = doubleUtil.getMAX_VALUE();
        for (double d : m) {
            if (!(d < min)) continue;
            min = d;
        }
        return min;
    }

    public static double max(List<Double> m) {
        double max = doubleUtil.getNEGATIVE_INFINITY();
        for (double d : m) {
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }

    public static double average(List<Double> m) {
        double sum = 0.0;
        for (double d : m) {
            sum += d;
        }
        if (m.size() == 0) {
            return doubleUtil.getNaN();
        }
        return sum / (double)m.size();
    }

    public static double median(double[] m) {
        int middle = m.length / 2;
        if (m.length % 2 == 1) {
            return m[middle];
        }
        return (m[middle - 1] + m[middle]) / 2.0;
    }

    public boolean hasSamples(History h) {
        this.hasSamplesChecked = true;
        if (true) {
            return this.processSamples;
        }
        if (!this.processSamples) {
            return this.processSamples;
        }
        if (h.size() < 10) {
            this.hasSamplesChecked = true;
            this.processSamples = false;
            return false;
        }
        this.hasSamplesChecked = true;
        return true;
    }

    public Iterator<SampleHeader> getSampleDefinitions() {
        return this.headerParser.getSampleDefinitions().iterator();
    }

    public Set<String> getFormatKeys() {
        return this.formatKeys.keySet();
    }

    public int getHeaderLineCount() {
        return this.mHeaderLineCount;
    }

    static {
        encodedToDecodedMap.put("%3A", ":");
        encodedToDecodedMap.put("%3B", ";");
        encodedToDecodedMap.put("%3D", "=");
        encodedToDecodedMap.put("%25", "%");
        encodedToDecodedMap.put("%2C", ",");
        doubleUtil = new DoubleUtil();
    }

    public static enum Zygocity {
        WildType(0),
        Heterozygous(1),
        Homozygous(2),
        NoCall(3);

        private int type = 0;

        private Zygocity(int t) {
            this.type = t;
        }

        public int getType() {
            return this.type;
        }
    }

    private class Totals {
        public double min = VCF2VariantPipe.access$200().getMAX_VALUE();
        public double max = VCF2VariantPipe.access$200().getMIN_VALUE();

        private Totals() {
        }
    }

    class VariantCalculations {
        int GenotypePostitiveCount = 0;
        JsonArray GenotypePositiveSamples = new JsonArray();
        JsonArray hetrozygus = new JsonArray();
        JsonArray homozygus = new JsonArray();
        JsonArray wildtype = new JsonArray();
        private int[] integerMax;
        private int[] integerMin;
        private double[] doubleMax;
        private double[] doubleMin;
        Totals totalAD = new Totals();

        public VariantCalculations(int numFormatFields) {
            this.integerMin = new int[numFormatFields];
            Arrays.fill(this.integerMin, Integer.MAX_VALUE);
            this.integerMax = new int[numFormatFields];
            Arrays.fill(this.integerMax, Integer.MIN_VALUE);
            this.doubleMin = new double[numFormatFields];
            Arrays.fill(this.doubleMin, doubleUtil.getMAX_VALUE());
            this.doubleMax = new double[numFormatFields];
            Arrays.fill(this.doubleMax, doubleUtil.getMIN_VALUE());
        }

        public void updateIntegerMinMax(int formatFieldIdx, int intValue) {
            this.integerMin[formatFieldIdx] = intValue < this.integerMin[formatFieldIdx] ? intValue : this.integerMin[formatFieldIdx];
            this.integerMax[formatFieldIdx] = intValue > this.integerMax[formatFieldIdx] ? intValue : this.integerMax[formatFieldIdx];
        }

        public void updateDoubleMinMax(int formatFieldIdx, double doubleValue) {
            this.doubleMin[formatFieldIdx] = doubleValue < this.doubleMin[formatFieldIdx] ? doubleValue : this.doubleMin[formatFieldIdx];
            this.doubleMax[formatFieldIdx] = doubleValue > this.doubleMax[formatFieldIdx] ? doubleValue : this.doubleMax[formatFieldIdx];
        }

        public int getIntegerMin(int formatFieldIdx) throws Exception {
            int value = this.integerMin[formatFieldIdx];
            if (value == Integer.MAX_VALUE) {
                throw new Exception("No integer min");
            }
            return value;
        }

        public int getIntegerMax(int formatFieldIdx) throws Exception {
            int value = this.integerMax[formatFieldIdx];
            if (value == Integer.MIN_VALUE) {
                throw new Exception("No integer max");
            }
            return value;
        }

        public double getDoubleMin(int formatFieldIdx) throws Exception {
            double value = this.doubleMin[formatFieldIdx];
            if (value == doubleUtil.getMAX_VALUE()) {
                throw new Exception("No double min");
            }
            return value;
        }

        public double getDoubleMax(int formatFieldIdx) throws Exception {
            double value = this.doubleMax[formatFieldIdx];
            if (value == doubleUtil.getMIN_VALUE()) {
                throw new Exception("No double max");
            }
            return value;
        }
    }
}

