/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.tabix;

import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import edu.mayo.pipes.JSON.tabix.VariantBasic;
import edu.mayo.pipes.JSON.tabix.VariantJsonQuickParser;
import edu.mayo.pipes.bioinformatics.vocab.ComparableObjectInterface;
import edu.mayo.pipes.bioinformatics.vocab.CoreAttributes;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;

public class SameVariantLogic
implements ComparableObjectInterface {
    private boolean isCheckRsidAlso = false;
    private JsonPath chrJsonPath = null;
    private JsonPath minBpJsonPath = null;
    private JsonPath rsIdJsonPath = null;
    private JsonPath refJsonPath = null;
    private JsonPath altJsonPath = null;
    private VariantJsonQuickParser variantQuickParser = new VariantJsonQuickParser();

    public SameVariantLogic() {
        this(false);
    }

    public SameVariantLogic(boolean isCheckRsidAlso) {
        this.isCheckRsidAlso = isCheckRsidAlso;
        this.chrJsonPath = JsonPath.compile((String)CoreAttributes._landmark.toString(), (Predicate[])new Predicate[0]);
        this.minBpJsonPath = JsonPath.compile((String)CoreAttributes._minBP.toString(), (Predicate[])new Predicate[0]);
        this.rsIdJsonPath = JsonPath.compile((String)CoreAttributes._id.toString(), (Predicate[])new Predicate[0]);
        this.refJsonPath = JsonPath.compile((String)CoreAttributes._refAllele.toString(), (Predicate[])new Predicate[0]);
        this.altJsonPath = JsonPath.compile((String)CoreAttributes._altAlleles.toString(), (Predicate[])new Predicate[0]);
    }

    @Override
    public boolean same(String jsonIn, String jsonCatalog) {
        boolean isRefsAndAltsGiven;
        VariantBasic inputVariant = this.variantQuickParser.getVariantFromJson(jsonIn);
        VariantBasic ctgVariant = this.variantQuickParser.getVariantFromJson(jsonCatalog);
        if (!this.isGiven(inputVariant.chrom) || !inputVariant.chrom.equalsIgnoreCase(ctgVariant.chrom)) {
            return false;
        }
        if (inputVariant.minBp == null || inputVariant.minBp.compareTo(ctgVariant.minBp) != 0) {
            return false;
        }
        boolean bl = isRefsAndAltsGiven = this.isGiven(inputVariant.ref) && this.isGiven(ctgVariant.ref) && inputVariant.alts.size() > 0 && !inputVariant.isAnyDotAlts() && ctgVariant.alts.size() > 0 && !ctgVariant.isAnyDotAlts();
        if (isRefsAndAltsGiven) {
            boolean isRefAlleleMatch = this.isGiven(inputVariant.ref) && inputVariant.ref.equalsIgnoreCase(ctgVariant.ref);
            boolean isAltAlleleMatch = this.isAnyMatchAlts(inputVariant.alts, ctgVariant.alts, inputVariant.maxBp, ctgVariant.maxBp);
            return isRefAlleleMatch && isAltAlleleMatch;
        }
        if (this.isCheckRsidAlso) {
            boolean isRsIdMatch = this.isGiven(inputVariant.rsId) && inputVariant.rsId.equalsIgnoreCase(ctgVariant.rsId);
            return isRsIdMatch;
        }
        return false;
    }

    boolean isAnyMatchAlts(List<String> altsIn, List<String> altsCatalog) {
        return this.isAnyMatchAlts(altsIn, altsCatalog, 0L, 0L);
    }

    boolean isAnyMatchAlts(List<String> altsIn, List<String> altsCatalog, Long inputMaxBp, Long ctgMaxBp) {
        if (altsIn == null || altsCatalog == null || altsIn.size() == 0 || altsCatalog.size() == 0) {
            return false;
        }
        for (String altIn : altsIn) {
            for (String altCatalog : altsCatalog) {
                if (!altIn.equalsIgnoreCase(altCatalog)) continue;
                if (!this.isStructuralAlt(altIn)) {
                    return true;
                }
                if (!this.isStructuralAlt(altIn) || inputMaxBp.compareTo(ctgMaxBp) != 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isStructuralAlt(String alt) {
        return alt != null && alt.startsWith("<") && alt.endsWith(">");
    }

    private boolean isJsonPathOk(String json, JsonPath path) {
        try {
            this.getJsonVal(json, path);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Object getJsonVal(String json, JsonPath path) {
        String pathStr = path.getPath();
        if (pathStr.startsWith("$.")) {
            pathStr = pathStr.substring(2);
        }
        Object val = null;
        try {
            val = path.read(json);
        }
        catch (InvalidPathException e) {
            throw new InvalidPathException("Invalid JSON path: could not find key \"" + pathStr + "\" in target JSON: \n" + json);
        }
        return val;
    }

    private boolean isGiven(String s) {
        return s != null && s.trim().length() > 0 && !".".equals(s.trim());
    }

    private boolean isGiven(ArrayList<String> list) {
        if (list == null) {
            return false;
        }
        for (String s : list) {
            if (this.isGiven(s)) continue;
            return false;
        }
        return true;
    }

    public ArrayList<String> toList(JSONArray jsonArray) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            list.add((String)jsonArray.get(i));
        }
        return list;
    }
}

