/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes;

import com.tinkerpop.pipes.AbstractPipe;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamPipe
extends AbstractPipe<InputStream, String> {
    private static final Logger sLogger = LoggerFactory.getLogger(InputStreamPipe.class);
    private BufferedReader mStreamReader = null;
    private boolean hasMoreData = true;

    protected String processNextStart() throws NoSuchElementException {
        if (this.mStreamReader == null) {
            InputStream inStream = (InputStream)this.starts.next();
            this.mStreamReader = new BufferedReader(new InputStreamReader(inStream));
        }
        try {
            if (!this.hasMoreData) {
                throw new NoSuchElementException();
            }
            String nextLine = this.mStreamReader.readLine();
            if (nextLine == null) {
                this.hasMoreData = false;
                this.mStreamReader.close();
                throw new NoSuchElementException();
            }
            return nextLine;
        }
        catch (IOException e) {
            sLogger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

