/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.plugin.registry;

import htsjdk.beta.exception.HtsjdkPluginException;
import htsjdk.beta.exception.HtsjdkUnsupportedOperationException;
import htsjdk.beta.plugin.HtsCodec;
import htsjdk.beta.plugin.hapref.HaploidReferenceCodec;
import htsjdk.beta.plugin.reads.ReadsCodec;
import htsjdk.beta.plugin.registry.HaploidReferenceResolver;
import htsjdk.beta.plugin.registry.HtsDefaultRegistry;
import htsjdk.beta.plugin.registry.ReadsResolver;
import htsjdk.beta.plugin.registry.VariantsResolver;
import htsjdk.beta.plugin.variants.VariantsCodec;

public class HtsCodecRegistry {
    private final HaploidReferenceResolver htsHaploidReferenceResolver = new HaploidReferenceResolver();
    private final ReadsResolver htsReadsResolver = new ReadsResolver();
    private final VariantsResolver htsVariantsResolver = new VariantsResolver();

    protected HtsCodecRegistry() {
    }

    public synchronized HtsCodec<?, ?> registerCodec(HtsCodec<?, ?> codec) {
        switch (codec.getContentType()) {
            case HAPLOID_REFERENCE: {
                return this.htsHaploidReferenceResolver.registerCodec((HaploidReferenceCodec)codec);
            }
            case ALIGNED_READS: {
                return this.htsReadsResolver.registerCodec((ReadsCodec)codec);
            }
            case VARIANT_CONTEXTS: {
                return this.htsVariantsResolver.registerCodec((VariantsCodec)codec);
            }
            case FEATURES: {
                throw new HtsjdkUnsupportedOperationException("Features codec type not yet implemented");
            }
        }
        throw new HtsjdkPluginException(String.format("Unknown codec content type %s", new Object[]{codec.getContentType()}));
    }

    public static synchronized HtsCodecRegistry createPrivateRegistry() {
        HtsCodecRegistry privateRegistry = new HtsCodecRegistry();
        HtsDefaultRegistry.htsDefaultCodecRegistry.getHaploidReferenceResolver().getCodecs().forEach(c -> privateRegistry.registerCodec((HtsCodec<?, ?>)c));
        HtsDefaultRegistry.htsDefaultCodecRegistry.getReadsResolver().getCodecs().forEach(c -> privateRegistry.registerCodec((HtsCodec<?, ?>)c));
        HtsDefaultRegistry.htsDefaultCodecRegistry.getVariantsResolver().getCodecs().forEach(c -> privateRegistry.registerCodec((HtsCodec<?, ?>)c));
        return privateRegistry;
    }

    public synchronized HaploidReferenceResolver getHaploidReferenceResolver() {
        return this.htsHaploidReferenceResolver;
    }

    public synchronized ReadsResolver getReadsResolver() {
        return this.htsReadsResolver;
    }

    public synchronized VariantsResolver getVariantsResolver() {
        return this.htsVariantsResolver;
    }
}

