/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.io.bundle;

import htsjdk.beta.exception.HtsjdkIOException;
import htsjdk.beta.io.bundle.InputStreamResource;
import htsjdk.beta.io.bundle.SignatureStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.utils.ValidationUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;

public class SeekableStreamResource
extends InputStreamResource {
    private static final long serialVersionUID = 1L;
    private final SeekableStream seekableStream;

    public SeekableStreamResource(SeekableStream seekableStream, String displayName, String contentType) {
        this(seekableStream, displayName, contentType, null);
    }

    public SeekableStreamResource(SeekableStream seekableStream, String displayName, String contentType, String format) {
        super(seekableStream, displayName, contentType, format);
        ValidationUtils.nonNull(seekableStream, "seekable input stream");
        this.seekableStream = seekableStream;
    }

    @Override
    public Optional<InputStream> getInputStream() {
        return Optional.of(this.seekableStream);
    }

    @Override
    public Optional<SeekableStream> getSeekableStream() {
        return Optional.of(this.seekableStream);
    }

    @Override
    public SignatureStream getSignatureStream(int signatureProbeLength) {
        byte[] signaturePrefix = new byte[signatureProbeLength];
        try {
            this.seekableStream.seek(0L);
            this.seekableStream.read(signaturePrefix);
            this.seekableStream.seek(0L);
        }
        catch (IOException e) {
            throw new HtsjdkIOException(String.format("Error creating signature probe for seekable stream resource with prefix size %d", signatureProbeLength), e);
        }
        return new SignatureStream(signatureProbeLength, signaturePrefix);
    }

    @Override
    public boolean hasInputType() {
        return true;
    }

    @Override
    public boolean hasSeekableStream() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SeekableStreamResource)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SeekableStreamResource that = (SeekableStreamResource)o;
        return this.getSeekableStream().equals(that.getSeekableStream());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getSeekableStream().hashCode();
        return result;
    }

    @Override
    public String toString() {
        return String.format("%s: %s", super.toString(), this.seekableStream);
    }
}

