/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.io.bundle;

import htsjdk.beta.exception.HtsjdkException;
import htsjdk.beta.io.bundle.BundleResourceBase;
import htsjdk.beta.io.bundle.SignatureStream;
import htsjdk.utils.ValidationUtils;
import java.io.OutputStream;
import java.util.Optional;

public class OutputStreamResource
extends BundleResourceBase {
    private static final long serialVersionUID = 1L;
    private final OutputStream outputStream;

    public OutputStreamResource(OutputStream outputStream, String displayName, String contentType) {
        this(outputStream, displayName, contentType, null);
    }

    public OutputStreamResource(OutputStream outputStream, String displayName, String contentType, String format) {
        super(displayName, contentType, format);
        ValidationUtils.nonNull(outputStream, "output stream");
        this.outputStream = outputStream;
    }

    @Override
    public Optional<OutputStream> getOutputStream() {
        return Optional.of(this.outputStream);
    }

    @Override
    public SignatureStream getSignatureStream(int signatureProbeLength) {
        throw new HtsjdkException("Cannot create a signature stream for an output stream resource. Use hasInputType to determine if signature stream ");
    }

    @Override
    public boolean hasOutputType() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OutputStreamResource)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OutputStreamResource that = (OutputStreamResource)o;
        return this.getOutputStream().equals(that.getOutputStream());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getOutputStream().hashCode();
        return result;
    }

    @Override
    public String toString() {
        return String.format("%s: %s", super.toString(), this.outputStream);
    }
}

