/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.reads;

import htsjdk.beta.codecs.reads.bam.BAMDecoderOptions;
import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.io.bundle.BundleResource;
import htsjdk.beta.io.bundle.BundleResourceType;
import htsjdk.beta.plugin.reads.ReadsDecoderOptions;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.util.Optional;

public final class ReadsCodecUtils {
    public static SamInputResource bundleToSamInputResource(Bundle inputBundle, ReadsDecoderOptions readsDecoderOptions) {
        SamInputResource samInputResource = ReadsCodecUtils.readsToSamInputResource(inputBundle, BundleResourceType.ALIGNED_READS, readsDecoderOptions);
        ReadsCodecUtils.indexToSamInputResource(inputBundle, "READS_INDEX", readsDecoderOptions, samInputResource);
        return samInputResource;
    }

    public static void readsDecoderOptionsToSamReaderFactory(ReadsDecoderOptions readsDecoderOptions, SamReaderFactory samReaderFactory) {
        samReaderFactory.validationStringency(readsDecoderOptions.getValidationStringency());
        samReaderFactory.setOption(SamReaderFactory.Option.EAGERLY_DECODE, readsDecoderOptions.isDecodeEagerly());
        samReaderFactory.setOption(SamReaderFactory.Option.CACHE_FILE_BASED_INDEXES, readsDecoderOptions.isFileBasedIndexCached());
        samReaderFactory.setOption(SamReaderFactory.Option.DONT_MEMORY_MAP_INDEX, !readsDecoderOptions.isMemoryMapIndexes());
    }

    public static boolean bundleContainsIndex(Bundle inputBundle) {
        return inputBundle.get("READS_INDEX").isPresent();
    }

    public static void assertBundleContainsIndex(Bundle inputBundle) {
        if (!ReadsCodecUtils.bundleContainsIndex(inputBundle)) {
            throw new IllegalArgumentException(String.format("To make index queries, an index resource must be provided in the resource bundle: %s", inputBundle));
        }
    }

    public static SamReader getSamReader(Bundle inputBundle, ReadsDecoderOptions readsDecoderOptions, SamReaderFactory samReaderFactory) {
        SamInputResource samInputResource = ReadsCodecUtils.bundleToSamInputResource(inputBundle, readsDecoderOptions);
        ReadsCodecUtils.readsDecoderOptionsToSamReaderFactory(readsDecoderOptions, samReaderFactory);
        ReadsCodecUtils.bamDecoderOptionsToSamReaderFactory(samReaderFactory, readsDecoderOptions.getBAMDecoderOptions());
        return samReaderFactory.open(samInputResource);
    }

    public static void bamDecoderOptionsToSamReaderFactory(SamReaderFactory samReaderFactory, BAMDecoderOptions bamDecoderOptions) {
        samReaderFactory.inflaterFactory(bamDecoderOptions.getInflaterFactory());
        samReaderFactory.setUseAsyncIo(bamDecoderOptions.isAsyncIO());
        samReaderFactory.setOption(SamReaderFactory.Option.VALIDATE_CRC_CHECKSUMS, bamDecoderOptions.isValidateCRCChecksums());
    }

    private static SamInputResource readsToSamInputResource(Bundle inputBundle, String contentType, ReadsDecoderOptions readsDecoderOptions) {
        BundleResource readsInput = inputBundle.getOrThrow(contentType);
        if (!readsInput.hasInputType()) {
            throw new IllegalArgumentException(String.format("The provided %s resource (%s) must be a readable/input resource", contentType, readsInput));
        }
        if (readsInput.hasSeekableStream()) {
            if (readsInput.getIOPath().isPresent()) {
                if (readsDecoderOptions.getReadsChannelTransformer().isPresent()) {
                    return SamInputResource.of(readsInput.getIOPath().get().toPath(), readsDecoderOptions.getReadsChannelTransformer().get());
                }
                return SamInputResource.of(readsInput.getIOPath().get().toPath());
            }
            if (readsInput.getSeekableStream().isPresent()) {
                return SamInputResource.of(readsInput.getSeekableStream().get());
            }
        }
        return SamInputResource.of(readsInput.getInputStream().get());
    }

    private static void indexToSamInputResource(Bundle inputBundle, String contentType, ReadsDecoderOptions readsDecoderOptions, SamInputResource samInputResource) {
        BundleResource indexResource;
        Optional<BundleResource> indexInput = inputBundle.get(contentType);
        if (indexInput.isPresent() && (indexResource = indexInput.get()).getIOPath().isPresent() && indexResource.getIOPath().isPresent()) {
            if (readsDecoderOptions.getIndexChannelTransformer().isPresent()) {
                SamInputResource.of(indexResource.getIOPath().get().toPath(), readsDecoderOptions.getIndexChannelTransformer().get());
                samInputResource.index(indexResource.getIOPath().get().toPath());
            } else if (indexResource.getSeekableStream().isPresent()) {
                samInputResource.index(indexResource.getSeekableStream().get());
            } else if (indexResource.getInputStream().isPresent()) {
                samInputResource.index(indexResource.getInputStream().get());
            }
        }
    }
}

