/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.alignment;

import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.alignment.AlignmentAlgorithm;
import org.biojava.bio.alignment.AlignmentPair;
import org.biojava.bio.alignment.SubstitutionMatrix;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.SimpleGappedSequence;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;

public class SmithWaterman
extends AlignmentAlgorithm {
    private short match;
    private short replace;
    private short insert;
    private short delete;
    private short gapExt;
    private SubstitutionMatrix subMatrix;

    public SmithWaterman() {
        this.subMatrix = null;
    }

    public SmithWaterman(short match, short replace, short insert, short delete, short gapExtend, SubstitutionMatrix matrix) {
        this.match = -match;
        this.replace = -replace;
        this.insert = -insert;
        this.delete = -delete;
        this.gapExt = -gapExtend;
        this.subMatrix = matrix;
    }

    public short getDelete() {
        return this.delete;
    }

    public short getGapExt() {
        return this.gapExt;
    }

    public short getInsert() {
        return this.insert;
    }

    public short getMatch() {
        return this.match;
    }

    public short getReplace() {
        return this.replace;
    }

    public SubstitutionMatrix getSubMatrix() {
        return this.subMatrix;
    }

    private short matchReplace(Sequence query, Sequence subject, int i, int j) {
        try {
            if (this.subMatrix != null) {
                return this.subMatrix.getValueAt(query.symbolAt(i), subject.symbolAt(j));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (query.symbolAt(i).equals(subject.symbolAt(j))) {
            return this.match;
        }
        return this.replace;
    }

    private int max(int w, int x, int y, int z) {
        if (w > x && w > y && w > z) {
            return w;
        }
        if (x > y && x > z) {
            return x;
        }
        if (y > z) {
            return y;
        }
        return z;
    }

    @Override
    public AlignmentPair pairwiseAlignment(SymbolList query, SymbolList subject) throws BioRuntimeException {
        Object squery = null;
        Object ssubject = null;
        squery = query instanceof Sequence ? (Sequence)query : new SimpleSequence(query, "", "query", (Annotation)new SimpleAnnotation());
        ssubject = subject instanceof Sequence ? (Sequence)subject : new SimpleSequence(subject, "", "subject", (Annotation)new SimpleAnnotation());
        if (squery.getAlphabet().equals(ssubject.getAlphabet()) && (this.subMatrix == null || squery.getAlphabet().equals(this.subMatrix.getAlphabet()))) {
            int j;
            int i;
            SymbolTokenization st;
            StringBuffer[] align = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
            long time = System.currentTimeMillis();
            int maxI = 0;
            int maxJ = 0;
            int queryStart = 0;
            int subjectStart = 0;
            int[][] scoreMatrix = new int[squery.length() + 1][ssubject.length() + 1];
            try {
                st = squery.getAlphabet().getTokenization("default");
            }
            catch (BioException exc) {
                throw new BioRuntimeException((Throwable)exc);
            }
            if (this.gapExt != this.delete || this.gapExt != this.insert) {
                int[][] E = new int[squery.length() + 1][ssubject.length() + 1];
                int[][] F = new int[squery.length() + 1][ssubject.length() + 1];
                scoreMatrix[0][0] = 0;
                F[0][0] = Integer.MIN_VALUE;
                E[0][0] = Integer.MIN_VALUE;
                for (i = 1; i <= squery.length(); ++i) {
                    F[i][0] = 0;
                    scoreMatrix[i][0] = 0;
                    E[i][0] = Integer.MIN_VALUE;
                }
                for (j = 1; j <= ssubject.length(); ++j) {
                    E[0][j] = 0;
                    scoreMatrix[0][j] = 0;
                    F[0][j] = Integer.MIN_VALUE;
                }
                for (i = 1; i <= squery.length(); ++i) {
                    for (j = 1; j <= ssubject.length(); ++j) {
                        E[i][j] = Math.max(E[i][j - 1], scoreMatrix[i][j - 1] + this.insert) + this.gapExt;
                        F[i][j] = Math.max(F[i - 1][j], scoreMatrix[i - 1][j] + this.delete) + this.gapExt;
                        scoreMatrix[i][j] = this.max(0, E[i][j], F[i][j], scoreMatrix[i - 1][j - 1] + this.matchReplace((Sequence)squery, (Sequence)ssubject, i, j));
                        if (scoreMatrix[i][j] <= scoreMatrix[maxI][maxJ]) continue;
                        maxI = i;
                        maxJ = j;
                    }
                }
                try {
                    boolean[] gap_extend = new boolean[]{false, false};
                    j = maxJ;
                    i = maxI;
                    while (i > 0) {
                        do {
                            if (scoreMatrix[i][j] == 0) {
                                queryStart = i;
                                subjectStart = j;
                                j = 0;
                                i = 0;
                                continue;
                            }
                            if (scoreMatrix[i][j] == scoreMatrix[i - 1][j - 1] + this.matchReplace((Sequence)squery, (Sequence)ssubject, i, j) && !gap_extend[0] && !gap_extend[1]) {
                                align[0].insert(0, st.tokenizeSymbol(squery.symbolAt(i--)));
                                align[1].insert(0, st.tokenizeSymbol(ssubject.symbolAt(j--)));
                                continue;
                            }
                            if (scoreMatrix[i][j] == E[i][j] || gap_extend[0]) {
                                gap_extend[0] = E[i][j] != scoreMatrix[i][j - 1] + this.insert + this.gapExt;
                                align[0].insert(0, '-');
                                align[1].insert(0, st.tokenizeSymbol(ssubject.symbolAt(j--)));
                                continue;
                            }
                            gap_extend[1] = F[i][j] != scoreMatrix[i - 1][j] + this.delete + this.gapExt;
                            align[0].insert(0, st.tokenizeSymbol(squery.symbolAt(i--)));
                            align[1].insert(0, '-');
                        } while (j > 0);
                    }
                }
                catch (BioException exc) {
                    throw new BioRuntimeException((Throwable)exc);
                }
            }
            for (i = 0; i <= squery.length(); ++i) {
                scoreMatrix[i][0] = 0;
            }
            for (j = 0; j <= ssubject.length(); ++j) {
                scoreMatrix[0][j] = 0;
            }
            for (i = 1; i <= squery.length(); ++i) {
                for (j = 1; j <= ssubject.length(); ++j) {
                    scoreMatrix[i][j] = this.max(0, scoreMatrix[i - 1][j] + this.delete, scoreMatrix[i][j - 1] + this.insert, scoreMatrix[i - 1][j - 1] + this.matchReplace((Sequence)squery, (Sequence)ssubject, i, j));
                    if (scoreMatrix[i][j] <= scoreMatrix[maxI][maxJ]) continue;
                    maxI = i;
                    maxJ = j;
                }
            }
            try {
                j = maxJ;
                i = maxI;
                while (i > 0) {
                    do {
                        if (scoreMatrix[i][j] == 0) {
                            queryStart = i;
                            subjectStart = j;
                            j = 0;
                            i = 0;
                            continue;
                        }
                        if (scoreMatrix[i][j] == scoreMatrix[i - 1][j - 1] + this.matchReplace((Sequence)squery, (Sequence)ssubject, i, j)) {
                            align[0].insert(0, st.tokenizeSymbol(squery.symbolAt(i--)));
                            align[1].insert(0, st.tokenizeSymbol(ssubject.symbolAt(j--)));
                            continue;
                        }
                        if (scoreMatrix[i][j] == scoreMatrix[i][j - 1] + this.insert) {
                            align[0].insert(0, '-');
                            align[1].insert(0, st.tokenizeSymbol(ssubject.symbolAt(j--)));
                            continue;
                        }
                        align[0].insert(0, st.tokenizeSymbol(squery.symbolAt(i--)));
                        align[1].insert(0, '-');
                    } while (j > 0);
                }
            }
            catch (BioException exc) {
                throw new BioRuntimeException((Throwable)exc);
            }
            try {
                for (i = 0; i < queryStart; ++i) {
                    align[0].insert(0, '-');
                }
                for (i = align[0].length(); i < Math.max(maxI, maxJ); ++i) {
                    align[0].append('-');
                }
                for (i = 0; i < subjectStart; ++i) {
                    align[1].insert(0, '-');
                }
                for (i = align[1].length(); i < Math.max(maxJ, align[0].length()); ++i) {
                    align[1].append('-');
                }
                for (i = align[0].length(); i < align[1].length(); ++i) {
                    align[0].append('-');
                }
                squery = new SimpleGappedSequence((Sequence)new SimpleSequence((SymbolList)new SimpleSymbolList(squery.getAlphabet().getTokenization("token"), align[0].toString()), squery.getURN(), squery.getName(), squery.getAnnotation()));
                ssubject = new SimpleGappedSequence((Sequence)new SimpleSequence((SymbolList)new SimpleSymbolList(ssubject.getAlphabet().getTokenization("token"), align[1].toString()), ssubject.getURN(), ssubject.getName(), ssubject.getAnnotation()));
                AlignmentPair pairalign = new AlignmentPair((Sequence)squery, (Sequence)ssubject, queryStart + 1, maxI, subjectStart + 1, maxJ, this.subMatrix);
                pairalign.setComputationTime(System.currentTimeMillis() - time);
                pairalign.setScore(scoreMatrix[maxI][maxJ]);
                scoreMatrix = null;
                return pairalign;
            }
            catch (BioException exc) {
                throw new BioRuntimeException((Throwable)exc);
            }
        }
        throw new BioRuntimeException("The alphabets of the sequences and the substitution matrix have to be equal.");
    }

    public void setDelete(short del) {
        this.delete = -del;
    }

    public void setGapExt(short ge) {
        this.gapExt = -ge;
    }

    public void setInsert(short ins) {
        this.insert = -ins;
    }

    public void setMatch(short ma) {
        this.match = -ma;
    }

    public void setReplace(short rep) {
        this.replace = -rep;
    }

    public void setSubMatrix(SubstitutionMatrix subMatrix) {
        this.subMatrix = subMatrix;
    }
}

