/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.alignment;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.biojava.bio.BioError;
import org.biojava.bio.alignment.Alignment;
import org.biojava.bio.alignment.UnequalLengthAlignment;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public abstract class AbstractULAlignment
extends AbstractSymbolList
implements UnequalLengthAlignment {
    protected Alphabet alphabet;

    public Symbol symbolAt(int index) {
        try {
            return this.alphabet.getSymbol(new ColAsList(index));
        }
        catch (IllegalSymbolException ire) {
            throw new BioError("Somehow my crossproduct alphabet is incompatible with column " + index, (Throwable)ire);
        }
    }

    @Override
    public List<String> labelsAt(int column) {
        return this.labelsInRange((Location)new RangeLocation(column, column));
    }

    @Override
    public List<String> labelsInRange(Location loc) {
        List labels = this.getLabels();
        Vector<String> labelList = new Vector<String>();
        for (String label : labels) {
            Location seqLoc = this.locInAlignment(label);
            if (!LocationTools.overlaps((Location)loc, (Location)seqLoc)) continue;
            labelList.add(label);
        }
        return labelList;
    }

    public Iterator<SymbolList> symbolListIterator() {
        return new Alignment.SymbolListIterator((Alignment)this);
    }

    protected void debug(String s) {
        System.out.println(s);
    }

    public Object leftMost() {
        List labels = this.getLabels();
        Object leftMost = null;
        Location leftLoc = null;
        Location loc = null;
        for (Object label : labels) {
            loc = this.locInAlignment(label);
            if (leftMost == null) {
                leftMost = label;
                leftLoc = loc;
            }
            if (loc.getMin() < leftLoc.getMin()) {
                leftMost = label;
                leftLoc = loc;
                continue;
            }
            if (loc.getMin() != leftLoc.getMin() || loc.getMax() - loc.getMin() <= leftLoc.getMax() - leftLoc.getMin()) continue;
            leftMost = label;
            leftLoc = loc;
        }
        return this.leftMost();
    }

    public Object rightMost() {
        List labels = this.getLabels();
        Object rightMost = null;
        Location rightLoc = null;
        Location loc = null;
        for (Object label : labels) {
            loc = this.locInAlignment(label);
            if (rightMost == null) {
                rightMost = label;
                rightLoc = loc;
            }
            if (loc.getMin() > rightLoc.getMin()) {
                rightMost = label;
                rightLoc = loc;
                continue;
            }
            if (loc.getMin() != rightLoc.getMin() || loc.getMax() - loc.getMin() <= rightLoc.getMax() - rightLoc.getMin()) continue;
            rightMost = label;
            rightLoc = loc;
        }
        return this.rightMost();
    }

    public Alignment subAlignment(Set<String> labels, Location loc) throws IndexOutOfBoundsException {
        return new SubULAlignment(labels, loc);
    }

    public Alignment subAlignment(Set<String> labels, int min, int max) throws NoSuchElementException {
        return this.subAlignment(labels, LocationTools.makeLocation((int)min, (int)max));
    }

    public SortedSet<String> orderedLables(Comparator<String> comp) {
        TreeSet<String> orderedSet = new TreeSet<String>(comp);
        orderedSet.addAll(this.getLabels());
        return orderedSet;
    }

    public class SubULAlignment
    extends AbstractSymbolList
    implements UnequalLengthAlignment {
        private int start;
        private int end;
        private List<String> subLabels;

        protected SubULAlignment(Set<String> labels, Location loc) throws IndexOutOfBoundsException {
            this.start = loc.getMin();
            this.end = loc.getMax();
            if (this.start < 1 || this.end > AbstractULAlignment.this.length()) {
                throw new IndexOutOfBoundsException();
            }
            if (labels != null) {
                this.subLabels = new ArrayList<String>();
                this.subLabels.addAll(labels);
            } else {
                this.subLabels = AbstractULAlignment.this.labelsInRange((Location)new RangeLocation(this.start, this.end));
            }
        }

        private int realPosition(int pos) {
            return pos + this.start - 1;
        }

        public int length() {
            return this.end - this.start + 1;
        }

        @Override
        public Location locInAlignment(Object label) {
            Location origLoc = AbstractULAlignment.this.locInAlignment(label);
            int min = origLoc.getMin() - this.start + 1;
            int max = origLoc.getMax() - this.start + 1;
            return new RangeLocation(min, max);
        }

        public Alignment subAlignment(Set<String> labels, Location loc) throws NoSuchElementException {
            int min = this.realPosition(loc.getMin());
            int max = this.realPosition(loc.getMax());
            if (labels == null) {
                labels = new TreeSet<String>(this.subLabels);
            } else {
                Vector<String> l = new Vector<String>(labels);
                labels = new TreeSet<String>(this.listIntersection(l, this.subLabels));
            }
            return new SubULAlignment(labels, (Location)new RangeLocation(min, max));
        }

        protected List<String> listIntersection(List<String> s1, List<String> s2) {
            Vector<String> common = new Vector<String>(s1);
            for (String label : s1) {
                if (s2.contains(label)) continue;
                common.remove(label);
            }
            return common;
        }

        @Override
        public List<String> labelsAt(int column) throws IndexOutOfBoundsException {
            return this.labelsInRange((Location)new RangeLocation(column, column));
        }

        @Override
        public List<String> labelsInRange(Location loc) throws IndexOutOfBoundsException {
            int min = this.realPosition(loc.getMin());
            int max = this.realPosition(loc.getMax());
            if (min < this.start || max > this.end) {
                throw new IndexOutOfBoundsException();
            }
            return this.listIntersection(this.subLabels, AbstractULAlignment.this.labelsInRange((Location)new RangeLocation(min, max)));
        }

        public List<String> getLabels() {
            return this.subLabels;
        }

        public Symbol symbolAt(String label, int column) throws NoSuchElementException {
            return AbstractULAlignment.this.symbolAt(label, this.realPosition(column));
        }

        public Symbol symbolAt(int column) throws NoSuchElementException {
            return AbstractULAlignment.this.symbolAt(this.realPosition(column));
        }

        public SymbolList symbolListForLabel(String label) throws NoSuchElementException {
            return AbstractULAlignment.this.symbolListForLabel(label);
        }

        public Alphabet getAlphabet() {
            return AbstractULAlignment.this.getAlphabet();
        }

        public Iterator<SymbolList> symbolListIterator() {
            return new Alignment.SymbolListIterator((Alignment)this);
        }
    }

    public class LeftRightLocationComparator<T>
    implements Comparator<T> {
        @Override
        public int compare(Object o1, Object o2) {
            int ret = 1;
            Location loc1 = AbstractULAlignment.this.locInAlignment(o1);
            Location loc2 = AbstractULAlignment.this.locInAlignment(o2);
            if (loc1.getMin() > loc2.getMin()) {
                ret = 1;
            } else if (loc1.getMin() < loc2.getMin()) {
                ret = -1;
            } else if (loc1.getMin() == loc2.getMin()) {
                int s2;
                int s1 = loc1.getMax() - loc1.getMin() + 1;
                ret = s1 == (s2 = loc2.getMax() - loc2.getMin() + 1) ? 1 : s2 - s1;
            }
            return ret;
        }
    }

    private final class ColAsList<T extends Symbol>
    extends AbstractList<T>
    implements Serializable {
        private static final long serialVersionUID = 4923954639110962683L;
        private final int col;
        private List<String> labels;

        public ColAsList(int col) {
            this.col = col;
            this.labels = AbstractULAlignment.this.getLabels();
        }

        @Override
        public T get(int indx) {
            return (T)AbstractULAlignment.this.symbolAt(this.labels.get(indx), this.col);
        }

        @Override
        public int size() {
            return this.labels.size();
        }
    }
}

