/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.alignment;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class SubstitutionMatrix
implements Serializable {
    private Map<Symbol, Integer> rowSymbols;
    private Map<Symbol, Integer> colSymbols;
    private short[][] matrix;
    private short min;
    private short max;
    private FiniteAlphabet alphabet;
    private String description;
    private String name;
    private static final String newLine = System.getProperty("line.separator");

    public SubstitutionMatrix(FiniteAlphabet alpha, File matrixFile) throws BioException, NumberFormatException, IOException {
        this.alphabet = alpha;
        this.description = "";
        this.name = matrixFile.getName();
        this.rowSymbols = new HashMap<Symbol, Integer>();
        this.colSymbols = new HashMap<Symbol, Integer>();
        this.matrix = this.parseMatrix(matrixFile);
    }

    public SubstitutionMatrix(FiniteAlphabet alpha, String matrixString, String name) throws BioException, NumberFormatException, IOException {
        this.alphabet = alpha;
        this.description = "";
        this.name = name;
        this.rowSymbols = new HashMap<Symbol, Integer>();
        this.colSymbols = new HashMap<Symbol, Integer>();
        this.matrix = this.parseMatrix(matrixString);
    }

    public SubstitutionMatrix(FiniteAlphabet alpha, short match, short replace) {
        int i = 0;
        int j = 0;
        this.alphabet = alpha;
        this.description = "Identity matrix. All replaces and all matches are treated equally.";
        this.name = "IDENTITY_" + match + "_" + replace;
        this.rowSymbols = new HashMap<Symbol, Integer>();
        this.colSymbols = new HashMap<Symbol, Integer>();
        this.matrix = new short[alpha.size()][alpha.size()];
        Symbol[] sym = new Symbol[alpha.size()];
        Iterator iter = alpha.iterator();
        i = 0;
        while (iter.hasNext()) {
            sym[i] = (Symbol)iter.next();
            this.rowSymbols.put(sym[i], new Integer(i));
            this.colSymbols.put(sym[i], new Integer(i));
            ++i;
        }
        for (i = 0; i < this.alphabet.size(); ++i) {
            for (j = 0; j < this.alphabet.size(); ++j) {
                this.matrix[i][j] = sym[i].getMatches().contains(sym[j]) ? match : replace;
            }
        }
    }

    public SubstitutionMatrix(File file) throws NumberFormatException, NoSuchElementException, BioException, IOException {
        this(SubstitutionMatrix.guessAlphabet(file), file);
    }

    public static SubstitutionMatrix getSubstitutionMatrix(BufferedReader reader) throws NumberFormatException, BioException, IOException {
        StringBuffer stringMatrix = new StringBuffer("");
        while (reader.ready()) {
            stringMatrix.append(reader.readLine());
            stringMatrix.append(newLine);
        }
        reader.close();
        String mat = stringMatrix.toString();
        FiniteAlphabet alpha = SubstitutionMatrix.guessAlphabet(new BufferedReader(new StringReader(mat)));
        SubstitutionMatrix matrix = new SubstitutionMatrix(alpha, mat, "unknown");
        return matrix;
    }

    public static SubstitutionMatrix getSubstitutionMatrix(FiniteAlphabet alphabet, BufferedReader reader) throws BioException, IOException {
        if (alphabet == null) {
            throw new NullPointerException("alphabet must not be null");
        }
        if (reader == null) {
            throw new NullPointerException("reader must not be null");
        }
        return new SubstitutionMatrix(alphabet, SubstitutionMatrix.toString(reader), "unknown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toString(BufferedReader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while (reader.ready() && (line = reader.readLine()) != null) {
                sb.append(line);
                sb.append(newLine);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    public static SubstitutionMatrix getSubstitutionMatrix(FiniteAlphabet alphabet, BufferedReader reader, String name) throws BioException, IOException {
        if (alphabet == null) {
            throw new NullPointerException("alphabet must not be null");
        }
        if (reader == null) {
            throw new NullPointerException("reader must not be null");
        }
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        return new SubstitutionMatrix(alphabet, SubstitutionMatrix.toString(reader), name);
    }

    private static BufferedReader readResource(String name) {
        return new BufferedReader(new InputStreamReader(SubstitutionMatrix.class.getResourceAsStream(name)));
    }

    private static SubstitutionMatrix getNucleotideMatrix(String name) {
        try {
            return SubstitutionMatrix.getSubstitutionMatrix(DNATools.getDNA(), SubstitutionMatrix.readResource(name), name);
        }
        catch (BioException e) {
            throw new RuntimeException("could not load substitution matrix " + name + " from classpath", e);
        }
        catch (IOException e) {
            throw new RuntimeException("could not load substitution matrix " + name + " from classpath", e);
        }
    }

    private static SubstitutionMatrix getAminoAcidMatrix(String name) {
        try {
            return SubstitutionMatrix.getSubstitutionMatrix(ProteinTools.getTAlphabet(), SubstitutionMatrix.readResource(name), name);
        }
        catch (BioException e) {
            throw new RuntimeException("could not load substitution matrix " + name + " from classpath", e);
        }
        catch (IOException e) {
            throw new RuntimeException("could not load substitution matrix " + name + " from classpath", e);
        }
    }

    public static SubstitutionMatrix getBlosum100() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM100");
    }

    public static SubstitutionMatrix getBlosum100_50() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM100.50");
    }

    public static SubstitutionMatrix getBlosum30() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM30");
    }

    public static SubstitutionMatrix getBlosum30_50() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM30.50");
    }

    public static SubstitutionMatrix getBlosum35() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM35");
    }

    public static SubstitutionMatrix getBlosum35_50() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM35.50");
    }

    public static SubstitutionMatrix getBlosum40() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM40");
    }

    public static SubstitutionMatrix getBlosum40_50() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM40.50");
    }

    public static SubstitutionMatrix getBlosum45() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM45");
    }

    public static SubstitutionMatrix getBlosum45_50() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM45.50");
    }

    public static SubstitutionMatrix getBlosum50() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM50");
    }

    public static SubstitutionMatrix getBlosum50_50() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM50.50");
    }

    public static SubstitutionMatrix getBlosum55() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM55");
    }

    public static SubstitutionMatrix getBlosum55_50() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM55.50");
    }

    public static SubstitutionMatrix getBlosum60() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM60");
    }

    public static SubstitutionMatrix getBlosum60_50() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM60.50");
    }

    public static SubstitutionMatrix getBlosum62() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM62");
    }

    public static SubstitutionMatrix getBlosum62_50() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM62.50");
    }

    public static SubstitutionMatrix getBlosum65() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM65");
    }

    public static SubstitutionMatrix getBlosum65_50() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM65.50");
    }

    public static SubstitutionMatrix getBlosum70() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM70");
    }

    public static SubstitutionMatrix getBlosum70_50() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM70.50");
    }

    public static SubstitutionMatrix getBlosum75() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM75");
    }

    public static SubstitutionMatrix getBlosum75_50() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM75.50");
    }

    public static SubstitutionMatrix getBlosum80() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM80");
    }

    public static SubstitutionMatrix getBlosum80_50() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM80.50");
    }

    public static SubstitutionMatrix getBlosum85() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM85");
    }

    public static SubstitutionMatrix getBlosum85_50() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM85.50");
    }

    public static SubstitutionMatrix getBlosum90() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM90");
    }

    public static SubstitutionMatrix getBlosum90_50() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUM90.50");
    }

    public static SubstitutionMatrix getBlosumn() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUMN");
    }

    public static SubstitutionMatrix getBlosumn_50() {
        return SubstitutionMatrix.getAminoAcidMatrix("BLOSUMN.50");
    }

    public static SubstitutionMatrix getDayhoff() {
        return SubstitutionMatrix.getAminoAcidMatrix("DAYHOFF");
    }

    public static SubstitutionMatrix getGonnet() {
        return SubstitutionMatrix.getAminoAcidMatrix("GONNET");
    }

    public static SubstitutionMatrix getIdentity() {
        return SubstitutionMatrix.getAminoAcidMatrix("IDENTITY");
    }

    public static SubstitutionMatrix getMatch() {
        return SubstitutionMatrix.getAminoAcidMatrix("MATCH");
    }

    public static SubstitutionMatrix getNuc4_2() {
        return SubstitutionMatrix.getNucleotideMatrix("NUC.4.2");
    }

    public static SubstitutionMatrix getNuc4_4() {
        return SubstitutionMatrix.getNucleotideMatrix("NUC.4.4");
    }

    public static SubstitutionMatrix getPam10() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM10");
    }

    public static SubstitutionMatrix getPam100() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM100");
    }

    public static SubstitutionMatrix getPam110() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM110");
    }

    public static SubstitutionMatrix getPam120() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM120");
    }

    public static SubstitutionMatrix getPam130() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM130");
    }

    public static SubstitutionMatrix getPam140() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM140");
    }

    public static SubstitutionMatrix getPam150() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM150");
    }

    public static SubstitutionMatrix getPam160() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM160");
    }

    public static SubstitutionMatrix getPam170() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM170");
    }

    public static SubstitutionMatrix getPam180() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM180");
    }

    public static SubstitutionMatrix getPam190() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM190");
    }

    public static SubstitutionMatrix getPam20() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM20");
    }

    public static SubstitutionMatrix getPam200() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM200");
    }

    public static SubstitutionMatrix getPam210() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM210");
    }

    public static SubstitutionMatrix getPam220() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM220");
    }

    public static SubstitutionMatrix getPam230() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM230");
    }

    public static SubstitutionMatrix getPam240() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM240");
    }

    public static SubstitutionMatrix getPam250() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM250");
    }

    public static SubstitutionMatrix getPam260() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM260");
    }

    public static SubstitutionMatrix getPam270() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM270");
    }

    public static SubstitutionMatrix getPam280() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM280");
    }

    public static SubstitutionMatrix getPam290() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM290");
    }

    public static SubstitutionMatrix getPam30() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM30");
    }

    public static SubstitutionMatrix getPam300() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM300");
    }

    public static SubstitutionMatrix getPam310() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM310");
    }

    public static SubstitutionMatrix getPam320() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM320");
    }

    public static SubstitutionMatrix getPam330() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM330");
    }

    public static SubstitutionMatrix getPam340() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM340");
    }

    public static SubstitutionMatrix getPam350() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM350");
    }

    public static SubstitutionMatrix getPam360() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM360");
    }

    public static SubstitutionMatrix getPam370() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM370");
    }

    public static SubstitutionMatrix getPam380() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM380");
    }

    public static SubstitutionMatrix getPam390() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM390");
    }

    public static SubstitutionMatrix getPam40() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM40");
    }

    public static SubstitutionMatrix getPam400() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM400");
    }

    public static SubstitutionMatrix getPam410() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM410");
    }

    public static SubstitutionMatrix getPam420() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM420");
    }

    public static SubstitutionMatrix getPam430() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM430");
    }

    public static SubstitutionMatrix getPam440() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM440");
    }

    public static SubstitutionMatrix getPam450() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM450");
    }

    public static SubstitutionMatrix getPam460() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM460");
    }

    public static SubstitutionMatrix getPam470() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM470");
    }

    public static SubstitutionMatrix getPam480() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM480");
    }

    public static SubstitutionMatrix getPam490() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM490");
    }

    public static SubstitutionMatrix getPam50() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM50");
    }

    public static SubstitutionMatrix getPam500() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM500");
    }

    public static SubstitutionMatrix getPam60() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM60");
    }

    public static SubstitutionMatrix getPam70() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM70");
    }

    public static SubstitutionMatrix getPam80() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM80");
    }

    public static SubstitutionMatrix getPam90() {
        return SubstitutionMatrix.getAminoAcidMatrix("PAM90");
    }

    private static FiniteAlphabet guessAlphabet(File file) throws IOException, NoSuchElementException, BioException {
        String fileName = file.getName().toLowerCase();
        if (fileName.contains("pam") || fileName.contains("blosum")) {
            return (FiniteAlphabet)AlphabetManager.alphabetForName((String)"PROTEIN-TERM");
        }
        return SubstitutionMatrix.guessAlphabet(new BufferedReader(new FileReader(file)));
    }

    private static FiniteAlphabet guessAlphabet(BufferedReader reader) throws IOException, BioException {
        String line;
        FiniteAlphabet alphabet = null;
        while (reader.ready() && (line = reader.readLine()) != null) {
            String trim = line.trim();
            if (trim.length() == 0 || trim.charAt(0) == '#' || line.charAt(0) != ' ' && line.charAt(0) != '\t') continue;
            String[] alphabets = new String[]{"DNA", "RNA", "PROTEIN", "PROTEIN-TERM"};
            for (int i = 0; i < alphabets.length; ++i) {
                alphabet = (FiniteAlphabet)AlphabetManager.alphabetForName((String)alphabets[i]);
                SymbolTokenization symtok = alphabet.getTokenization("token");
                StringTokenizer st = new StringTokenizer(trim);
                boolean noError = true;
                int j = 0;
                while (st.hasMoreElements()) {
                    try {
                        symtok.parseToken(st.nextElement().toString());
                    }
                    catch (IllegalSymbolException exc) {
                        noError = false;
                        break;
                    }
                    ++j;
                }
                if (!noError) continue;
                return alphabet;
            }
        }
        throw new BioException("Unknow alphabet used in this substitution matrix");
    }

    private short[][] parseMatrix(Object matrixObj) throws BioException, NumberFormatException, IOException {
        StringTokenizer st;
        String trim;
        String line;
        Reader reader;
        int j = 0;
        int rows = 0;
        int cols = 0;
        SymbolTokenization symtok = this.alphabet.getTokenization("token");
        this.min = Short.MAX_VALUE;
        this.max = Short.MIN_VALUE;
        if (matrixObj instanceof File) {
            reader = new FileReader((File)matrixObj);
        } else if (matrixObj instanceof String) {
            reader = new StringReader(matrixObj.toString());
        } else {
            return null;
        }
        BufferedReader br = new BufferedReader(reader);
        while (br.ready() && (line = br.readLine()) != null) {
            trim = line.trim();
            if (trim.length() == 0) continue;
            if (trim.charAt(0) == '#') {
                this.description = this.description + line.substring(1);
                continue;
            }
            if (line.startsWith(newLine)) continue;
            if (line.charAt(0) == ' ' || line.charAt(0) == '\t') {
                st = new StringTokenizer(trim);
                j = 0;
                while (st.hasMoreElements()) {
                    this.colSymbols.put(symtok.parseToken(st.nextElement().toString()), j);
                    ++j;
                }
                cols = j;
                continue;
            }
            st = new StringTokenizer(trim);
            if (!st.hasMoreElements()) continue;
            this.rowSymbols.put(symtok.parseToken(st.nextElement().toString()), rows++);
        }
        br.close();
        short[][] matrix = new short[rows][cols];
        rows = 0;
        if (matrixObj instanceof File) {
            reader = new FileReader((File)matrixObj);
        } else if (matrixObj instanceof String) {
            reader = new StringReader(matrixObj.toString());
        } else {
            return null;
        }
        br = new BufferedReader(reader);
        while (br.ready() && (line = br.readLine()) != null) {
            trim = line.trim();
            if (trim.length() == 0 || trim.charAt(0) == '#' || line.charAt(0) == ' ' || line.charAt(0) == '\t' || line.startsWith(newLine)) continue;
            st = new StringTokenizer(trim);
            if (st.hasMoreElements()) {
                st.nextElement();
            }
            j = 0;
            while (st.hasMoreElements()) {
                matrix[rows][j] = (short)Math.round(Double.parseDouble(st.nextElement().toString()));
                if (matrix[rows][j] > this.max) {
                    this.max = matrix[rows][j];
                }
                if (matrix[rows][j] < this.min) {
                    this.min = matrix[rows][j];
                }
                ++j;
            }
            ++rows;
        }
        br.close();
        return matrix;
    }

    public short getValueAt(Symbol row, Symbol col) throws BioException {
        if (!this.rowSymbols.containsKey(row) || !this.colSymbols.containsKey(col)) {
            System.err.printf("SubstitutionMatrix: No entry for the symbols %s and %s\n", row.getName(), col.getName());
            return 0;
        }
        return this.matrix[this.rowSymbols.get(row)][this.colSymbols.get(col)];
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public short getMin() {
        return this.min;
    }

    public short getMax() {
        return this.max;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public FiniteAlphabet getAlphabet() {
        return this.alphabet;
    }

    public String stringnifyMatrix() {
        int i = 0;
        StringBuffer matrixString = new StringBuffer();
        Symbol[] colSyms = new Symbol[this.colSymbols.keySet().size()];
        try {
            SymbolTokenization symtok = this.alphabet.getTokenization("default");
            matrixString.append("  ");
            Iterator<Symbol> colKeys = this.colSymbols.keySet().iterator();
            while (colKeys.hasNext()) {
                colSyms[i] = colKeys.next();
                matrixString.append(symtok.tokenizeSymbol(colSyms[i++]).toUpperCase());
                matrixString.append(' ');
            }
            matrixString.append(newLine);
            for (Symbol rowSym : this.rowSymbols.keySet()) {
                matrixString.append(symtok.tokenizeSymbol(rowSym).toUpperCase());
                matrixString.append(' ');
                for (i = 0; i < colSyms.length; ++i) {
                    matrixString.append(this.getValueAt(rowSym, colSyms[i]));
                    matrixString.append(' ');
                }
                matrixString.append(newLine);
            }
        }
        catch (BioException exc) {
            exc.printStackTrace();
        }
        return matrixString.toString();
    }

    public String stringnifyDescription() {
        StringBuffer desc = new StringBuffer();
        StringBuffer line = new StringBuffer();
        line.append("# ");
        StringTokenizer st = new StringTokenizer(this.description, " ");
        while (st.hasMoreElements()) {
            line.append(st.nextElement().toString());
            line.append(' ');
            if (line.length() >= 60) {
                desc.append(line);
                desc.append(newLine);
                if (!st.hasMoreElements()) continue;
                line = new StringBuffer();
                line.append("# ");
                continue;
            }
            if (st.hasMoreElements()) continue;
            desc.append(line);
            desc.append(newLine);
        }
        return desc.toString();
    }

    public String toString() {
        StringBuffer desc = new StringBuffer();
        StringBuffer line = new StringBuffer();
        line.append("# ");
        StringTokenizer st = new StringTokenizer(this.description);
        while (st.hasMoreElements()) {
            line.append(st.nextElement().toString());
            line.append(' ');
            if (line.length() >= 60) {
                desc.append(line);
                desc.append(newLine);
                if (!st.hasMoreElements()) continue;
                line = new StringBuffer();
                line.append("# ");
                continue;
            }
            if (st.hasMoreElements()) continue;
            desc.append(line);
            desc.append(newLine);
        }
        desc.append(this.stringnifyMatrix());
        return desc.toString();
    }

    public void printMatrix() {
        Iterator<Symbol> rowKeys = this.rowSymbols.keySet().iterator();
        while (rowKeys.hasNext()) {
            Iterator<Symbol> colKeys = this.colSymbols.keySet().iterator();
            Symbol rowSym = rowKeys.next();
            System.out.print(rowSym.getName() + "\t");
            while (colKeys.hasNext()) {
                Symbol colSym = colKeys.next();
                int x = this.rowSymbols.get(rowSym);
                int y = this.colSymbols.get(colSym);
                System.out.print(colSym.getName() + "  " + x + " " + y + " " + this.matrix[x][y] + "\t");
            }
            System.out.println(newLine);
        }
        System.out.println(this.toString());
    }

    public SubstitutionMatrix normalizeMatrix() throws BioException, NumberFormatException, IOException {
        int j;
        int i;
        short min = this.getMin();
        short newMax = Short.MIN_VALUE;
        short[][] mat = new short[this.matrix.length][this.matrix[this.matrix.length - 1].length];
        String name = this.getName() + "_normalized";
        String matString = this.stringnifyDescription() + "  ";
        FiniteAlphabet alphabet = this.getAlphabet();
        Map<Symbol, Integer> rowMap = this.rowSymbols;
        Map<Symbol, Integer> colMap = this.colSymbols;
        SymbolTokenization symtok = alphabet.getTokenization("default");
        for (i = 0; i < this.matrix.length; ++i) {
            for (j = 0; j < this.matrix[this.matrix.length - 1].length; ++j) {
                mat[i][j] = (short)(this.matrix[i][j] - min);
                if (mat[i][j] <= newMax) continue;
                newMax = mat[i][j];
            }
        }
        for (i = 0; i < mat.length; ++i) {
            for (j = 0; j < mat[mat.length - 1].length; ++j) {
                mat[i][j] = (short)(mat[i][j] * 10 / newMax);
            }
        }
        Object[] rows = this.rowSymbols.keySet().toArray();
        Object[] cols = this.colSymbols.keySet().toArray();
        for (i = 0; i < cols.length; ++i) {
            matString = matString + symtok.tokenizeSymbol((Symbol)cols[i]) + " ";
        }
        for (i = 0; i < rows.length; ++i) {
            matString = matString + newLine + symtok.tokenizeSymbol((Symbol)rows[i]) + " ";
            for (j = 0; j < cols.length; ++j) {
                matString = matString + mat[rowMap.get((Symbol)rows[i])][colMap.get((Symbol)cols[j])] + " ";
            }
        }
        matString = matString + newLine;
        return new SubstitutionMatrix(alphabet, matString, name);
    }
}

