/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.alignment;

import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.BioException;
import org.biojava.bio.alignment.AlignmentAlgorithm;
import org.biojava.bio.alignment.SimpleAlignment;
import org.biojava.bio.alignment.SubstitutionMatrix;
import org.biojava.bio.seq.GappedSequence;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.SimpleGappedSequence;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class AlignmentPair
extends SimpleAlignment {
    private static final long serialVersionUID = -8834131912021612261L;
    private int identicals;
    private int queryStart;
    private int queryEnd;
    private int nGapsQ;
    private int nGapsS;
    private final Sequence query;
    private int subjectStart;
    private int subjectEnd;
    private int similars;
    private final Sequence subject;
    private final SubstitutionMatrix subMatrix;
    private long time;

    public static AlignmentPair align(Sequence query, Sequence subject, AlignmentAlgorithm algorithm) throws Exception {
        AlignmentPair pair = algorithm.pairwiseAlignment((SymbolList)query, (SymbolList)subject);
        return pair;
    }

    private static Map<String, SymbolList> createHashMap(Sequence s1, Sequence s2) {
        HashMap<String, SymbolList> m = new HashMap<String, SymbolList>();
        m.put(s1.getName(), (SymbolList)s1);
        m.put(s2.getName(), (SymbolList)s2);
        return m;
    }

    public int getQueryStart() {
        return this.queryStart;
    }

    void setQueryStart(int queryStart) throws BioException {
        this.queryStart = queryStart;
        this.init();
    }

    public int getQueryEnd() {
        return this.queryEnd;
    }

    void setQueryEnd(int queryEnd) throws BioException {
        this.queryEnd = queryEnd;
        this.init();
    }

    public int getSubjectStart() {
        return this.subjectStart;
    }

    void setSubjectStart(int subjectStart) throws BioException {
        this.subjectStart = subjectStart;
        this.init();
    }

    public int getSubjectEnd() {
        return this.subjectEnd;
    }

    void setSubjectEnd(int subjectEnd) throws BioException {
        this.subjectEnd = subjectEnd;
        this.init();
    }

    public AlignmentPair(Sequence query, Sequence subject, int queryStart, int queryEnd, int subjectStart, int subjectEnd, SubstitutionMatrix subMatrix) throws IllegalArgumentException, BioException {
        super(AlignmentPair.createHashMap(query, subject));
        this.subMatrix = subMatrix;
        this.query = query;
        this.subject = subject;
        this.queryStart = queryStart;
        this.queryEnd = queryEnd;
        this.subjectStart = subjectStart;
        this.subjectEnd = subjectEnd;
        this.init();
    }

    public AlignmentPair(Sequence query, Sequence subject, SubstitutionMatrix subMatrix) throws IllegalArgumentException, BioException {
        this(query, subject, 1, query.length(), 1, subject.length(), subMatrix);
    }

    private void init() throws BioException {
        this.similars = 0;
        this.identicals = 0;
        this.nGapsQ = 0;
        this.nGapsS = 0;
        for (int i = 0; i < Math.min(this.queryEnd - this.queryStart, this.subjectEnd - this.subjectStart); ++i) {
            Symbol a = this.query.symbolAt(i + this.queryStart);
            Symbol b = this.subject.symbolAt(i + this.subjectStart);
            boolean gap = false;
            if (a.equals(b)) {
                ++this.identicals;
            }
            if (a.equals(this.query.getAlphabet().getGapSymbol())) {
                ++this.nGapsQ;
                gap = true;
            }
            if (b.equals(this.subject.getAlphabet().getGapSymbol())) {
                ++this.nGapsS;
                gap = true;
            }
            if (gap || this.subMatrix == null || this.subMatrix.getValueAt(a, b) <= 0) continue;
            ++this.similars;
        }
    }

    public long getComputationTime() {
        return this.time;
    }

    public int getNumGapsInQuery() {
        return this.nGapsQ;
    }

    public int getNumGapsInSubject() {
        return this.nGapsS;
    }

    public int getNumIdenticals() {
        return this.identicals;
    }

    public int getNumSimilars() {
        return this.similars;
    }

    public float getPercentIdentityQuery() {
        return (float)this.identicals / (float)(this.query.length() - this.nGapsQ) * 100.0f;
    }

    public float getPercentIdentitySubject() {
        return (float)this.identicals / (float)(this.subject.length() - this.nGapsS) * 100.0f;
    }

    public float getPercentSimilarityQuery() {
        return (float)this.similars / (float)this.query.length() * 100.0f;
    }

    public float getPercentSimilaritySubject() {
        return (float)this.similars / (float)this.subject.length() * 100.0f;
    }

    public int getQueryLength() {
        return this.query.length();
    }

    public int getSubjectLength() {
        return this.subject.length();
    }

    public SubstitutionMatrix getSubstitutionMatrix() {
        return this.subMatrix;
    }

    void setComputationTime(long time) {
        this.time = time;
    }

    public String formatOutput() throws BioException {
        return this.formatOutput(60);
    }

    public String formatOutput(int width) throws BioException {
        int i;
        StringBuilder path = new StringBuilder();
        for (i = 0; i < Math.min(this.queryEnd - this.queryStart, this.subjectEnd - this.subjectStart) + 1; ++i) {
            Symbol a = this.query.symbolAt(i + this.queryStart);
            Symbol b = this.subject.symbolAt(i + this.subjectStart);
            if (!(a.equals(this.query.getAlphabet().getGapSymbol()) || b.equals(this.subject.getAlphabet().getGapSymbol()) || this.subMatrix.getValueAt(a, b) < 0 && !a.equals(b))) {
                path.append('|');
                continue;
            }
            path.append(' ');
        }
        int maxLength = path.length();
        Formatter output = new Formatter();
        output.format("%n Time (ms):  %s%n", this.time);
        output.format(" Length:     %d%n", maxLength);
        output.format("  Score:     %d%n", this.getScore());
        output.format("  Query:     %s, Length: %d%n", this.query.getName(), this.query.length() - this.nGapsQ);
        output.format("  Sbjct:     %s, Length: %d%n", this.subject.getName(), this.subject.length() - this.nGapsS);
        output.format(" Identities: %d/%d, i.e., %d %% (query) and %d %% (sbjct)%n", this.identicals, maxLength, Math.round(this.getPercentIdentityQuery()), Math.round(this.getPercentIdentitySubject()));
        output.format(" Similars:   %d/%d, i.e., %d %% (query) and %d %% (sbjct)%n", this.similars, maxLength, Math.round(this.getPercentSimilarityQuery()), Math.round(this.getPercentSimilaritySubject()));
        output.format(" No. gaps:   %d (%d %%) in query and %d (%d %%) in sbjct%n", this.nGapsQ, Math.round(this.getPercentGapsQuery()), this.nGapsS, Math.round(this.getPercentGapsTarget()));
        int queryLPos = this.queryStart;
        int pathLPos = 0;
        int subjectLPos = this.subjectStart;
        int ql = queryLPos - 1;
        int qr = queryLPos - 1;
        int sl = subjectLPos - 1;
        int sr = subjectLPos - 1;
        int widthLeft = String.valueOf(Math.max(this.queryStart, this.queryEnd)).length();
        int widthRight = String.valueOf(Math.max(this.queryEnd, this.subjectEnd)).length() + 1;
        width = Math.max(width - widthLeft - widthRight - 12, 2);
        i = 1;
        while ((double)i <= Math.ceil((double)maxLength / (double)width)) {
            int j;
            int queryRPos = Math.min(this.queryStart + i * width - 1, Math.min(this.queryEnd, this.subjectEnd - this.subjectStart + this.queryStart));
            int qgaps = 0;
            for (j = queryLPos; j <= queryRPos; ++j) {
                if (!this.query.symbolAt(j).equals(this.query.getAlphabet().getGapSymbol())) {
                    ++qr;
                    continue;
                }
                ++qgaps;
            }
            if (qgaps <= queryRPos - queryLPos) {
                ++ql;
            }
            output.format("%nQuery:   %" + widthLeft + "d ", ql);
            output.format("%s ", this.query.subStr(queryLPos, queryRPos));
            output.format("%-" + widthRight + "d%n", qr);
            queryLPos = queryRPos + 1;
            ql = qr;
            int pathRPos = Math.min(i * width, path.length());
            output.format("%-" + (widthLeft + 10) + "c%s", Character.valueOf(' '), path.substring(pathLPos, pathRPos));
            pathLPos = pathRPos;
            int subjectRPos = Math.min(this.subjectStart + i * width - 1, Math.min(this.queryEnd - this.queryStart + this.subjectStart, this.subjectEnd));
            int sgaps = 0;
            for (j = subjectLPos; j <= subjectRPos; ++j) {
                if (!this.subject.symbolAt(j).equals(this.subject.getAlphabet().getGapSymbol())) {
                    ++sr;
                    continue;
                }
                ++sgaps;
            }
            if (sgaps <= subjectRPos - subjectLPos) {
                ++sl;
            }
            output.format("%nSbjct:   %" + widthLeft + "d ", sl);
            output.format("%s ", this.subject.subStr(subjectLPos, subjectRPos));
            output.format("%-" + widthRight + "d%n", sr);
            subjectLPos = subjectRPos + 1;
            sl = sr;
            ++i;
        }
        return output.toString();
    }

    public float getPercentGapsTarget() {
        return (float)this.nGapsS / (float)this.subject.length() * 100.0f;
    }

    public float getPercentGapsQuery() {
        return (float)this.nGapsQ / (float)this.query.length() * 100.0f;
    }

    public GappedSequence getQuery() {
        return this.query instanceof GappedSequence ? (GappedSequence)this.query : new SimpleGappedSequence(this.query);
    }

    public GappedSequence getSubject() {
        return this.subject instanceof GappedSequence ? (GappedSequence)this.subject : new SimpleGappedSequence(this.subject);
    }
}

