/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.alignment;

import java.util.LinkedList;
import java.util.List;
import org.biojava.bio.alignment.AlignmentPair;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.symbol.SymbolList;

public abstract class AlignmentAlgorithm {
    public List<AlignmentPair> alignAll(SequenceIterator source, SequenceDB subjectDB) throws Exception {
        LinkedList<AlignmentPair> l = new LinkedList<AlignmentPair>();
        while (source.hasNext()) {
            Sequence query = source.nextSequence();
            SequenceIterator target = subjectDB.sequenceIterator();
            while (target.hasNext()) {
                try {
                    l.add(this.pairwiseAlignment((SymbolList)query, (SymbolList)target.nextSequence()));
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
        return l;
    }

    public abstract AlignmentPair pairwiseAlignment(SymbolList var1, SymbolList var2) throws Exception;
}

