/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import java.util.ArrayList;
import java.util.List;
import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeGenerator;
import org.biojava.utils.bytecode.Label;

public class InstructionVector
implements CodeGenerator {
    private final List instructions = new ArrayList();
    private final Label startLabel = new Label();
    private final Label endLabel = new Label();
    private StatsCache statsCache = null;

    public void add(CodeGenerator g) {
        this.statsCache = null;
        this.instructions.add(g);
    }

    public int size() {
        return this.instructions.size();
    }

    public void add(int pos, CodeGenerator g) {
        this.statsCache = null;
        this.instructions.add(pos, g);
    }

    public void remove(int pos) {
        this.statsCache = null;
        this.instructions.remove(pos);
    }

    public CodeGenerator generatorAt(int pos) {
        return (CodeGenerator)this.instructions.get(pos);
    }

    public Label getStartLabel() {
        return this.startLabel;
    }

    public Label getEndLabel() {
        return this.endLabel;
    }

    @Override
    public void writeCode(CodeContext ctx) throws CodeException {
        CodeContext subctx = ctx.subContext();
        subctx.open();
        subctx.markLabel(this.startLabel);
        for (CodeGenerator cg : this.instructions) {
            cg.writeCode(subctx);
        }
        subctx.markLabel(this.endLabel);
        subctx.close();
    }

    @Override
    public int stackDepth() {
        StatsCache statsCache = this.getStatsCache();
        return statsCache.depth;
    }

    @Override
    public int stackDelta() {
        StatsCache statsCache = this.getStatsCache();
        return statsCache.delta;
    }

    private StatsCache getStatsCache() {
        if (this.statsCache == null) {
            int depth = 0;
            int delta = 0;
            for (CodeGenerator cg : this.instructions) {
                int dp = cg.stackDepth();
                int dl = cg.stackDelta();
                depth = Math.max(depth, dp += (delta += dl));
            }
            this.statsCache = new StatsCache(depth, delta);
        }
        return this.statsCache;
    }

    private static class StatsCache {
        public final int depth;
        public final int delta;

        public StatsCache(int depth, int delta) {
            this.depth = depth;
            this.delta = delta;
        }
    }
}

