/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.Instruction;

class ClassInstruction
implements Instruction {
    private final CodeClass clazz;
    private final byte opcode;
    private final int delta;

    ClassInstruction(byte op, CodeClass c, int delta) {
        if (c == null) {
            throw new NullPointerException("CodeClass can not be null");
        }
        this.opcode = op;
        this.clazz = c;
        this.delta = delta;
    }

    @Override
    public void writeCode(CodeContext ctx) throws CodeException {
        ctx.writeByte(this.opcode);
        ctx.writeShort(ctx.getConstants().resolveClass(this.clazz));
    }

    @Override
    public int stackDepth() {
        return Math.max(this.delta, 0);
    }

    @Override
    public int stackDelta() {
        return this.delta;
    }
}

