/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.mq.websphere;

import com.ibm.mq.jms.MQQueueConnectionFactory;
import edu.mayo.mq.jms.QueueConnection;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsphereMQConnection
implements QueueConnection {
    private static final Logger logger = LoggerFactory.getLogger(WebsphereMQConnection.class);
    private static final String JKS = "JKS";
    public static final String WEBSPHERE_MQ_CHANNEL = "websphere.mq.channel";
    public static final String WEBSPHERE_MQ_QUEUE_MANAGER = "websphere.mq.queueManager";
    public static final String WEBSPHERE_MQ_USER = "websphere.mq.user";
    public static final String WEBSPHERE_MQ_USER_PASS = "websphere.mq.user.pass";
    public static final String WEBSPHERE_MQ_HOSTNAME_STRING = "websphere.mq.hostnameString";
    public static final String SSL_KEYSTORE_PATH = "ssl.keystore.path";
    public static final String SSL_KEYSTORE_PASS = "ssl.keystore.pass";
    public static final String SSL_CIPHER_SUITE = "ssl.cipher.suite";
    public static final String SSL_VERSION = "ssl.version";
    public static final String CIPHER_SUITE_EXAMPLE_VALUES = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_NULL_SHA,TLS_ECDHE_RSA_WITH_RC4_128_SHA,SSL_RSA_EXPORT_WITH_RC4_40_MD5";
    public static final String SSL_VERSION_EXAMPLE_VALUES = "SSL,SSLv2,SSLv3,TLS,TLSv1,TLSv1.1,TLSv1.2";
    private String userPass;
    private String channel;
    private String queueManager;
    private String user;
    private String hostnameString;
    private String sslKeystorePath;
    private String sslKeystorePass;
    private String sslCipherSuite;
    private String sslVersion;

    public WebsphereMQConnection(Properties props) throws IllegalStateException {
        String userPassFromProps = props.getProperty(WEBSPHERE_MQ_USER_PASS);
        this.checkProp(userPassFromProps, WEBSPHERE_MQ_USER_PASS, "mq_user_password");
        String sslKeystorePassFromProps = props.getProperty(SSL_KEYSTORE_PASS);
        this.checkProp(sslKeystorePassFromProps, SSL_KEYSTORE_PASS, "keystore_password");
        this.setAllProps(props, sslKeystorePassFromProps, userPassFromProps);
    }

    public WebsphereMQConnection(Properties props, String keystorePass, String userPass) throws IllegalStateException {
        this.setAllProps(props, keystorePass, userPass);
    }

    private void setAllProps(Properties props, String keystorePass, String userPass) throws IllegalStateException {
        this.sslKeystorePass = keystorePass;
        this.userPass = userPass;
        if (keystorePass == null) {
            throw new IllegalStateException("Must supply keystore password to WebsphereMQConnection");
        }
        if (userPass == null) {
            throw new IllegalStateException("Must supply user password to WebsphereMQConnection");
        }
        this.queueManager = props.getProperty(WEBSPHERE_MQ_QUEUE_MANAGER);
        this.checkProp(this.queueManager, WEBSPHERE_MQ_QUEUE_MANAGER, "Q30P");
        this.channel = props.getProperty(WEBSPHERE_MQ_CHANNEL);
        this.checkProp(this.channel, WEBSPHERE_MQ_CHANNEL, "Q30P.REFDATA.PUB");
        this.user = props.getProperty(WEBSPHERE_MQ_USER);
        this.checkProp(this.user, WEBSPHERE_MQ_USER, "WA01826");
        this.hostnameString = props.getProperty(WEBSPHERE_MQ_HOSTNAME_STRING);
        this.checkProp(this.hostnameString, WEBSPHERE_MQ_HOSTNAME_STRING, WebsphereMQConnection.composeExampleNameList());
        this.sslKeystorePath = props.getProperty(SSL_KEYSTORE_PATH);
        this.checkProp(this.sslKeystorePath, SSL_KEYSTORE_PATH, "/path/to/keystore.jks");
        this.sslCipherSuite = props.getProperty(SSL_CIPHER_SUITE);
        this.checkProp(this.sslCipherSuite, SSL_CIPHER_SUITE, CIPHER_SUITE_EXAMPLE_VALUES);
        this.sslVersion = props.getProperty(SSL_VERSION);
        this.checkProp(this.sslVersion, SSL_VERSION, SSL_VERSION_EXAMPLE_VALUES);
    }

    private void checkProp(String value, String propName, String exampleValues) throws IllegalStateException {
        if (StringUtils.isBlank((CharSequence)value)) {
            String valueDesc = "value is";
            if (exampleValues.contains(",")) {
                valueDesc = "values are";
            }
            String msg = String.format("%s doesn't have a value. Example %s '%s'", propName, valueDesc, exampleValues);
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public Connection connect() throws JMSException {
        logger.trace("Starting process of connecting to queue");
        logger.debug("Queue Manager: " + this.getQueueManager());
        logger.debug("Channel: " + this.getChannel());
        logger.debug("Hostname: " + this.getHostnameString());
        logger.debug("User: " + this.getUser());
        MQQueueConnectionFactory mqQueueConnectionFactory = new MQQueueConnectionFactory();
        mqQueueConnectionFactory.setChannel(this.getChannel());
        mqQueueConnectionFactory.setQueueManager(this.getQueueManager());
        mqQueueConnectionFactory.setConnectionNameList(this.getHostnameString());
        mqQueueConnectionFactory.setTransportType(1);
        try {
            mqQueueConnectionFactory.setSSLSocketFactory((Object)this.getSSLSocketFactory());
        }
        catch (Exception e) {
            logger.error("Issue with setting SSL Factory for queue: " + e.getMessage());
            throw new JMSException(e.getMessage());
        }
        mqQueueConnectionFactory.setSSLCipherSuite(this.getSSLCipherSuite());
        logger.debug("Making connection to queue");
        return mqQueueConnectionFactory.createConnection(this.getUser(), this.userPass);
    }

    public String getChannel() {
        return this.channel;
    }

    public String getQueueManager() {
        return this.queueManager;
    }

    public String getUser() {
        return this.user;
    }

    public String getHostnameString() {
        return this.hostnameString;
    }

    public String getSSLKeystorePath() {
        return this.sslKeystorePath;
    }

    public String getSSLCipherSuite() {
        return this.sslCipherSuite;
    }

    public String getSSLVersion() {
        return this.sslVersion;
    }

    private static String composeHostPortString(String host, int port) {
        return host + "(" + port + ")";
    }

    private static String composeExampleNameList() {
        ArrayList<String> hostPortList = new ArrayList<String>();
        hostPortList.add(WebsphereMQConnection.composeHostPortString("host1.mayo.edu", 1415));
        hostPortList.add(WebsphereMQConnection.composeHostPortString("host2.mayo.edu", 1415));
        return StringUtils.join(hostPortList, (String)",");
    }

    private SSLSocketFactory getSSLSocketFactory() throws Exception {
        char[] password = this.sslKeystorePass.toCharArray();
        System.setProperty("javax.net.ssl.trustStore", this.getSSLKeystorePath());
        System.setProperty("javax.net.ssl.keyStore", this.getSSLKeystorePath());
        System.setProperty("javax.net.ssl.keyStorePassword", this.sslKeystorePass);
        KeyStore keyStore = KeyStore.getInstance(JKS);
        keyStore.load(new FileInputStream(this.getSSLKeystorePath()), password);
        KeyStore trustStore = KeyStore.getInstance(JKS);
        trustStore.load(new FileInputStream(this.getSSLKeystorePath()), password);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        keyManagerFactory.init(keyStore, password);
        SSLContext sslContext = SSLContext.getInstance(this.getSSLVersion());
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        return sslContext.getSocketFactory();
    }
}

