/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.mq.receiver;

import edu.mayo.mq.receiver.Receiver;
import edu.mayo.mq.sender.Sender;
import java.io.BufferedReader;
import java.io.FileReader;

public class FileReceiver
implements Receiver {
    Tail tail = null;
    boolean keepgoing = true;
    String location;
    long delayMilis = 100L;

    public FileReceiver(String location, Sender s) {
        this.setSender(s);
        this.location = location;
    }

    public FileReceiver(String location, Sender s, long delay) {
        this.setSender(s);
        this.location = location;
        this.delayMilis = delay;
    }

    @Override
    public void setSender(Sender s) {
        this.tail = new Tail();
        this.tail.sender = s;
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public void start() {
        this.tail.setDaemon(true);
        this.tail.start();
    }

    @Override
    public void stop() {
        this.keepgoing = false;
    }

    public class Tail
    extends Thread {
        public Sender sender = null;

        @Override
        public void run() {
            try {
                BufferedReader br = new BufferedReader(new FileReader(FileReceiver.this.location));
                while (FileReceiver.this.keepgoing) {
                    String line = br.readLine();
                    if (line == null) {
                        Thread.sleep(FileReceiver.this.delayMilis);
                        continue;
                    }
                    this.sender.write(line);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

