/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.createcatalog;

import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.bioinformatics.vocab.CoreAttributes;
import edu.mayo.pipes.util.GenomicObjectUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TjsonToCatalogNoJsonParsingPipe
extends AbstractPipe<String, String> {
    private static Logger sLogger = LoggerFactory.getLogger(TjsonToCatalogNoJsonParsingPipe.class);
    private int mJsonCol = -1;
    private boolean mIsJsonOnly = false;
    private boolean mIsFirstRow = true;
    private boolean mIsModifyChrom = true;
    private boolean mIsWarnedOfLandmarkNotFound = false;
    private boolean mIsWarnedOfLandmarkNonString = false;
    private boolean mIsWarnedOfMinbpNonLong = false;
    private boolean mIsWarnedOfMaxbpNonLong = false;
    private boolean mIsWarnedOfMaxbpCalculated = false;
    private List<String> mLandmarksWarned = new ArrayList<String>();
    private final String UNKNOWN = "UNKNOWN";
    private final String LANDMARK = CoreAttributes._landmark.toString();
    private final String MINBP = CoreAttributes._minBP.toString();
    private final String MAXBP = CoreAttributes._maxBP.toString();
    private final String REFALLELE = CoreAttributes._refAllele.toString();
    private final String ALTALLELES = CoreAttributes._altAlleles.toString();

    public TjsonToCatalogNoJsonParsingPipe(int jsonCol, boolean isJsonOnly, boolean isModifyChromosome) {
        this.mJsonCol = jsonCol;
        this.mIsJsonOnly = isJsonOnly;
        this.mIsModifyChrom = isModifyChromosome;
    }

    protected String processNextStart() throws NoSuchElementException {
        String lineIn = this.getNextNonBlankNonHeaderLine();
        this.fixJsonColumnIfFirstDataRow(lineIn);
        String lineOut = this.processLine(lineIn);
        return lineOut;
    }

    private String getNextNonBlankNonHeaderLine() {
        String lineIn = null;
        while (this.isBlankOrHeaderLine(lineIn = (String)this.starts.next())) {
        }
        return lineIn;
    }

    private boolean isBlankOrHeaderLine(String line) {
        return line == null || line.trim().length() == 0 || line.startsWith("#");
    }

    private void fixJsonColumnIfFirstDataRow(String lineIn) {
        if (!this.mIsFirstRow) {
            return;
        }
        this.mIsFirstRow = false;
        if (this.mJsonCol > -1) {
            --this.mJsonCol;
        }
        if (this.mJsonCol <= -1) {
            int colCount = this.getColumnCount(lineIn);
            this.mJsonCol = colCount + this.mJsonCol;
        }
    }

    private int getColumnCount(String lineIn) {
        if (lineIn == null || lineIn.length() == 0) {
            return 0;
        }
        int numCols = 1;
        int idxTab = lineIn.indexOf("\t");
        while (idxTab != -1) {
            ++numCols;
            idxTab = lineIn.indexOf("\t", idxTab + 1);
        }
        return numCols;
    }

    public String processLine(String lineIn) {
        this.throwExceptionIfJsonColumnIndexOutOfRange(lineIn, this.mJsonCol);
        CatalogLine ctgLine = new CatalogLine();
        ctgLine.jsonModified = ctgLine.jsonOriginal = this.getCol(lineIn, this.mJsonCol);
        this.throwExceptionIfBadJson(ctgLine.jsonModified, this.mJsonCol, lineIn);
        this.setChrom(ctgLine);
        this.setMinBp(ctgLine);
        this.setMaxBp(ctgLine);
        return ctgLine.toString(this.mIsJsonOnly);
    }

    private void setChrom(CatalogLine ctgLine) {
        String chrom = ctgLine.chrom = this.getJsonVal(ctgLine.jsonModified, this.LANDMARK);
        if (!this.isChromFound(ctgLine.chrom)) {
            boolean isFoundButEmpty = ctgLine.chrom != null && ctgLine.chrom.trim().length() == 0;
            ctgLine.chrom = "UNKNOWN";
            this.warnChromNotFound(ctgLine.jsonOriginal);
            if (isFoundButEmpty) {
                ctgLine.jsonModified = this.replaceValueInJson(ctgLine.jsonModified, this.LANDMARK, ctgLine.chrom, true);
            }
        } else {
            boolean isChromQuoted = this.isValueQuoted(ctgLine.jsonModified, this.LANDMARK);
            if (!isChromQuoted) {
                this.warnChromNotQuoted(ctgLine.jsonModified);
            }
            if (this.mIsModifyChrom) {
                ctgLine.chrom = this.getStandardizedChrom(ctgLine.chrom, ctgLine.jsonOriginal);
            }
            if (this.mIsModifyChrom && !ctgLine.chrom.equals(chrom) || !isChromQuoted) {
                ctgLine.jsonModified = this.replaceValueInJson(ctgLine.jsonModified, this.LANDMARK, ctgLine.chrom, true);
            }
        }
    }

    private void setMinBp(CatalogLine ctgLine) {
        ctgLine.minBp = this.getStrAsLong(this.getJsonVal(ctgLine.jsonModified, this.MINBP));
        if (this.isValueQuoted(ctgLine.jsonModified, this.MINBP)) {
            this.warnMinBpQuoted(ctgLine.jsonOriginal);
            ctgLine.jsonModified = this.replaceValueInJson(ctgLine.jsonModified, this.MINBP, ctgLine.minBp + "", false);
        }
    }

    private void setMaxBp(CatalogLine ctgLine) {
        ctgLine.maxBp = this.getStrAsLong(this.getJsonVal(ctgLine.jsonModified, this.MAXBP));
        if (this.isValueQuoted(ctgLine.jsonModified, this.MAXBP)) {
            this.warnMaxBpQuoted(ctgLine.jsonOriginal);
            ctgLine.jsonModified = this.replaceValueInJson(ctgLine.jsonModified, this.MAXBP, ctgLine.maxBp + "", false);
        }
        String ref = this.getJsonVal(ctgLine.jsonModified, this.REFALLELE);
        if (ctgLine.maxBp == 0L) {
            if (ctgLine.minBp == 0L || ref == null) {
                return;
            }
            this.warnMaxBpCalculated(ctgLine.jsonOriginal);
            ctgLine.maxBp = ctgLine.minBp + (long)ref.length() - 1L;
            ctgLine.jsonModified = this.replaceValueInJson(ctgLine.jsonModified, this.MAXBP, ctgLine.maxBp + "", false);
        }
        if (this.isMismatchRefAlleleLengthVsPositions(ctgLine, ref)) {
            throw new IllegalArgumentException("Error:  length of the refAllele does not equal (max-min+1): " + ctgLine.jsonModified);
        }
    }

    private boolean isMismatchRefAlleleLengthVsPositions(CatalogLine ctgLine, String ref) {
        if (ctgLine.minBp != 0L && ctgLine.maxBp != 0L && ref != null && ref.length() > 0) {
            String alts = this.getJsonVal(ctgLine.jsonModified, this.ALTALLELES);
            if (TjsonToCatalogNoJsonParsingPipe.hasAnyStructuralVariants(this.splitAltsString(alts))) {
                return false;
            }
            if (ctgLine.maxBp - ctgLine.minBp != (long)(ref.length() - 1)) {
                return true;
            }
        }
        return false;
    }

    private List<String> splitAltsString(String altsStr) {
        ArrayList<String> alts = new ArrayList<String>();
        if (altsStr == null || altsStr.trim().length() == 0) {
            return alts;
        }
        for (String a : altsStr.split(",")) {
            alts.add(this.dequote(a));
        }
        return alts;
    }

    private String dequote(String a) {
        if (a.startsWith("\"") && a.endsWith("\"") && a.length() >= 2) {
            return a.substring(1, a.length() - 1);
        }
        return a;
    }

    protected static boolean hasAnyStructuralVariants(List<String> alts) {
        if (alts == null || alts.size() == 0) {
            return false;
        }
        for (String alt : alts) {
            if (!alt.startsWith("<") || !alt.endsWith(">")) continue;
            return true;
        }
        return false;
    }

    private boolean isValueQuoted(String json, String key) {
        int idxKey = this.getIdxKey(json, key);
        if (idxKey == -1) {
            return false;
        }
        int idxColon = json.indexOf(":", idxKey + key.length());
        return json.charAt(idxColon + 1) == '\"' || json.charAt(idxColon + 1) == '\'';
    }

    private boolean isChromFound(String chrom) {
        return chrom != null && chrom.trim().length() > 0;
    }

    private void warnChromNotFound(String json) {
        if (!this.mIsWarnedOfLandmarkNotFound) {
            sLogger.warn("Warning: " + this.LANDMARK + " was not found (or was empty) on at least one line.  This was replaced with " + "UNKNOWN" + ".  Only first offence shown : " + json);
            this.mIsWarnedOfLandmarkNotFound = true;
        }
    }

    private void warnChromNotQuoted(String json) {
        if (!this.mIsWarnedOfLandmarkNonString) {
            sLogger.warn("Warning: " + this.LANDMARK + " was not a String.  Correcting offending JSON (only first original shown): " + json);
            this.mIsWarnedOfLandmarkNonString = true;
        }
    }

    private void warnMinBpQuoted(String json) {
        if (!this.mIsWarnedOfMinbpNonLong) {
            sLogger.warn("Warning: " + this.MINBP + " was not an integer.  Correcting offending JSON (only first original shown): " + json);
            this.mIsWarnedOfMinbpNonLong = true;
        }
    }

    private void warnMaxBpQuoted(String json) {
        if (!this.mIsWarnedOfMaxbpNonLong) {
            sLogger.warn("Warning: " + this.MAXBP + " was not an integer.  Correcting offending JSON (only first original shown): " + json);
            this.mIsWarnedOfMaxbpNonLong = true;
        }
    }

    private void warnMaxBpCalculated(String json) {
        if (!this.mIsWarnedOfMaxbpCalculated) {
            sLogger.warn("Warning: " + this.MAXBP + " was not specified, so it will be calculated from " + this.MINBP + " and " + this.REFALLELE + " length.");
            sLogger.warn("First offending JSON shown: " + json);
            this.mIsWarnedOfMaxbpCalculated = true;
        }
    }

    private String getStandardizedChrom(String chrom, String jsonOriginal) {
        String chromModified = GenomicObjectUtils.computechr((String)chrom);
        if (!chrom.equals(chromModified) && !this.mLandmarksWarned.contains(chrom)) {
            sLogger.warn("Warning: _landmark was changed from " + chrom + " to " + chromModified + ".  Correcting offending JSON (only first original shown): " + jsonOriginal);
            this.mLandmarksWarned.add(chrom);
        }
        return chromModified;
    }

    private long getStrAsLong(String s) {
        if (s == null || s.trim().length() == 0) {
            return 0L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    protected String replaceValueInJson(String json, String key, String val, boolean isValueQuoted) {
        int idxKey = this.getIdxKey(json, key);
        String QT = "\"";
        if (idxKey != -1) {
            QT = json.charAt(idxKey) + "";
        }
        String quoteIfAny = isValueQuoted ? QT : "";
        String keyAndVal = QT + key + QT + ":" + quoteIfAny + val + quoteIfAny;
        if (idxKey == -1) {
            String commaIfNecessary = json.length() > 2 ? "," : "";
            json = json.substring(0, json.length() - 1) + commaIfNecessary + keyAndVal + "}";
        } else {
            String keyColon = QT + key + QT + ":";
            int idxEnd = json.indexOf(",", idxKey + keyColon.length());
            if (idxEnd == -1) {
                idxEnd = json.length() - 1;
            }
            json = json.substring(0, idxKey) + keyAndVal + json.substring(idxEnd);
        }
        return json;
    }

    private int getIdxKey(String json, String key) {
        String keyColon = "\"" + key + "\":";
        int idxKey = json.indexOf(keyColon);
        if (idxKey == -1) {
            keyColon = "'" + key + "':";
            idxKey = json.indexOf(keyColon);
        }
        return idxKey;
    }

    private String getUnknownChromIfNotFound(String chrom) {
        if (chrom == null || chrom.trim().length() == 0) {
            return "UNKNOWN";
        }
        return chrom.trim();
    }

    public String getJsonVal(String fullJson, String key) {
        boolean isQuoted;
        int idxKey = this.getIdxKey(fullJson, key);
        if (idxKey == -1) {
            return null;
        }
        int idxNextColon = fullJson.indexOf(":", idxKey + key.length() + 3);
        int idxEnd = fullJson.length() - 1;
        if (idxNextColon != -1) {
            idxEnd = fullJson.lastIndexOf(",", idxNextColon);
        }
        int idxStart = fullJson.indexOf(":", idxKey + key.length()) + 1;
        String val = fullJson.substring(idxStart, idxEnd).trim();
        boolean bl = isQuoted = (val = this.removeBracesFromEnd(val)).startsWith("\"") && val.endsWith("\"") || val.startsWith("'") && val.endsWith("'");
        if (isQuoted) {
            val = val.substring(1, val.length() - 1);
        }
        return val;
    }

    private String removeBracesFromEnd(String val) {
        StringBuilder s = new StringBuilder(val);
        for (int x = s.length() - 1; x >= 0 && s.charAt(x) == '}'; --x) {
            s.deleteCharAt(x);
        }
        return s.toString();
    }

    private void throwExceptionIfJsonColumnIndexOutOfRange(String line, int jsonCol) {
        int numCols = this.getColumnCount(line);
        if (numCols == 0 || jsonCol < 0 || jsonCol > numCols - 1) {
            throw new RuntimeException("JSON column (" + jsonCol + ") is out of range on row: " + line);
        }
    }

    private void throwExceptionIfBadJson(String json, int jsonCol, String line) {
        if (!json.startsWith("{") || !json.endsWith("}")) {
            throw new IllegalArgumentException("Bad JSON column data in column " + (jsonCol + 1) + ": " + line);
        }
    }

    private String getCol(String s, int col) {
        int currentCol;
        int idxStart = 0;
        int idxEnd = this.getNextTabIdxOrEnd(s, 0);
        for (currentCol = 0; currentCol < col && idxEnd != s.length(); ++currentCol) {
            idxStart = idxEnd + 1;
            idxEnd = this.getNextTabIdxOrEnd(s, idxStart);
        }
        if (currentCol == col) {
            return s.substring(idxStart, idxEnd);
        }
        return null;
    }

    private int getNextTabIdxOrEnd(String s, int start) {
        int idx = s.indexOf("\t", start);
        if (idx == -1) {
            return s.length();
        }
        return idx;
    }

    class CatalogLine {
        public String jsonOriginal;
        public String jsonModified;
        public String chrom;
        public long minBp;
        public long maxBp;

        CatalogLine() {
        }

        public String toString(boolean isJsonColumnOnly) {
            if (isJsonColumnOnly) {
                return this.jsonModified;
            }
            return this.chrom + "\t" + this.minBp + "\t" + this.maxBp + "\t" + this.jsonModified;
        }
    }
}

