/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import edu.mayo.cli.CommandPlugin;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class ReplaceLinesCommand
implements CommandPlugin {
    private static final String OPTION_FILE_LINES_FROM = "f";
    private static final String OPTION_FILE_LINES_TO = "t";
    Map<String, String> replacementMap = new HashMap<String, String>();

    public void init(Properties properties) throws Exception {
    }

    public void execute(CommandLine cl, Options options) throws Exception {
        File fileLinesFrom = new File(cl.getOptionValue(OPTION_FILE_LINES_FROM));
        File fileLinesTo = new File(cl.getOptionValue(OPTION_FILE_LINES_TO));
        this.loadFiles(fileLinesFrom, fileLinesTo);
        this.replaceLines();
    }

    public void loadFiles(File fileLinesToReplace, File fileLinesToReplaceWith) throws Exception {
        List linesToReplace = Files.readLines((File)fileLinesToReplace, (Charset)Charsets.UTF_8);
        List linesToReplaceWith = Files.readLines((File)fileLinesToReplaceWith, (Charset)Charsets.UTF_8);
        if (linesToReplace.size() != linesToReplaceWith.size()) {
            throw new Exception("ReplaceLine: the two input files must have the same number of lines");
        }
        for (int i = 0; i < linesToReplace.size(); ++i) {
            this.replacementMap.put((String)linesToReplace.get(i), (String)linesToReplaceWith.get(i));
        }
    }

    private void replaceLines() throws IOException {
        BufferedReader fin = new BufferedReader(new InputStreamReader(System.in));
        BufferedWriter fout = new BufferedWriter(new OutputStreamWriter(System.out));
        String line = null;
        while ((line = fin.readLine()) != null) {
            String lineOut = line;
            String lineToReplaceWith = this.replacementMap.get(line);
            if (lineToReplaceWith != null) {
                lineOut = lineToReplaceWith;
            }
            if (lineOut == null || lineOut.length() <= 0) continue;
            System.out.println(lineOut);
        }
        if (fin != null) {
            fin.close();
        }
        if (fout != null) {
            fout.close();
        }
    }
}

