/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble;

import htsjdk.samtools.util.FileExtensions;
import htsjdk.samtools.util.IOUtil;
import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.FeatureReader;
import htsjdk.tribble.TabixFeatureReader;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.TribbleIndexedFeatureReader;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.util.ParsingUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;

public abstract class AbstractFeatureReader<T extends Feature, SOURCE>
implements FeatureReader<T> {
    String path;
    final Function<SeekableByteChannel, SeekableByteChannel> wrapper;
    final Function<SeekableByteChannel, SeekableByteChannel> indexWrapper;
    protected final FeatureCodec<T, SOURCE> codec;
    protected FeatureCodecHeader header;
    private static ComponentMethods methods = new ComponentMethods();
    @Deprecated
    public static final Set<String> BLOCK_COMPRESSED_EXTENSIONS = FileExtensions.BLOCK_COMPRESSED;

    public static <FEATURE extends Feature, SOURCE> AbstractFeatureReader<FEATURE, SOURCE> getFeatureReader(String featureFile, FeatureCodec<FEATURE, SOURCE> codec) throws TribbleException {
        return AbstractFeatureReader.getFeatureReader(featureFile, codec, true);
    }

    public static <FEATURE extends Feature, SOURCE> AbstractFeatureReader<FEATURE, SOURCE> getFeatureReader(String featureResource, FeatureCodec<FEATURE, SOURCE> codec, boolean requireIndex) throws TribbleException {
        return AbstractFeatureReader.getFeatureReader(featureResource, null, codec, requireIndex, null, null);
    }

    public static <FEATURE extends Feature, SOURCE> AbstractFeatureReader<FEATURE, SOURCE> getFeatureReader(String featureResource, String indexResource, FeatureCodec<FEATURE, SOURCE> codec, boolean requireIndex) throws TribbleException {
        return AbstractFeatureReader.getFeatureReader(featureResource, indexResource, codec, requireIndex, null, null);
    }

    public static <FEATURE extends Feature, SOURCE> AbstractFeatureReader<FEATURE, SOURCE> getFeatureReader(String featureResource, String indexResource, FeatureCodec<FEATURE, SOURCE> codec, boolean requireIndex, Function<SeekableByteChannel, SeekableByteChannel> wrapper, Function<SeekableByteChannel, SeekableByteChannel> indexWrapper) throws TribbleException {
        try {
            String pathToDataFile = codec.getPathToDataFile(featureResource);
            if (methods.isTabix(pathToDataFile, indexResource)) {
                if (!(codec instanceof AsciiFeatureCodec)) {
                    throw new TribbleException("Tabix indexed files only work with ASCII codecs, but received non-Ascii codec " + codec.getClass().getSimpleName());
                }
                return new TabixFeatureReader(featureResource, indexResource, (AsciiFeatureCodec)codec, wrapper, indexWrapper);
            }
            return new TribbleIndexedFeatureReader<FEATURE, SOURCE>(featureResource, indexResource, codec, requireIndex, wrapper, indexWrapper);
        }
        catch (IOException e) {
            throw new TribbleException.MalformedFeatureFile("Unable to create BasicFeatureReader using feature file ", featureResource, e);
        }
        catch (TribbleException e) {
            e.setSource(featureResource);
            throw e;
        }
    }

    public static <FEATURE extends Feature, SOURCE> AbstractFeatureReader<FEATURE, SOURCE> getFeatureReader(String featureResource, FeatureCodec<FEATURE, SOURCE> codec, Index index) throws TribbleException {
        try {
            return new TribbleIndexedFeatureReader<FEATURE, SOURCE>(featureResource, codec, index);
        }
        catch (IOException e) {
            throw new TribbleException.MalformedFeatureFile("Unable to create AbstractFeatureReader using feature file ", featureResource, e);
        }
    }

    protected AbstractFeatureReader(String path, FeatureCodec<T, SOURCE> codec) {
        this(path, codec, null, null);
    }

    protected AbstractFeatureReader(String path, FeatureCodec<T, SOURCE> codec, Function<SeekableByteChannel, SeekableByteChannel> wrapper, Function<SeekableByteChannel, SeekableByteChannel> indexWrapper) {
        this.path = codec.getPathToDataFile(path);
        this.codec = codec;
        this.wrapper = wrapper;
        this.indexWrapper = indexWrapper;
    }

    public boolean hasIndex() {
        return false;
    }

    @Override
    public boolean isQueryable() {
        return this.hasIndex();
    }

    public static void setComponentMethods(ComponentMethods methods) {
        AbstractFeatureReader.methods = methods;
    }

    @Deprecated
    public static boolean hasBlockCompressedExtension(String fileName) {
        return IOUtil.hasBlockCompressedExtension(fileName);
    }

    @Deprecated
    public static boolean hasBlockCompressedExtension(File file) {
        return IOUtil.hasBlockCompressedExtension(file.getName());
    }

    @Deprecated
    public static boolean hasBlockCompressedExtension(URI uri) {
        String path = uri.getPath();
        return IOUtil.hasBlockCompressedExtension(path);
    }

    @Override
    public Object getHeader() {
        return this.header.getHeaderValue();
    }

    public static boolean isTabix(String resourcePath, String indexPath) throws IOException {
        if (indexPath == null) {
            indexPath = ParsingUtils.appendToPath(resourcePath, ".tbi");
        }
        return IOUtil.hasBlockCompressedExtension(resourcePath) && ParsingUtils.resourceExists(indexPath);
    }

    public static class ComponentMethods {
        public boolean isTabix(String resourcePath, String indexPath) throws IOException {
            return AbstractFeatureReader.isTabix(resourcePath, indexPath);
        }
    }

    static class EmptyIterator<T extends Feature>
    implements CloseableTribbleIterator<T> {
        EmptyIterator() {
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            return null;
        }

        @Override
        public void remove() {
        }

        @Override
        public void close() {
        }
    }
}

