/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.utils.ValidationUtils;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;

public class IntervalTree<V>
implements Iterable<Node<V>> {
    private Node<V> mRoot;
    private V mSentinel;

    public int size() {
        return this.mRoot == null ? 0 : this.mRoot.getSize();
    }

    public void clear() {
        this.mRoot = null;
    }

    public V put(int start, int end, V value) {
        if (start > end) {
            throw new IllegalArgumentException("Start cannot exceed end. (start=" + start + ", end=" + end + ")");
        }
        V result = this.mSentinel;
        if (this.mRoot == null) {
            this.mRoot = new Node<V>(start, end, value);
        } else {
            Node<V> parent = null;
            Node<V> node = this.mRoot;
            int cmpVal = 0;
            while (node != null) {
                parent = node;
                cmpVal = node.compare(start, end);
                if (cmpVal == 0) break;
                node = cmpVal < 0 ? node.getLeft() : node.getRight();
            }
            if (cmpVal == 0) {
                result = parent.setValue(value);
            } else {
                this.mRoot = cmpVal < 0 ? parent.insertLeft(start, end, value, this.mRoot) : parent.insertRight(start, end, value, this.mRoot);
            }
        }
        return result;
    }

    public V merge(int start, int end, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        ValidationUtils.validateArg(!Objects.equals(value, this.mSentinel), "Values equal to the sentinel value may not be merged");
        V alreadyPresent = this.put(start, end, value);
        if (!Objects.equals(alreadyPresent, this.mSentinel)) {
            V newComputedValue = remappingFunction.apply(value, alreadyPresent);
            if (Objects.equals(newComputedValue, this.mSentinel)) {
                this.remove(start, end);
            } else {
                this.put(start, end, newComputedValue);
            }
            return newComputedValue;
        }
        return value;
    }

    public V remove(int start, int end) {
        V result = this.mSentinel;
        Node<V> node = this.mRoot;
        while (node != null) {
            int cmpVal = node.compare(start, end);
            if (cmpVal == 0) {
                result = node.getValue();
                this.mRoot = node.remove(this.mRoot);
                break;
            }
            node = cmpVal < 0 ? node.getLeft() : node.getRight();
        }
        return result;
    }

    public Node<V> find(int start, int end) {
        int cmpVal;
        Node<V> node = this.mRoot;
        while (node != null && (cmpVal = node.compare(start, end)) != 0) {
            node = cmpVal < 0 ? node.getLeft() : node.getRight();
        }
        return node;
    }

    public Node<V> findByIndex(int idx) {
        return Node.findByRank(this.mRoot, idx + 1);
    }

    public int getIndex(int start, int end) {
        return Node.getRank(this.mRoot, start, end) - 1;
    }

    public Node<V> min() {
        Node<V> result = null;
        for (Node<V> node = this.mRoot; node != null; node = node.getLeft()) {
            result = node;
        }
        return result;
    }

    public Node<V> min(int start, int end) {
        Node<V> result = null;
        Node<V> node = this.mRoot;
        int cmpVal = 0;
        while (node != null) {
            result = node;
            cmpVal = node.compare(start, end);
            if (cmpVal == 0) break;
            node = cmpVal < 0 ? node.getLeft() : node.getRight();
        }
        if (cmpVal > 0) {
            result = result.getNext();
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Node<V> minOverlapper(int start, int end) {
        Node<V> result = null;
        Node<V> node = this.mRoot;
        if (node == null || node.getMaxEnd() < start) return result;
        while (true) {
            if (node.getStart() <= end && start <= node.getEnd()) {
                result = node;
                if ((node = node.getLeft()) != null && node.getMaxEnd() >= start) continue;
                return result;
            }
            Node<V> left = node.getLeft();
            if (left != null && left.getMaxEnd() >= start) {
                node = left;
                continue;
            }
            if (node.getStart() > end || (node = node.getRight()) == null || node.getMaxEnd() < start) return result;
        }
    }

    public Node<V> max() {
        Node<V> result = null;
        for (Node<V> node = this.mRoot; node != null; node = node.getRight()) {
            result = node;
        }
        return result;
    }

    public Node<V> max(int start, int end) {
        Node<V> result = null;
        Node<V> node = this.mRoot;
        int cmpVal = 0;
        while (node != null) {
            result = node;
            cmpVal = node.compare(start, end);
            if (cmpVal == 0) break;
            node = cmpVal < 0 ? node.getLeft() : node.getRight();
        }
        if (cmpVal < 0) {
            result = result.getPrev();
        }
        return result;
    }

    @Override
    public Iterator<Node<V>> iterator() {
        return new FwdIterator(this.min());
    }

    public Iterator<Node<V>> iterator(int start, int end) {
        return new FwdIterator(this.min(start, end));
    }

    public Iterator<Node<V>> overlappers(int start, int end) {
        return new OverlapIterator(start, end);
    }

    public Iterator<Node<V>> reverseIterator() {
        return new RevIterator(this.max());
    }

    public Iterator<Node<V>> reverseIterator(int start, int end) {
        return new RevIterator(this.max(start, end));
    }

    public V getSentinel() {
        return this.mSentinel;
    }

    public V setSentinel(V sentinel) {
        V result = this.mSentinel;
        this.mSentinel = sentinel;
        return result;
    }

    public void checkMaxEnds() {
        if (this.mRoot != null) {
            this.mRoot.checkMaxEnd();
        }
    }

    public void printTree() {
        if (this.mRoot != null) {
            this.mRoot.printNode();
        }
    }

    void removeNode(Node<V> node) {
        this.mRoot = node.remove(this.mRoot);
    }

    public static class ValuesIterator<V1>
    implements Iterator<V1> {
        private final Iterator<Node<V1>> mItr;

        public ValuesIterator(Iterator<Node<V1>> itr) {
            this.mItr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.mItr.hasNext();
        }

        @Override
        public V1 next() {
            return this.mItr.next().getValue();
        }

        @Override
        public void remove() {
            this.mItr.remove();
        }
    }

    public class OverlapIterator
    implements Iterator<Node<V>> {
        private Node<V> mNext;
        private Node<V> mLast;
        private final int mStart;
        private final int mEnd;

        public OverlapIterator(int start, int end) {
            this.mNext = IntervalTree.this.minOverlapper(start, end);
            this.mStart = start;
            this.mEnd = end;
        }

        @Override
        public boolean hasNext() {
            return this.mNext != null;
        }

        @Override
        public Node<V> next() {
            if (this.mNext == null) {
                throw new NoSuchElementException("No next element.");
            }
            if (this.mNext.wasRemoved()) {
                throw new ConcurrentModificationException("Current element was removed.");
            }
            this.mLast = this.mNext;
            this.mNext = Node.getNextOverlapper(this.mNext, this.mStart, this.mEnd);
            return this.mLast;
        }

        @Override
        public void remove() {
            if (this.mLast == null) {
                throw new IllegalStateException("No entry to remove.");
            }
            IntervalTree.this.removeNode(this.mLast);
            this.mLast = null;
        }
    }

    public class RevIterator
    implements Iterator<Node<V>> {
        private Node<V> mNext;
        private Node<V> mLast;

        public RevIterator(Node<V> node) {
            this.mNext = node;
        }

        @Override
        public boolean hasNext() {
            return this.mNext != null;
        }

        @Override
        public Node<V> next() {
            if (this.mNext == null) {
                throw new NoSuchElementException("No next element.");
            }
            if (this.mNext.wasRemoved()) {
                this.mNext = IntervalTree.this.max(this.mNext.getStart(), this.mNext.getEnd());
                if (this.mNext == null) {
                    throw new ConcurrentModificationException("Current element was removed, and there are no more elements.");
                }
            }
            this.mLast = this.mNext;
            this.mNext = this.mNext.getPrev();
            return this.mLast;
        }

        @Override
        public void remove() {
            if (this.mLast == null) {
                throw new IllegalStateException("No entry to remove.");
            }
            IntervalTree.this.removeNode(this.mLast);
            this.mLast = null;
        }
    }

    public class FwdIterator
    implements Iterator<Node<V>> {
        private Node<V> mNext;
        private Node<V> mLast;

        public FwdIterator(Node<V> node) {
            this.mNext = node;
        }

        @Override
        public boolean hasNext() {
            return this.mNext != null;
        }

        @Override
        public Node<V> next() {
            if (this.mNext == null) {
                throw new NoSuchElementException("No next element.");
            }
            if (this.mNext.wasRemoved()) {
                this.mNext = IntervalTree.this.min(this.mNext.getStart(), this.mNext.getEnd());
                if (this.mNext == null) {
                    throw new ConcurrentModificationException("Current element was removed, and there are no more elements.");
                }
            }
            this.mLast = this.mNext;
            this.mNext = this.mNext.getNext();
            return this.mLast;
        }

        @Override
        public void remove() {
            if (this.mLast == null) {
                throw new IllegalStateException("No entry to remove.");
            }
            IntervalTree.this.removeNode(this.mLast);
            this.mLast = null;
        }
    }

    public static class Node<V1> {
        public static final int HAS_LESSER_PART = 1;
        public static final int HAS_OVERLAPPING_PART = 2;
        public static final int HAS_GREATER_PART = 4;
        public static final int IS_ADJACENT_AND_EMPTY = 0;
        public static final int IS_STRICTLY_LESS = 1;
        public static final int IS_SUBSET = 2;
        public static final int IS_LEFT_OVERHANGING_OVERLAPPER = 3;
        public static final int IS_STRICTLY_GREATER = 4;
        public static final int IS_RIGHT_OVERHANGING_OVERLAPPER = 6;
        public static final int IS_SUPERSET = 7;
        private Node<V1> mParent;
        private Node<V1> mLeft;
        private Node<V1> mRight;
        private final int mStart;
        private final int mEnd;
        private V1 mValue;
        private int mSize;
        private int mMaxEnd;
        private boolean mIsBlack;

        Node(int start, int end, V1 value) {
            this.mStart = start;
            this.mEnd = end;
            this.mValue = value;
            this.mSize = 1;
            this.mMaxEnd = this.mEnd;
            this.mIsBlack = true;
        }

        Node(Node<V1> parent, int start, int end, V1 value) {
            this.mParent = parent;
            this.mStart = start;
            this.mEnd = end;
            this.mValue = value;
            this.mMaxEnd = this.mEnd;
            this.mSize = 1;
        }

        public int getStart() {
            return this.mStart;
        }

        public int getEnd() {
            return this.mEnd;
        }

        public int getLength() {
            return this.mEnd - this.mStart + 1;
        }

        public int getRelationship(Node<V1> interval) {
            int result = 0;
            if (this.mStart < interval.getStart()) {
                result = 1;
            }
            if (this.mEnd > interval.getEnd()) {
                result |= 4;
            }
            if (this.mStart <= interval.getEnd() && interval.getStart() <= this.mEnd) {
                result |= 2;
            }
            return result;
        }

        public boolean isAdjacent(Node<V1> interval) {
            return this.mStart == interval.getEnd() + 1 || this.mEnd + 1 == interval.getStart();
        }

        public V1 getValue() {
            return this.mValue;
        }

        public V1 setValue(V1 value) {
            V1 result = this.mValue;
            this.mValue = value;
            return result;
        }

        int getSize() {
            return this.mSize;
        }

        int getMaxEnd() {
            return this.mMaxEnd;
        }

        Node<V1> getLeft() {
            return this.mLeft;
        }

        Node<V1> insertLeft(int start, int end, V1 value, Node<V1> root) {
            this.mLeft = new Node<V1>(this, start, end, value);
            return Node.insertFixup(this.mLeft, root);
        }

        Node<V1> getRight() {
            return this.mRight;
        }

        Node<V1> insertRight(int start, int end, V1 value, Node<V1> root) {
            this.mRight = new Node<V1>(this, start, end, value);
            return Node.insertFixup(this.mRight, root);
        }

        Node<V1> getNext() {
            Node<V1> result;
            if (this.mRight != null) {
                result = this.mRight;
                while (result.mLeft != null) {
                    result = result.mLeft;
                }
            } else {
                Node<V1> node = this;
                result = this.mParent;
                while (result != null && node == result.mRight) {
                    node = result;
                    result = result.mParent;
                }
            }
            return result;
        }

        Node<V1> getPrev() {
            Node<V1> result;
            if (this.mLeft != null) {
                result = this.mLeft;
                while (result.mRight != null) {
                    result = result.mRight;
                }
            } else {
                Node<V1> node = this;
                result = this.mParent;
                while (result != null && node == result.mLeft) {
                    node = result;
                    result = result.mParent;
                }
            }
            return result;
        }

        boolean wasRemoved() {
            return this.mSize == 0;
        }

        Node<V1> remove(Node<V1> root) {
            if (this.mSize == 0) {
                throw new IllegalStateException("Entry was already removed.");
            }
            if (this.mLeft == null) {
                if (this.mRight == null) {
                    if (this.mParent == null) {
                        root = null;
                    } else if (this.mParent.mLeft == this) {
                        this.mParent.mLeft = null;
                        Node.fixup(this.mParent);
                        if (this.mIsBlack) {
                            root = Node.removeFixup(this.mParent, null, root);
                        }
                    } else {
                        this.mParent.mRight = null;
                        Node.fixup(this.mParent);
                        if (this.mIsBlack) {
                            root = Node.removeFixup(this.mParent, null, root);
                        }
                    }
                } else {
                    root = this.spliceOut(this.mRight, root);
                }
            } else if (this.mRight == null) {
                root = this.spliceOut(this.mLeft, root);
            } else {
                Node<V1> next = this.getNext();
                root = next.remove(root);
                next.mParent = this.mParent;
                if (next.mParent == null) {
                    root = next;
                } else if (this.mParent.mLeft == this) {
                    this.mParent.mLeft = next;
                } else {
                    this.mParent.mRight = next;
                }
                next.mLeft = this.mLeft;
                if (next.mLeft != null) {
                    this.mLeft.mParent = next;
                }
                if ((next.mRight = this.mRight) != null) {
                    this.mRight.mParent = next;
                }
                next.mIsBlack = this.mIsBlack;
                next.mSize = this.mSize;
                Node.fixup(next);
            }
            this.mSize = 0;
            return root;
        }

        int compare(int start, int end) {
            int result = 0;
            if (start > this.mStart) {
                result = 1;
            } else if (start < this.mStart) {
                result = -1;
            } else if (end > this.mEnd) {
                result = 1;
            } else if (end < this.mEnd) {
                result = -1;
            }
            return result;
        }

        static <V1> Node<V1> getNextOverlapper(Node<V1> node, int start, int end) {
            do {
                Node<V1> nextNode;
                if ((nextNode = node.mRight) != null && nextNode.mMaxEnd >= start) {
                    node = nextNode;
                    while ((nextNode = node.mLeft) != null && nextNode.mMaxEnd >= start) {
                        node = nextNode;
                    }
                } else {
                    nextNode = node;
                    while ((node = nextNode.mParent) != null && node.mRight == nextNode) {
                        nextNode = node;
                    }
                }
                if (node == null || node.mStart <= end) continue;
                node = null;
            } while (node != null && (node.mStart > end || start > node.mEnd));
            return node;
        }

        static <V1> Node<V1> findByRank(Node<V1> node, int rank) {
            int nodeRank;
            while (node != null && rank != (nodeRank = super.getRank())) {
                if (rank < nodeRank) {
                    node = node.mLeft;
                    continue;
                }
                node = node.mRight;
                rank -= nodeRank;
            }
            return node;
        }

        static <V1> int getRank(Node<V1> node, int start, int end) {
            int rank = 0;
            while (node != null) {
                int cmpVal = node.compare(start, end);
                if (cmpVal < 0) {
                    node = node.mLeft;
                    continue;
                }
                rank += super.getRank();
                if (cmpVal == 0) {
                    return rank;
                }
                node = node.mRight;
            }
            return 0;
        }

        private int getRank() {
            int result = 1;
            if (this.mLeft != null) {
                result = this.mLeft.mSize + 1;
            }
            return result;
        }

        private Node<V1> spliceOut(Node<V1> child, Node<V1> root) {
            child.mParent = this.mParent;
            if (child.mParent == null) {
                root = child;
                child.mIsBlack = true;
            } else {
                if (this.mParent.mLeft == this) {
                    this.mParent.mLeft = child;
                } else {
                    this.mParent.mRight = child;
                }
                Node.fixup(this.mParent);
                if (this.mIsBlack) {
                    root = Node.removeFixup(this.mParent, child, root);
                }
            }
            return root;
        }

        private Node<V1> rotateLeft(Node<V1> root) {
            Node<V1> child = this.mRight;
            int childSize = child.mSize;
            child.mSize = this.mSize;
            this.mSize -= childSize;
            this.mRight = child.mLeft;
            if (this.mRight != null) {
                this.mRight.mParent = this;
                this.mSize += this.mRight.mSize;
            }
            if ((child.mParent = this.mParent) == null) {
                root = child;
            } else if (this == this.mParent.mLeft) {
                this.mParent.mLeft = child;
            } else {
                this.mParent.mRight = child;
            }
            child.mLeft = this;
            this.mParent = child;
            this.setMaxEnd();
            super.setMaxEnd();
            return root;
        }

        private Node<V1> rotateRight(Node<V1> root) {
            Node<V1> child = this.mLeft;
            int childSize = child.mSize;
            child.mSize = this.mSize;
            this.mSize -= childSize;
            this.mLeft = child.mRight;
            if (this.mLeft != null) {
                this.mLeft.mParent = this;
                this.mSize += this.mLeft.mSize;
            }
            if ((child.mParent = this.mParent) == null) {
                root = child;
            } else if (this == this.mParent.mLeft) {
                this.mParent.mLeft = child;
            } else {
                this.mParent.mRight = child;
            }
            child.mRight = this;
            this.mParent = child;
            this.setMaxEnd();
            super.setMaxEnd();
            return root;
        }

        private void setMaxEnd() {
            this.mMaxEnd = this.mEnd;
            if (this.mLeft != null) {
                this.mMaxEnd = Math.max(this.mMaxEnd, this.mLeft.mMaxEnd);
            }
            if (this.mRight != null) {
                this.mMaxEnd = Math.max(this.mMaxEnd, this.mRight.mMaxEnd);
            }
        }

        private static <V1> void fixup(Node<V1> node) {
            do {
                node.mSize = 1;
                node.mMaxEnd = node.mEnd;
                if (node.mLeft != null) {
                    node.mSize += node.mLeft.mSize;
                    node.mMaxEnd = Math.max(node.mMaxEnd, node.mLeft.mMaxEnd);
                }
                if (node.mRight == null) continue;
                node.mSize += node.mRight.mSize;
                node.mMaxEnd = Math.max(node.mMaxEnd, node.mRight.mMaxEnd);
            } while ((node = node.mParent) != null);
        }

        /*
         * Enabled aggressive block sorting
         */
        private static <V1> Node<V1> insertFixup(Node<V1> daughter, Node<V1> root) {
            Node<V1> mom = daughter.mParent;
            Node.fixup(mom);
            while (mom != null && !mom.mIsBlack) {
                block8: {
                    Node<V1> gramma = mom.mParent;
                    Node<V1> auntie = gramma.mLeft;
                    if (auntie == mom) {
                        auntie = gramma.mRight;
                        if (auntie != null && !auntie.mIsBlack) {
                            mom.mIsBlack = true;
                            auntie.mIsBlack = true;
                            gramma.mIsBlack = false;
                            daughter = gramma;
                            break block8;
                        } else {
                            if (daughter == mom.mRight) {
                                root = super.rotateLeft(root);
                                mom = daughter;
                            }
                            mom.mIsBlack = true;
                            gramma.mIsBlack = false;
                            root = super.rotateRight(root);
                            break;
                        }
                    }
                    if (auntie != null && !auntie.mIsBlack) {
                        mom.mIsBlack = true;
                        auntie.mIsBlack = true;
                        gramma.mIsBlack = false;
                        daughter = gramma;
                    } else {
                        if (daughter == mom.mLeft) {
                            root = super.rotateRight(root);
                            mom = daughter;
                        }
                        mom.mIsBlack = true;
                        gramma.mIsBlack = false;
                        root = super.rotateLeft(root);
                        break;
                    }
                }
                mom = daughter.mParent;
            }
            root.mIsBlack = true;
            return root;
        }

        private static <V1> Node<V1> removeFixup(Node<V1> parent, Node<V1> node, Node<V1> root) {
            do {
                Node<V1> sister;
                if (node == parent.mLeft) {
                    sister = parent.mRight;
                    if (!sister.mIsBlack) {
                        sister.mIsBlack = true;
                        parent.mIsBlack = false;
                        root = super.rotateLeft(root);
                        sister = parent.mRight;
                    }
                    if ((sister.mLeft == null || sister.mLeft.mIsBlack) && (sister.mRight == null || sister.mRight.mIsBlack)) {
                        sister.mIsBlack = false;
                        node = parent;
                        continue;
                    }
                    if (sister.mRight == null || sister.mRight.mIsBlack) {
                        sister.mLeft.mIsBlack = true;
                        sister.mIsBlack = false;
                        root = super.rotateRight(root);
                        sister = parent.mRight;
                    }
                    sister.mIsBlack = parent.mIsBlack;
                    parent.mIsBlack = true;
                    sister.mRight.mIsBlack = true;
                    root = super.rotateLeft(root);
                    node = root;
                    continue;
                }
                sister = parent.mLeft;
                if (!sister.mIsBlack) {
                    sister.mIsBlack = true;
                    parent.mIsBlack = false;
                    root = super.rotateRight(root);
                    sister = parent.mLeft;
                }
                if ((sister.mLeft == null || sister.mLeft.mIsBlack) && (sister.mRight == null || sister.mRight.mIsBlack)) {
                    sister.mIsBlack = false;
                    node = parent;
                    continue;
                }
                if (sister.mLeft == null || sister.mLeft.mIsBlack) {
                    sister.mRight.mIsBlack = true;
                    sister.mIsBlack = false;
                    root = super.rotateLeft(root);
                    sister = parent.mLeft;
                }
                sister.mIsBlack = parent.mIsBlack;
                parent.mIsBlack = true;
                sister.mLeft.mIsBlack = true;
                root = super.rotateRight(root);
                node = root;
            } while ((parent = node.mParent) != null && node.mIsBlack);
            node.mIsBlack = true;
            return root;
        }

        public void checkMaxEnd() {
            if (this.mMaxEnd != this.calcMaxEnd()) {
                throw new IllegalStateException("Max end mismatch " + this.mMaxEnd + " vs " + this.calcMaxEnd() + ": " + this);
            }
            if (this.mLeft != null) {
                this.mLeft.checkMaxEnd();
            }
            if (this.mRight != null) {
                this.mRight.checkMaxEnd();
            }
        }

        private int calcMaxEnd() {
            int end = this.mEnd;
            if (this.mLeft != null) {
                end = Math.max(end, this.mLeft.mMaxEnd);
            }
            if (this.mRight != null) {
                end = Math.max(end, this.mRight.mMaxEnd);
            }
            return end;
        }

        public void printNode() {
            this.printNodeInternal("", "root: ");
        }

        private void printNodeInternal(String padding, String tag) {
            System.out.println(padding + tag + " " + this);
            if (this.mLeft != null) {
                super.printNodeInternal(padding + "  ", "left: ");
            }
            if (this.mRight != null) {
                super.printNodeInternal(padding + "  ", "right:");
            }
        }

        public String toString() {
            return "Node(" + this.mStart + "," + this.mEnd + "," + this.mValue + "," + this.mSize + "," + this.mMaxEnd + "," + this.mIsBlack + ")";
        }
    }
}

