/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.variants.vcf;

import htsjdk.beta.exception.HtsjdkIOException;
import htsjdk.beta.io.bundle.SignatureStream;
import htsjdk.beta.plugin.variants.VariantsCodec;
import htsjdk.io.IOPath;
import htsjdk.samtools.util.IOUtil;
import htsjdk.utils.ValidationUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public abstract class VCFCodec
implements VariantsCodec {
    private static final Set<String> extensionMap = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(".vcf");
            this.add(".vcf.gz");
            this.add(".vcf.bgz");
        }
    };

    @Override
    public String getFileFormat() {
        return "VCF";
    }

    @Override
    public boolean canDecodeURI(IOPath ioPath) {
        ValidationUtils.nonNull(ioPath, "ioPath");
        return extensionMap.stream().anyMatch(ext -> ioPath.hasExtension((String)ext));
    }

    @Override
    public int getSignatureLength() {
        return this.getSignatureString().length();
    }

    @Override
    public int getSignatureProbeLength() {
        return 65536;
    }

    @Override
    public boolean canDecodeSignature(SignatureStream probingInputStream, String sourceName) {
        ValidationUtils.nonNull(probingInputStream, "probingInputStream");
        ValidationUtils.nonNull(sourceName, "sourceName");
        byte[] signatureBytes = new byte[this.getSignatureLength()];
        try {
            InputStream wrappedInputStream = IOUtil.isGZIPInputStream(probingInputStream) ? new GZIPInputStream(probingInputStream) : probingInputStream;
            int numRead = wrappedInputStream.read(signatureBytes);
            if (numRead < 0) {
                throw new HtsjdkIOException(String.format("0 bytes read from input stream for %s", sourceName));
            }
        }
        catch (IOException e) {
            throw new HtsjdkIOException(String.format("Failure reading signature from stream for %s", sourceName), e);
        }
        return Arrays.equals(this.getSignatureString().getBytes(), signatureBytes);
    }

    protected abstract String getSignatureString();
}

