/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.reads.htsget.htsgetBAMV1_2;

import htsjdk.beta.codecs.reads.htsget.HtsgetBAMDecoder;
import htsjdk.beta.exception.HtsjdkIOException;
import htsjdk.beta.exception.HtsjdkUnsupportedOperationException;
import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.io.bundle.BundleResource;
import htsjdk.beta.io.bundle.BundleResourceType;
import htsjdk.beta.plugin.interval.HtsInterval;
import htsjdk.beta.plugin.interval.HtsIntervalUtils;
import htsjdk.beta.plugin.interval.HtsQueryRule;
import htsjdk.beta.plugin.reads.ReadsDecoderOptions;
import htsjdk.samtools.DefaultSAMRecordFactory;
import htsjdk.samtools.HtsgetBAMFileReader;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CloseableIterator;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class HtsgetBAMDecoderV1_2
extends HtsgetBAMDecoder {
    final HtsgetBAMFileReader htsgetReader;

    public HtsgetBAMDecoderV1_2(Bundle inputBundle, ReadsDecoderOptions decoderOptions) {
        super(inputBundle, decoderOptions);
        BundleResource readsResource = inputBundle.getOrThrow(BundleResourceType.ALIGNED_READS);
        if (!readsResource.getIOPath().isPresent()) {
            throw new IllegalArgumentException(String.format("Htsget requires an IOPath input resource. The bundle resource %s doesn't contain the required IOPath.", readsResource.getDisplayName()));
        }
        try {
            this.htsgetReader = new HtsgetBAMFileReader(readsResource.getIOPath().get().getURI(), true, ValidationStringency.DEFAULT_STRINGENCY, DefaultSAMRecordFactory.getInstance(), false);
        }
        catch (IOException e) {
            throw new HtsjdkIOException(String.format("Failure opening Htsget reader on %s", readsResource.getIOPath().get()), e);
        }
    }

    @Override
    public SAMFileHeader getHeader() {
        return this.htsgetReader.getFileHeader();
    }

    @Override
    public void close() {
        if (this.htsgetReader != null) {
            this.htsgetReader.close();
        }
    }

    @Override
    public CloseableIterator<SAMRecord> iterator() {
        return this.htsgetReader.getIterator();
    }

    @Override
    public boolean isQueryable() {
        return this.htsgetReader.isQueryable();
    }

    @Override
    public boolean hasIndex() {
        return this.htsgetReader.hasIndex();
    }

    @Override
    public CloseableIterator<SAMRecord> query(String queryString) {
        throw new HtsjdkUnsupportedOperationException("query(string) not implemented");
    }

    @Override
    public CloseableIterator<SAMRecord> query(List<HtsInterval> intervals, HtsQueryRule queryRule) {
        return this.htsgetReader.query(HtsIntervalUtils.toLocatableList(intervals), queryRule == HtsQueryRule.CONTAINED);
    }

    @Override
    public CloseableIterator<SAMRecord> queryStart(String queryName, long start) {
        return this.htsgetReader.queryAlignmentStart(queryName, HtsIntervalUtils.toIntegerSafe(start));
    }

    @Override
    public CloseableIterator<SAMRecord> queryUnmapped() {
        return this.htsgetReader.queryUnmapped();
    }

    @Override
    public Optional<SAMRecord> queryMate(SAMRecord rec) {
        throw new HtsjdkUnsupportedOperationException("queryMate not implemented for htsget BAM reader");
    }
}

